/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.CopyingTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.util.TransitiveClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TransformedIcfgBuilder<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> {
    private final Map<INLOC, OUTLOC> mOldLoc2NewLoc;
    private final Map<IIcfgCallTransition<INLOC>, IcfgCallTransition> mOldCalls2NewCalls;
    private final Set<IProgramVarOrConst> mNewVars;
    private final HashRelation<String, IProgramNonOldVar> mNewModifiedGlobals;
    private final ILocationFactory<INLOC, OUTLOC> mLocationFactory;
    private final IcfgTransformationBacktranslator mBacktranslationTracker;
    private final ITransformulaTransformer mTransformer;
    private final IIcfg<INLOC> mOriginalIcfg;
    private final BasicIcfg<OUTLOC> mResultIcfg;
    private final IcfgEdgeFactory mEdgeFactory;
    private final Collection<IPredicate> mAdditionalAxioms;
    private boolean mIsFinished;
    private ILogger mLogger;

    public TransformedIcfgBuilder(ILogger iLogger, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, IIcfg<INLOC> iIcfg, BasicIcfg<OUTLOC> basicIcfg) {
        this(iLogger, iLocationFactory, icfgTransformationBacktranslator, new CopyingTransformulaTransformer(iLogger, iIcfg.getCfgSmtToolkit().getManagedScript(), iIcfg.getCfgSmtToolkit()), iIcfg, basicIcfg, Collections.emptySet());
    }

    public TransformedIcfgBuilder(ILogger iLogger, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ITransformulaTransformer iTransformulaTransformer, IIcfg<INLOC> iIcfg, BasicIcfg<OUTLOC> basicIcfg) {
        this(iLogger, iLocationFactory, icfgTransformationBacktranslator, iTransformulaTransformer, iIcfg, basicIcfg, Collections.emptySet());
    }

    public TransformedIcfgBuilder(ILogger iLogger, ILocationFactory<INLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ITransformulaTransformer iTransformulaTransformer, IIcfg<INLOC> iIcfg, BasicIcfg<OUTLOC> basicIcfg, Collection<IPredicate> collection) {
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mLocationFactory = Objects.requireNonNull(iLocationFactory);
        this.mBacktranslationTracker = Objects.requireNonNull(icfgTransformationBacktranslator);
        this.mTransformer = Objects.requireNonNull(iTransformulaTransformer);
        this.mOriginalIcfg = Objects.requireNonNull(iIcfg);
        this.mResultIcfg = Objects.requireNonNull(basicIcfg);
        this.mOldLoc2NewLoc = new HashMap<INLOC, OUTLOC>();
        this.mOldCalls2NewCalls = new HashMap<IIcfgCallTransition<INLOC>, IcfgCallTransition>();
        this.mNewVars = new HashSet<IProgramVarOrConst>();
        this.mNewModifiedGlobals = new HashRelation();
        this.mIsFinished = false;
        this.mEdgeFactory = iIcfg.getCfgSmtToolkit().getIcfgEdgeFactory();
        this.mAdditionalAxioms = Objects.requireNonNull(collection);
    }

    public IcfgEdge createNewTransition(OUTLOC OUTLOC, OUTLOC OUTLOC2, IcfgEdge icfgEdge) {
        IcfgInternalTransition icfgInternalTransition;
        assert (!this.mIsFinished);
        if (icfgEdge instanceof IIcfgInternalTransition) {
            if (icfgEdge instanceof Summary && ((Summary)icfgEdge).calledProcedureHasImplementation()) {
                return null;
            }
            icfgInternalTransition = this.createNewLocalTransition((IcfgLocation)OUTLOC, (IcfgLocation)OUTLOC2, (IIcfgInternalTransition<INLOC>)((IIcfgInternalTransition)icfgEdge));
        } else if (icfgEdge instanceof IIcfgCallTransition) {
            icfgInternalTransition = this.createNewCallTransition((IcfgLocation)OUTLOC, (IcfgLocation)OUTLOC2, (IIcfgCallTransition<INLOC>)((IIcfgCallTransition)icfgEdge));
        } else if (icfgEdge instanceof IIcfgReturnTransition) {
            icfgInternalTransition = this.createNewReturnTransition((IcfgLocation)OUTLOC, (IcfgLocation)OUTLOC2, (IIcfgReturnTransition<INLOC, ?>)((IIcfgReturnTransition)icfgEdge));
        } else {
            throw new IllegalArgumentException("Unknown edge type " + icfgEdge.getClass().getSimpleName());
        }
        OUTLOC.addOutgoing((IModifiableMultigraphEdge)icfgInternalTransition);
        OUTLOC2.addIncoming((IModifiableMultigraphEdge)icfgInternalTransition);
        this.mBacktranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)icfgInternalTransition, (IIcfgTransition<IcfgLocation>)icfgEdge);
        return icfgInternalTransition;
    }

    public IcfgEdge createNewTransitionWithNewProgramVars(OUTLOC OUTLOC, OUTLOC OUTLOC2, IcfgEdge icfgEdge) {
        IcfgEdge icfgEdge2 = this.createNewTransition(OUTLOC, OUTLOC2, icfgEdge);
        this.rememberNewVariables(icfgEdge2.getTransformula(), OUTLOC.getProcedure());
        return icfgEdge2;
    }

    public boolean isCorrespondingCallContained(IIcfgReturnTransition<?, ?> iIcfgReturnTransition) {
        IIcfgCallTransition iIcfgCallTransition = iIcfgReturnTransition.getCorrespondingCall();
        IcfgCallTransition icfgCallTransition = this.mOldCalls2NewCalls.get(iIcfgCallTransition);
        return icfgCallTransition != null;
    }

    public IcfgInternalTransition createNewInternalTransition(OUTLOC OUTLOC, OUTLOC OUTLOC2, UnmodifiableTransFormula unmodifiableTransFormula, boolean bl) {
        return this.createNewInternalTransition(OUTLOC, OUTLOC2, unmodifiableTransFormula, null, bl);
    }

    public IcfgInternalTransition createNewInternalTransition(OUTLOC OUTLOC, OUTLOC OUTLOC2, UnmodifiableTransFormula unmodifiableTransFormula, IPayload iPayload, boolean bl) {
        assert (!this.mIsFinished);
        IcfgInternalTransition icfgInternalTransition = this.createNewLocalTransition((IcfgLocation)OUTLOC, (IcfgLocation)OUTLOC2, new ITransformulaTransformer.TransformulaTransformationResult(unmodifiableTransFormula, bl), iPayload);
        OUTLOC.addOutgoing((IModifiableMultigraphEdge)icfgInternalTransition);
        OUTLOC2.addIncoming((IModifiableMultigraphEdge)icfgInternalTransition);
        this.rememberNewVariables(unmodifiableTransFormula, OUTLOC.getProcedure());
        return icfgInternalTransition;
    }

    public OUTLOC createNewLocation(INLOC INLOC) {
        boolean bl = this.mOriginalIcfg.getInitialNodes().contains(INLOC);
        return this.createNewLocation(INLOC, bl);
    }

    public OUTLOC createNewLocation(INLOC INLOC, boolean bl) {
        assert (!this.mIsFinished);
        IcfgLocation icfgLocation = (IcfgLocation)this.mOldLoc2NewLoc.get(INLOC);
        if (icfgLocation != null) {
            return (OUTLOC)icfgLocation;
        }
        String string = INLOC.getProcedure();
        OUTLOC OUTLOC = this.mLocationFactory.createLocation(INLOC, INLOC.getDebugIdentifier(), string);
        Set set = (Set)this.mOriginalIcfg.getProcedureErrorNodes().get(string);
        boolean bl2 = set != null && set.contains(INLOC);
        boolean bl3 = INLOC.equals(this.mOriginalIcfg.getProcedureEntryNodes().get(string));
        boolean bl4 = INLOC.equals(this.mOriginalIcfg.getProcedureExitNodes().get(string));
        boolean bl5 = this.mOriginalIcfg.getLoopLocations().contains(INLOC);
        boolean bl6 = this.mOriginalIcfg.getLocationsOfInterest().contains(INLOC);
        this.mResultIcfg.addLocation(OUTLOC, bl, bl2, bl3, bl4, bl5, bl6);
        this.mOldLoc2NewLoc.put(INLOC, OUTLOC);
        return OUTLOC;
    }

    public boolean hasNewLoc(INLOC INLOC) {
        return this.mOldLoc2NewLoc.get(INLOC) == null;
    }

    public void finish() {
        DefaultIcfgSymbolTable defaultIcfgSymbolTable;
        ModifiableGlobalsTable modifiableGlobalsTable;
        IIcfgSymbolTable iIcfgSymbolTable;
        this.mIsFinished = true;
        CfgSmtToolkit cfgSmtToolkit = this.mOriginalIcfg.getCfgSmtToolkit();
        if (this.mNewVars.isEmpty()) {
            iIcfgSymbolTable = this.mTransformer.getNewIcfgSymbolTable();
            modifiableGlobalsTable = new ModifiableGlobalsTable(this.computeClosure(this.mTransformer.getNewModifiedGlobals(), this.computeCallGraph(), cfgSmtToolkit.getProcedures()));
        } else {
            defaultIcfgSymbolTable = new DefaultIcfgSymbolTable(this.mTransformer.getNewIcfgSymbolTable(), cfgSmtToolkit.getProcedures());
            this.mNewVars.forEach(arg_0 -> ((DefaultIcfgSymbolTable)defaultIcfgSymbolTable).add(arg_0));
            iIcfgSymbolTable = defaultIcfgSymbolTable;
            HashRelation hashRelation = new HashRelation((AbstractRelation)cfgSmtToolkit.getModifiableGlobalsTable().getProcToGlobals());
            this.mNewModifiedGlobals.forEach(entry -> {
                boolean bl = hashRelation.addPair((Object)((String)entry.getKey()), (Object)((IProgramNonOldVar)entry.getValue()));
            });
            modifiableGlobalsTable = new ModifiableGlobalsTable(this.computeClosure((HashRelation<String, IProgramNonOldVar>)hashRelation, this.computeCallGraph(), cfgSmtToolkit.getProcedures()));
        }
        defaultIcfgSymbolTable = this.transformSmtFunctionsAndAxioms(cfgSmtToolkit.getSmtFunctionsAndAxioms(), cfgSmtToolkit.getManagedScript(), iIcfgSymbolTable);
        CfgSmtToolkit cfgSmtToolkit2 = new CfgSmtToolkit(modifiableGlobalsTable, cfgSmtToolkit.getManagedScript(), iIcfgSymbolTable, cfgSmtToolkit.getProcedures(), cfgSmtToolkit.getInParams(), cfgSmtToolkit.getOutParams(), cfgSmtToolkit.getIcfgEdgeFactory(), cfgSmtToolkit.getConcurrencyInformation(), (SmtFunctionsAndAxioms)defaultIcfgSymbolTable);
        this.mResultIcfg.setCfgSmtToolkit(cfgSmtToolkit2);
    }

    private void rememberNewVariables(UnmodifiableTransFormula unmodifiableTransFormula, String string) {
        Object object;
        unmodifiableTransFormula.getInVars().entrySet().stream().map(Map.Entry::getKey).filter(iProgramVar -> !this.oldSymbolTableContains((IProgramVar)iProgramVar)).forEach(this.mNewVars::add);
        Iterator iterator = unmodifiableTransFormula.getOutVars().entrySet().stream().map(Map.Entry::getKey).filter(iProgramVar -> !this.oldSymbolTableContains((IProgramVar)iProgramVar)).iterator();
        while (iterator.hasNext()) {
            object = (IProgramVarOrConst)iterator.next();
            this.mNewVars.add((IProgramVarOrConst)object);
            if (!(object instanceof IProgramNonOldVar) || !unmodifiableTransFormula.getAssignedVars().contains(object)) continue;
            this.mNewModifiedGlobals.addPair((Object)string, (Object)((IProgramNonOldVar)object));
        }
        object = new HashSet(unmodifiableTransFormula.getNonTheoryConsts());
        object.removeAll(this.mOriginalIcfg.getCfgSmtToolkit().getSymbolTable().getConstants());
        this.mNewVars.addAll((Collection<IProgramVarOrConst>)object);
    }

    private boolean oldSymbolTableContains(IProgramVar iProgramVar) {
        if (iProgramVar instanceof IProgramOldVar) {
            return true;
        }
        IIcfgSymbolTable iIcfgSymbolTable = this.mOriginalIcfg.getCfgSmtToolkit().getSymbolTable();
        if (iProgramVar.getProcedure() == null) {
            return iIcfgSymbolTable.getGlobals().contains(iProgramVar);
        }
        return iIcfgSymbolTable.getLocals(iProgramVar.getProcedure()).contains(iProgramVar);
    }

    private HashRelation<String, IProgramNonOldVar> computeClosure(HashRelation<String, IProgramNonOldVar> hashRelation, HashRelation<String, String> hashRelation2, Set<String> set) {
        Object object2;
        assert (this.mIsFinished);
        HashRelation hashRelation3 = new HashRelation();
        for (Object object2 : hashRelation2) {
            hashRelation3.addPair((Object)((String)object2.getValue()), (Object)((String)object2.getKey()));
        }
        object2 = string -> hashRelation3.getImage(string).iterator();
        Function<String, Set> function = arg_0 -> hashRelation.getImage(arg_0);
        HashRelation hashRelation4 = new HashRelation();
        Map map = TransitiveClosure.computeClosure((ILogger)this.mLogger, set, (Function)function, (SccComputation.ISuccessorProvider)object2);
        for (Map.Entry entry : map.entrySet()) {
            for (IProgramNonOldVar iProgramNonOldVar : (Set)entry.getValue()) {
                hashRelation4.addPair((Object)((String)entry.getKey()), (Object)iProgramNonOldVar);
            }
        }
        return hashRelation4;
    }

    private HashRelation<String, String> computeCallGraph() {
        assert (this.mIsFinished);
        HashRelation hashRelation = new HashRelation();
        for (Map.Entry entry : this.mResultIcfg.getProcedureEntryNodes().entrySet()) {
            for (IcfgEdge icfgEdge : ((IcfgLocation)entry.getValue()).getIncomingEdges()) {
                if (!(icfgEdge instanceof IcfgCallTransition)) continue;
                hashRelation.addPair((Object)icfgEdge.getPrecedingProcedure(), (Object)icfgEdge.getSucceedingProcedure());
            }
        }
        return hashRelation;
    }

    private IcfgReturnTransition createNewReturnTransition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, IIcfgReturnTransition<INLOC, ?> iIcfgReturnTransition) {
        IIcfgCallTransition iIcfgCallTransition = iIcfgReturnTransition.getCorrespondingCall();
        IcfgCallTransition icfgCallTransition = this.mOldCalls2NewCalls.get(iIcfgCallTransition);
        assert (icfgCallTransition != null) : "The Icfg has been traversed out of order (found return before having found the corresponding call)";
        ITransformulaTransformer.TransformulaTransformationResult transformulaTransformationResult = this.mTransformer.transform((IIcfgTransition<? extends IcfgLocation>)iIcfgReturnTransition, iIcfgReturnTransition.getAssignmentOfReturn());
        IcfgReturnTransition icfgReturnTransition = this.mEdgeFactory.createReturnTransition(icfgLocation, icfgLocation2, (IIcfgCallTransition)icfgCallTransition, TransformedIcfgBuilder.getPayloadIfAvailable(iIcfgReturnTransition), transformulaTransformationResult.getTransformula(), icfgCallTransition.getTransformula());
        if (transformulaTransformationResult.isOverapproximation()) {
            this.annotateOverapprox((IElement)icfgReturnTransition);
        }
        return icfgReturnTransition;
    }

    private IcfgCallTransition createNewCallTransition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, IIcfgCallTransition<INLOC> iIcfgCallTransition) {
        ITransformulaTransformer.TransformulaTransformationResult transformulaTransformationResult = this.mTransformer.transform((IIcfgTransition<? extends IcfgLocation>)iIcfgCallTransition, iIcfgCallTransition.getLocalVarsAssignment());
        IcfgCallTransition icfgCallTransition = this.mEdgeFactory.createCallTransition(icfgLocation, icfgLocation2, TransformedIcfgBuilder.getPayloadIfAvailable(iIcfgCallTransition), transformulaTransformationResult.getTransformula());
        this.mOldCalls2NewCalls.put(iIcfgCallTransition, icfgCallTransition);
        if (transformulaTransformationResult.isOverapproximation()) {
            this.annotateOverapprox((IElement)icfgCallTransition);
        }
        return icfgCallTransition;
    }

    private IcfgInternalTransition createNewLocalTransition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, IIcfgInternalTransition<INLOC> iIcfgInternalTransition) {
        ITransformulaTransformer.TransformulaTransformationResult transformulaTransformationResult = this.mTransformer.transform((IIcfgTransition<? extends IcfgLocation>)iIcfgInternalTransition, iIcfgInternalTransition.getTransformula());
        IPayload iPayload = TransformedIcfgBuilder.getPayloadIfAvailable(iIcfgInternalTransition);
        return this.createNewLocalTransition(icfgLocation, icfgLocation2, transformulaTransformationResult, iPayload);
    }

    private IcfgInternalTransition createNewLocalTransition(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, ITransformulaTransformer.TransformulaTransformationResult transformulaTransformationResult, IPayload iPayload) {
        IcfgInternalTransition icfgInternalTransition = this.mEdgeFactory.createInternalTransition(icfgLocation, icfgLocation2, iPayload, transformulaTransformationResult.getTransformula());
        if (transformulaTransformationResult.isOverapproximation()) {
            this.annotateOverapprox((IElement)icfgInternalTransition);
        }
        return icfgInternalTransition;
    }

    private void annotateOverapprox(IElement iElement) {
        new Overapprox(this.mTransformer.getName(), null).annotate(iElement);
    }

    private static IPayload getPayloadIfAvailable(IElement iElement) {
        if (iElement == null) {
            return null;
        }
        if (iElement.hasPayload()) {
            return iElement.getPayload();
        }
        return null;
    }

    private SmtFunctionsAndAxioms transformSmtFunctionsAndAxioms(SmtFunctionsAndAxioms smtFunctionsAndAxioms, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable) {
        ITransformulaTransformer.AxiomTransformationResult axiomTransformationResult = this.mTransformer.transform(smtFunctionsAndAxioms.getAxioms());
        if (axiomTransformationResult.isOverapproximation()) {
            throw new UnsupportedOperationException("overapproximation of axioms is not yet supported");
        }
        ManagedScript managedScript2 = this.mOriginalIcfg.getCfgSmtToolkit().getManagedScript();
        if (this.mAdditionalAxioms.isEmpty()) {
            return new SmtFunctionsAndAxioms(axiomTransformationResult.getAxiom(), managedScript2);
        }
        List list = this.mAdditionalAxioms.stream().map(IPredicate::getClosedFormula).collect(Collectors.toList());
        list.add(axiomTransformationResult.getAxiom().getClosedFormula());
        Term term = SmtUtils.and((Script)managedScript2.getScript(), list);
        TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns((Term)term, (ManagedScript)managedScript, (IIcfgSymbolTable)iIcfgSymbolTable);
        return new SmtFunctionsAndAxioms(term, termVarsFuns.getFuns(), managedScript2);
    }
}

