/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.AstarAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.CollectionEdgeDenier;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.IEdgeDenier;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.IGraph;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.IHeuristic;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.OpenItem;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashedPriorityQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class AStar<V, E> {
    private static final String INDENT = "   ";
    private final ILogger mLogger;
    private final IHeuristic<V, E> mHeuristic;
    private final V mStart;
    private final V mTarget;
    private final IEdgeDenier<E> mEdgeDenier;
    private final IGraph<V, E> mGraph;
    private final IProgressAwareTimer mTimer;

    public AStar(ILogger iLogger, V v, V v2, IHeuristic<V, E> iHeuristic, IGraph<V, E> iGraph, IProgressAwareTimer iProgressAwareTimer) {
        this(iLogger, v, v2, iHeuristic, iGraph, new NoEdgeDenier(), iProgressAwareTimer);
    }

    public AStar(ILogger iLogger, V v, V v2, IHeuristic<V, E> iHeuristic, IGraph<V, E> iGraph, Collection<E> collection, IProgressAwareTimer iProgressAwareTimer) {
        this(iLogger, v, v2, iHeuristic, iGraph, new CollectionEdgeDenier<E>(collection), iProgressAwareTimer);
    }

    public AStar(ILogger iLogger, V v, V v2, IHeuristic<V, E> iHeuristic, IGraph<V, E> iGraph, IEdgeDenier<E> iEdgeDenier, IProgressAwareTimer iProgressAwareTimer) {
        this.mLogger = iLogger;
        this.mHeuristic = iHeuristic;
        this.mStart = v;
        this.mTarget = v2;
        this.mEdgeDenier = iEdgeDenier;
        this.mGraph = iGraph;
        this.mTimer = iProgressAwareTimer;
    }

    public List<E> findPath() {
        OpenItem<V, E> openItem = this.createInitialSuccessorItem(this.mStart);
        for (E e : this.mGraph.getOutgoingEdges(this.mStart)) {
            if (this.mEdgeDenier.isForbidden(e, new BackpointerIterator(openItem.getAnnotation()))) {
                if (!this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug((Object)("Forbidden [" + e.hashCode() + "] " + String.valueOf(e)));
                continue;
            }
            if (!this.mGraph.getTarget(e).equals(this.mTarget)) continue;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Found trivial path from source " + String.valueOf(this.mStart) + " to target " + String.valueOf(this.mTarget) + ": " + String.valueOf(e)));
            }
            return Collections.singletonList(e);
        }
        return this.astar(openItem);
    }

    private List<E> astar(OpenItem<V, E> openItem3) {
        HashedPriorityQueue hashedPriorityQueue = new HashedPriorityQueue((openItem, openItem2) -> Integer.compare(openItem.getAnnotation().getExpectedCostToTarget(), openItem2.getAnnotation().getExpectedCostToTarget()));
        hashedPriorityQueue.add(openItem3);
        this.expandNode((OpenItem)hashedPriorityQueue.poll(), hashedPriorityQueue);
        List<E> list = null;
        while (!hashedPriorityQueue.isEmpty()) {
            this.checkTimeout();
            OpenItem openItem4 = (OpenItem)hashedPriorityQueue.poll();
            if (openItem4.getNode().equals(this.mTarget)) {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)"Found target");
                }
                list = this.createPath(openItem4);
                if (!this.mLogger.isDebugEnabled()) break;
                this.mLogger.debug((Object)String.format("Found path of length %s from source %s to target %s: %s", list.size(), this.mStart, this.mTarget, CoreUtil.join(list, (String)", ")));
                break;
            }
            this.expandNode(openItem4, hashedPriorityQueue);
        }
        if (list == null) {
            this.mLogger.warn((Object)String.format("Did not find a path from source %s to target %s!", this.mStart, this.mTarget));
        }
        return list;
    }

    private void checkTimeout() {
        if (!this.mTimer.continueProcessing()) {
            this.mLogger.warn((Object)"Received timeout, aborting AStar engine");
            throw new ToolchainCanceledException(this.getClass());
        }
    }

    private void expandNode(OpenItem<V, E> openItem, HashedPriorityQueue<OpenItem<V, E>> hashedPriorityQueue) {
        V v = openItem.getNode();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Expanding " + String.valueOf(v)));
        }
        Collection<E> collection = this.mGraph.getOutgoingEdges(v);
        AstarAnnotation<E> astarAnnotation = openItem.getAnnotation();
        for (E e : collection) {
            if (this.mEdgeDenier.isForbidden(e, new BackpointerIterator(astarAnnotation))) {
                if (!this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug((Object)("   Forbidden [" + e.hashCode() + "] " + String.valueOf(e)));
                continue;
            }
            V v2 = this.mGraph.getTarget(e);
            OpenItem<V, E> openItem2 = this.createSuccessorItem(openItem, e);
            AstarAnnotation<E> astarAnnotation2 = openItem2.getAnnotation();
            int n = astarAnnotation.getCostSoFar() + this.mHeuristic.getConcreteCost(e);
            if (hashedPriorityQueue.contains(openItem2) && n >= astarAnnotation2.getCostSoFar()) {
                if (!this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug((Object)("   Not worthy [" + e.hashCode() + "][" + astarAnnotation2.hashCode() + "] " + String.valueOf(e)));
                continue;
            }
            int n2 = n + this.mHeuristic.getHeuristicValue(v2, e, this.mTarget);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("   CostSoFar=" + n + " ExpectedCost " + n2));
            }
            hashedPriorityQueue.remove(openItem2);
            astarAnnotation2.setExpectedCostToTarget(n2);
            if (astarAnnotation2.isLowest()) {
                astarAnnotation2.setBackPointers(e, astarAnnotation);
                astarAnnotation2.setCostSoFar(n);
                hashedPriorityQueue.add(openItem2);
                if (!this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug((Object)("   Considering [" + e.hashCode() + "][" + astarAnnotation2.hashCode() + "] " + String.valueOf(e) + " --> " + String.valueOf(v2)));
                continue;
            }
            if (!this.mLogger.isDebugEnabled()) continue;
            this.mLogger.debug((Object)("   Already closed  [" + e.hashCode() + "][" + astarAnnotation2.hashCode() + "] " + String.valueOf(e) + " --> " + String.valueOf(v2)));
        }
    }

    private List<E> createPath(OpenItem<V, E> openItem) {
        assert (openItem.getNode() == this.mTarget);
        BackpointerIterator backpointerIterator = new BackpointerIterator(openItem.getAnnotation());
        ArrayList arrayList = new ArrayList();
        while (backpointerIterator.hasNext()) {
            arrayList.add(backpointerIterator.next());
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private OpenItem<V, E> createSuccessorItem(OpenItem<V, E> openItem, E e) {
        V v = this.mGraph.getTarget(e);
        if (openItem == null) {
            HashMap hashMap = new HashMap();
            V v2 = this.mGraph.getSource(e);
            hashMap.put(v2, new AstarAnnotation());
            hashMap.put(v, new AstarAnnotation());
            return new OpenItem(v, hashMap);
        }
        OpenItem<V, E> openItem2 = new OpenItem<V, E>(v, openItem);
        if (this.mGraph.beginScope(e)) {
            openItem2.getAnnotations().beginScope();
        } else if (this.mGraph.endScope(e)) {
            if (openItem2.getAnnotations().getScopesCount() == 0) {
                this.mLogger.warn((Object)("Allowing successor \"" + String.valueOf(e) + "\" although there is no preceeding beginScope (e.g., a call) on this path"));
            } else {
                openItem2.getAnnotations().endScope();
            }
        }
        AstarAnnotation<E> astarAnnotation = openItem2.getAnnotations().get(v);
        if (astarAnnotation == null) {
            astarAnnotation = new AstarAnnotation();
            openItem2.getAnnotations().put((AstarAnnotation<E>)v, astarAnnotation);
        }
        return openItem2;
    }

    private OpenItem<V, E> createInitialSuccessorItem(V v) {
        HashMap hashMap = new HashMap();
        hashMap.put(v, new AstarAnnotation());
        return new OpenItem(v, hashMap);
    }

    private final class BackpointerIterator
    implements Iterator<E> {
        private AstarAnnotation<E> mAnnotation;
        private final Set<AstarAnnotation<E>> mClosed;

        private BackpointerIterator(AstarAnnotation<E> astarAnnotation) {
            this.mAnnotation = astarAnnotation;
            this.mClosed = new HashSet();
        }

        @Override
        public boolean hasNext() {
            return this.mAnnotation != null && this.mAnnotation.getEdge() != null && !this.mClosed.contains(this.mAnnotation);
        }

        @Override
        public E next() {
            Object e = this.mAnnotation.getEdge();
            if (e == null) {
                throw new NoSuchElementException();
            }
            if (!this.mClosed.add(this.mAnnotation)) {
                throw new NoSuchElementException();
            }
            this.mAnnotation = this.mAnnotation.getBackpointer();
            return e;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static final class NoEdgeDenier<E>
    implements IEdgeDenier<E> {
        private NoEdgeDenier() {
        }

        @Override
        public boolean isForbidden(E e, Iterator<E> iterator) {
            return false;
        }
    }
}

