/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.congruence;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public final class CongruenceDomainValue
implements Comparable<CongruenceDomainValue>,
INonrelationalValue<CongruenceDomainValue> {
    private BigInteger mValue = null;
    private boolean mIsBottom = true;
    private boolean mIsConstant = false;
    private boolean mNonZero = false;

    private CongruenceDomainValue() {
    }

    protected static CongruenceDomainValue createTop() {
        return CongruenceDomainValue.createNonConstant(BigInteger.ONE);
    }

    protected static CongruenceDomainValue createBottom() {
        return new CongruenceDomainValue();
    }

    protected static CongruenceDomainValue createNonConstant(BigInteger bigInteger, boolean bl) {
        if (bigInteger.signum() == 0) {
            return bl ? CongruenceDomainValue.createBottom() : CongruenceDomainValue.createConstant(BigInteger.ZERO);
        }
        CongruenceDomainValue congruenceDomainValue = new CongruenceDomainValue();
        congruenceDomainValue.mValue = bigInteger.abs();
        congruenceDomainValue.mNonZero = bl;
        congruenceDomainValue.mIsBottom = false;
        return congruenceDomainValue;
    }

    protected static CongruenceDomainValue createNonConstant(BigInteger bigInteger) {
        return CongruenceDomainValue.createNonConstant(bigInteger, false);
    }

    protected static CongruenceDomainValue createConstant(BigInteger bigInteger) {
        CongruenceDomainValue congruenceDomainValue = new CongruenceDomainValue();
        congruenceDomainValue.mValue = bigInteger;
        congruenceDomainValue.mNonZero = bigInteger.signum() != 0;
        congruenceDomainValue.mIsBottom = false;
        congruenceDomainValue.mIsConstant = true;
        return congruenceDomainValue;
    }

    @Override
    public boolean isBottom() {
        return this.mIsBottom;
    }

    @Override
    public boolean isTop() {
        return !this.mIsBottom && !this.mNonZero && !this.mIsConstant && this.mValue.equals(BigInteger.ONE);
    }

    protected BigInteger value() {
        return this.mValue;
    }

    protected boolean isConstant() {
        return this.mIsConstant;
    }

    @Override
    public int compareTo(CongruenceDomainValue congruenceDomainValue) {
        throw new UnsupportedOperationException("The compareTo operation is not defined on congruence clases and can therefore not be used.");
    }

    @Override
    public CongruenceDomainValue merge(CongruenceDomainValue congruenceDomainValue) {
        if (congruenceDomainValue == null) {
            return CongruenceDomainValue.createBottom();
        }
        if (this.mIsBottom) {
            return congruenceDomainValue.copy();
        }
        if (congruenceDomainValue.mIsBottom) {
            return this.copy();
        }
        if (this.mValue.equals(congruenceDomainValue.mValue) && this.mIsConstant && congruenceDomainValue.mIsConstant) {
            return this.copy();
        }
        return CongruenceDomainValue.createNonConstant(this.mValue.gcd(congruenceDomainValue.mValue), this.mNonZero && congruenceDomainValue.mNonZero);
    }

    @Override
    public CongruenceDomainValue intersect(CongruenceDomainValue congruenceDomainValue) {
        if (congruenceDomainValue == null || this.mIsBottom || congruenceDomainValue.mIsBottom) {
            return CongruenceDomainValue.createBottom();
        }
        if (this.mIsConstant && congruenceDomainValue.mIsConstant) {
            if (this.mValue.equals(congruenceDomainValue.mValue)) {
                return this.copy();
            }
            return CongruenceDomainValue.createBottom();
        }
        if (this.mIsConstant) {
            if (congruenceDomainValue.mNonZero && this.mValue.signum() == 0) {
                return CongruenceDomainValue.createBottom();
            }
            if (this.mValue.mod(congruenceDomainValue.mValue.abs()).signum() == 0) {
                return this.copy();
            }
            return CongruenceDomainValue.createBottom();
        }
        if (congruenceDomainValue.mIsConstant) {
            if (this.mNonZero && congruenceDomainValue.mValue.signum() == 0) {
                return CongruenceDomainValue.createBottom();
            }
            if (congruenceDomainValue.mValue.mod(this.mValue.abs()).signum() == 0) {
                return congruenceDomainValue.copy();
            }
            return CongruenceDomainValue.createBottom();
        }
        return CongruenceDomainValue.createNonConstant(this.mValue.multiply(congruenceDomainValue.mValue).divide(this.mValue.gcd(congruenceDomainValue.mValue)), this.mNonZero || congruenceDomainValue.mNonZero);
    }

    @Override
    public CongruenceDomainValue add(CongruenceDomainValue congruenceDomainValue) {
        if (congruenceDomainValue == null || this.mIsBottom || congruenceDomainValue.mIsBottom) {
            return CongruenceDomainValue.createBottom();
        }
        if (this.mValue.signum() == 0) {
            return congruenceDomainValue.copy();
        }
        if (congruenceDomainValue.mValue.signum() == 0) {
            return this.copy();
        }
        if (this.mIsConstant && congruenceDomainValue.mIsConstant) {
            return CongruenceDomainValue.createConstant(this.mValue.add(congruenceDomainValue.mValue));
        }
        boolean bl = false;
        if (this.mIsConstant) {
            boolean bl2 = bl = this.mValue.mod(congruenceDomainValue.mValue).signum() != 0;
        }
        if (congruenceDomainValue.mIsConstant) {
            bl = congruenceDomainValue.mValue.mod(this.mValue).signum() != 0;
        }
        return CongruenceDomainValue.createNonConstant(this.mValue.gcd(congruenceDomainValue.mValue), bl);
    }

    @Override
    public CongruenceDomainValue subtract(CongruenceDomainValue congruenceDomainValue) {
        if (congruenceDomainValue == null || this.mIsBottom || congruenceDomainValue.mIsBottom) {
            return CongruenceDomainValue.createBottom();
        }
        if (this.mValue.signum() == 0) {
            return congruenceDomainValue.negate();
        }
        if (congruenceDomainValue.mValue.signum() == 0) {
            return this.copy();
        }
        if (this.mIsConstant && congruenceDomainValue.mIsConstant) {
            return CongruenceDomainValue.createConstant(this.mValue.subtract(congruenceDomainValue.mValue));
        }
        boolean bl = false;
        if (this.mIsConstant) {
            boolean bl2 = bl = this.mValue.mod(congruenceDomainValue.mValue).signum() != 0;
        }
        if (congruenceDomainValue.mIsConstant) {
            bl = congruenceDomainValue.mValue.mod(this.mValue).signum() != 0;
        }
        return CongruenceDomainValue.createNonConstant(this.mValue.gcd(congruenceDomainValue.mValue), bl);
    }

    protected CongruenceDomainValue mod(CongruenceDomainValue congruenceDomainValue) {
        if (congruenceDomainValue == null || this.mIsBottom || congruenceDomainValue.mIsBottom) {
            return CongruenceDomainValue.createBottom();
        }
        if (!congruenceDomainValue.mNonZero) {
            return CongruenceDomainValue.createTop();
        }
        if (this.mIsConstant && congruenceDomainValue.mIsConstant) {
            return CongruenceDomainValue.createConstant(this.mValue.mod(congruenceDomainValue.mValue.abs()));
        }
        if (this.mIsConstant && this.mValue.signum() >= 0 && this.mValue.compareTo(congruenceDomainValue.mValue) < 0) {
            return CongruenceDomainValue.createConstant(this.mValue);
        }
        if (congruenceDomainValue.mIsConstant && this.mValue.mod(congruenceDomainValue.mValue.abs()).signum() == 0) {
            return CongruenceDomainValue.createConstant(BigInteger.ZERO);
        }
        return CongruenceDomainValue.createNonConstant(this.mValue.gcd(congruenceDomainValue.mValue), this.mIsConstant && this.mValue.mod(congruenceDomainValue.mValue).signum() != 0);
    }

    @Override
    public CongruenceDomainValue multiply(CongruenceDomainValue congruenceDomainValue) {
        if (congruenceDomainValue == null || this.mIsBottom || congruenceDomainValue.mIsBottom) {
            return CongruenceDomainValue.createBottom();
        }
        if (this.mIsConstant && congruenceDomainValue.mIsConstant) {
            return CongruenceDomainValue.createConstant(this.mValue.multiply(congruenceDomainValue.mValue));
        }
        return CongruenceDomainValue.createNonConstant(this.mValue.multiply(congruenceDomainValue.mValue), this.mNonZero && congruenceDomainValue.mNonZero);
    }

    @Override
    public CongruenceDomainValue divideReal(CongruenceDomainValue congruenceDomainValue) {
        if (congruenceDomainValue == null || this.mIsBottom || congruenceDomainValue.mIsBottom) {
            return CongruenceDomainValue.createBottom();
        }
        if (!congruenceDomainValue.mNonZero) {
            return CongruenceDomainValue.createTop();
        }
        if (congruenceDomainValue.mIsConstant) {
            if (this.mValue.mod(congruenceDomainValue.mValue.abs()).signum() == 0) {
                if (this.mIsConstant) {
                    return CongruenceDomainValue.createConstant(this.mValue.divide(congruenceDomainValue.mValue));
                }
                return CongruenceDomainValue.createNonConstant(this.mValue.divide(congruenceDomainValue.mValue), this.mNonZero);
            }
            if (this.mIsConstant) {
                BigInteger bigInteger = this.mValue.divide(congruenceDomainValue.mValue);
                if (this.mValue.signum() < 0) {
                    bigInteger = congruenceDomainValue.mValue.signum() > 0 ? bigInteger.subtract(BigInteger.ONE) : bigInteger.add(BigInteger.ONE);
                }
                return CongruenceDomainValue.createConstant(bigInteger);
            }
        }
        if (this.mIsConstant && this.mValue.signum() > 0 && this.mValue.compareTo(congruenceDomainValue.mValue) < 0) {
            return CongruenceDomainValue.createConstant(BigInteger.ZERO);
        }
        if (congruenceDomainValue.mIsConstant && this.mNonZero && this.mValue.compareTo(congruenceDomainValue.mValue.abs()) >= 0) {
            return CongruenceDomainValue.createNonConstant(BigInteger.ONE, true);
        }
        return CongruenceDomainValue.createTop();
    }

    @Override
    public CongruenceDomainValue negate() {
        if (this.mIsBottom) {
            return CongruenceDomainValue.createBottom();
        }
        if (this.mIsConstant) {
            return CongruenceDomainValue.createConstant(this.mValue.negate());
        }
        return this.copy();
    }

    public String toString() {
        if (this.mIsBottom) {
            return "{}";
        }
        if (this.mIsConstant) {
            return this.mValue.toString();
        }
        if (this.mNonZero) {
            return this.mValue.toString() + "Z \\ {0}";
        }
        return this.mValue.toString() + "Z";
    }

    @Override
    public Term getTerm(Script script, Sort sort, Term term) {
        assert (sort.isNumericSort());
        if (this.mIsBottom) {
            return script.term("false", new Term[0]);
        }
        if (this.mIsConstant) {
            return script.term("=", new Term[]{term, SmtUtils.constructIntValue((Script)script, (BigInteger)this.mValue)});
        }
        Term term2 = script.term("not", new Term[]{script.term("=", new Term[]{term, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)})});
        if (this.mValue.equals(BigInteger.ONE)) {
            if (this.mNonZero) {
                return term2;
            }
            return script.term("true", new Term[0]);
        }
        Term term3 = script.term("=", new Term[]{script.term("mod", new Term[]{term, SmtUtils.constructIntValue((Script)script, (BigInteger)this.mValue)}), SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)});
        if (this.mNonZero) {
            return script.term("and", new Term[]{term3, term2});
        }
        return term3;
    }

    @Override
    public boolean isAbstractionEqual(CongruenceDomainValue congruenceDomainValue) {
        if (congruenceDomainValue == null) {
            return false;
        }
        if (this.mIsBottom && congruenceDomainValue.mIsBottom) {
            return true;
        }
        return this.mValue.equals(congruenceDomainValue.mValue) && this.mIsConstant == congruenceDomainValue.mIsConstant && this.mNonZero == congruenceDomainValue.mNonZero;
    }

    @Override
    public CongruenceDomainValue copy() {
        if (this.mIsBottom) {
            return CongruenceDomainValue.createBottom();
        }
        if (this.mIsConstant) {
            return CongruenceDomainValue.createConstant(this.mValue);
        }
        return CongruenceDomainValue.createNonConstant(this.mValue, this.mNonZero);
    }

    protected CongruenceDomainValue modEquals(CongruenceDomainValue congruenceDomainValue) {
        if (this.mIsBottom || congruenceDomainValue == null || congruenceDomainValue.mIsBottom) {
            return CongruenceDomainValue.createBottom();
        }
        if (!this.mNonZero) {
            return CongruenceDomainValue.createTop();
        }
        if (congruenceDomainValue.mValue.signum() < 0) {
            return CongruenceDomainValue.createBottom();
        }
        if (this.mIsConstant && congruenceDomainValue.mValue.compareTo(this.mValue.abs()) >= 0) {
            if (congruenceDomainValue.mNonZero) {
                return CongruenceDomainValue.createBottom();
            }
            return CongruenceDomainValue.createNonConstant(this.mValue);
        }
        return CongruenceDomainValue.createNonConstant(this.mValue.gcd(congruenceDomainValue.mValue), congruenceDomainValue.mNonZero);
    }

    @Override
    public boolean isContainedIn(CongruenceDomainValue congruenceDomainValue) {
        if (this.mIsBottom) {
            return true;
        }
        if (congruenceDomainValue.mIsBottom) {
            return false;
        }
        if (congruenceDomainValue.mIsConstant) {
            return this.mIsConstant && this.mValue.equals(congruenceDomainValue.mValue);
        }
        if (!this.mNonZero && congruenceDomainValue.mNonZero) {
            return false;
        }
        return this.mValue.mod(congruenceDomainValue.mValue).signum() == 0;
    }

    protected CongruenceDomainValue getNonZeroValue() {
        if (this.mIsBottom || this.mValue.signum() == 0) {
            return CongruenceDomainValue.createBottom();
        }
        if (this.mIsConstant) {
            return this.copy();
        }
        return CongruenceDomainValue.createNonConstant(this.mValue, true);
    }

    @Override
    public CongruenceDomainValue divideInteger(CongruenceDomainValue congruenceDomainValue) {
        return this.divideReal(congruenceDomainValue);
    }

    @Override
    public CongruenceDomainValue modulo(CongruenceDomainValue congruenceDomainValue) {
        return this.mod(congruenceDomainValue);
    }

    @Override
    public CongruenceDomainValue greaterThan(CongruenceDomainValue congruenceDomainValue) {
        return CongruenceDomainValue.createTop();
    }

    @Override
    public BooleanValue isGreaterThan(CongruenceDomainValue congruenceDomainValue) {
        return this.keepZeroInverseBooleanAssociative(congruenceDomainValue, (bigInteger, bigInteger2) -> bigInteger.compareTo((BigInteger)bigInteger2) > 0);
    }

    @Override
    public CongruenceDomainValue greaterOrEqual(CongruenceDomainValue congruenceDomainValue) {
        return CongruenceDomainValue.createTop();
    }

    @Override
    public BooleanValue isGreaterOrEqual(CongruenceDomainValue congruenceDomainValue) {
        return this.keepZeroInverseBooleanAssociative(congruenceDomainValue, (bigInteger, bigInteger2) -> bigInteger.compareTo((BigInteger)bigInteger2) >= 0);
    }

    @Override
    public CongruenceDomainValue lessThan(CongruenceDomainValue congruenceDomainValue) {
        return CongruenceDomainValue.createTop();
    }

    @Override
    public BooleanValue isLessThan(CongruenceDomainValue congruenceDomainValue) {
        return this.keepZeroInverseBooleanAssociative(congruenceDomainValue, (bigInteger, bigInteger2) -> bigInteger.compareTo((BigInteger)bigInteger2) < 0);
    }

    @Override
    public CongruenceDomainValue lessOrEqual(CongruenceDomainValue congruenceDomainValue) {
        return CongruenceDomainValue.createTop();
    }

    @Override
    public BooleanValue isLessOrEqual(CongruenceDomainValue congruenceDomainValue) {
        return this.keepZeroInverseBooleanAssociative(congruenceDomainValue, (bigInteger, bigInteger2) -> bigInteger.compareTo((BigInteger)bigInteger2) <= 0);
    }

    @Override
    public CongruenceDomainValue inverseModulo(CongruenceDomainValue congruenceDomainValue, CongruenceDomainValue congruenceDomainValue2, boolean bl) {
        if (bl) {
            return congruenceDomainValue2.intersect(this.modEquals(congruenceDomainValue));
        }
        return congruenceDomainValue2;
    }

    @Override
    public CongruenceDomainValue inverseEquality(CongruenceDomainValue congruenceDomainValue, CongruenceDomainValue congruenceDomainValue2) {
        return congruenceDomainValue.intersect(this);
    }

    @Override
    public CongruenceDomainValue inverseLessOrEqual(CongruenceDomainValue congruenceDomainValue, boolean bl) {
        return this.keepZeroInverseNonAssociative(congruenceDomainValue, bl, bigInteger -> bigInteger.signum() < 0);
    }

    @Override
    public CongruenceDomainValue inverseLessThan(CongruenceDomainValue congruenceDomainValue, boolean bl) {
        return this.keepZeroInverseNonAssociative(congruenceDomainValue, bl, bigInteger -> bigInteger.signum() <= 0);
    }

    @Override
    public CongruenceDomainValue inverseGreaterOrEqual(CongruenceDomainValue congruenceDomainValue, boolean bl) {
        return this.keepZeroInverseNonAssociative(congruenceDomainValue, bl, bigInteger -> bigInteger.signum() > 0);
    }

    @Override
    public CongruenceDomainValue inverseGreaterThan(CongruenceDomainValue congruenceDomainValue, boolean bl) {
        return this.keepZeroInverseNonAssociative(congruenceDomainValue, bl, bigInteger -> bigInteger.signum() >= 0);
    }

    @Override
    public CongruenceDomainValue inverseNotEqual(CongruenceDomainValue congruenceDomainValue, CongruenceDomainValue congruenceDomainValue2) {
        return this.keepZeroInverseAssociative(congruenceDomainValue, bigInteger -> bigInteger.signum() == 0);
    }

    private CongruenceDomainValue keepZeroInverseNonAssociative(CongruenceDomainValue congruenceDomainValue, boolean bl, Predicate<BigInteger> predicate) {
        if (bl && this.isConstant() && predicate.test(this.value())) {
            return congruenceDomainValue.getNonZeroValue();
        }
        return congruenceDomainValue;
    }

    private CongruenceDomainValue keepZeroInverseAssociative(CongruenceDomainValue congruenceDomainValue, Predicate<BigInteger> predicate) {
        if (this.isConstant() && predicate.test(this.value())) {
            return congruenceDomainValue.getNonZeroValue();
        }
        return congruenceDomainValue;
    }

    private BooleanValue keepZeroInverseBooleanAssociative(CongruenceDomainValue congruenceDomainValue, BiPredicate<BigInteger, BigInteger> biPredicate) {
        if (this.isConstant() && congruenceDomainValue.isConstant()) {
            return BooleanValue.getBooleanValue(biPredicate.test(this.value(), congruenceDomainValue.value()));
        }
        return BooleanValue.TOP;
    }

    @Override
    public boolean canHandleReals() {
        return true;
    }

    @Override
    public boolean canHandleModulo() {
        return true;
    }

    @Override
    public BooleanValue isEqual(CongruenceDomainValue congruenceDomainValue) {
        if (this.isConstant() && congruenceDomainValue.isConstant()) {
            return BooleanValue.getBooleanValue(this.value().equals(congruenceDomainValue.value()));
        }
        return BooleanValue.TOP;
    }

    @Override
    public BooleanValue isNotEqual(CongruenceDomainValue congruenceDomainValue) {
        if (this.isConstant() && congruenceDomainValue.isConstant()) {
            return BooleanValue.getBooleanValue(!this.value().equals(congruenceDomainValue.value()));
        }
        return BooleanValue.TOP;
    }

    @Override
    public Collection<CongruenceDomainValue> complement() {
        if (!this.isConstant() && this.mValue == BigInteger.ONE) {
            return Collections.singleton(CongruenceDomainValue.createBottom());
        }
        return Collections.singleton(CongruenceDomainValue.createTop());
    }

    @Override
    public Collection<CongruenceDomainValue> complementInteger() {
        return this.complement();
    }
}

