/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntIterator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import java.util.Iterator;
import java.util.TreeSet;

public class IntSetTreeSet
implements IntSet {
    private final TreeSet<Integer> mSet = new TreeSet();

    @Override
    public IntIterator iterator() {
        return new TreeSetIterator(this);
    }

    @Override
    public IntSet clone() {
        IntSetTreeSet intSetTreeSet = new IntSetTreeSet();
        intSetTreeSet.mSet.addAll(this.mSet);
        return intSetTreeSet;
    }

    @Override
    public void andNot(IntSet intSet) {
        assert (intSet instanceof IntSetTreeSet) : "OPERAND should be TreeSet";
        IntSetTreeSet intSetTreeSet = (IntSetTreeSet)intSet;
        this.mSet.removeAll(intSetTreeSet.mSet);
    }

    @Override
    public void and(IntSet intSet) {
        assert (intSet instanceof IntSetTreeSet) : "OPERAND should be TreeSet";
        IntSetTreeSet intSetTreeSet = (IntSetTreeSet)intSet;
        this.mSet.retainAll(intSetTreeSet.mSet);
    }

    @Override
    public void or(IntSet intSet) {
        assert (intSet instanceof IntSetTreeSet) : "OPERAND should be TreeSet";
        IntSetTreeSet intSetTreeSet = (IntSetTreeSet)intSet;
        this.mSet.addAll(intSetTreeSet.mSet);
    }

    @Override
    public boolean get(int n) {
        return this.mSet.contains(n);
    }

    @Override
    public void clear(int n) {
        this.mSet.remove(n);
    }

    @Override
    public String toString() {
        return this.mSet.toString();
    }

    @Override
    public void clear() {
        this.mSet.clear();
    }

    @Override
    public void set(int n) {
        this.mSet.add(n);
    }

    @Override
    public boolean isEmpty() {
        return this.mSet.isEmpty();
    }

    @Override
    public int cardinality() {
        return this.mSet.size();
    }

    @Override
    public boolean subsetOf(IntSet intSet) {
        assert (intSet instanceof IntSetTreeSet) : "OPERAND should be TreeSet";
        IntSetTreeSet intSetTreeSet = (IntSetTreeSet)intSet;
        return intSetTreeSet.mSet.containsAll(this.mSet);
    }

    @Override
    public boolean contentEq(IntSet intSet) {
        assert (intSet instanceof IntSetTreeSet) : "OPERAND should be TreeSet";
        IntSetTreeSet intSetTreeSet = (IntSetTreeSet)intSet;
        return this.mSet.equals(intSetTreeSet.mSet);
    }

    @Override
    public Object get() {
        return this.mSet;
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IntSetTreeSet intSetTreeSet = (IntSetTreeSet)object;
        return this.contentEq(intSetTreeSet);
    }

    @Override
    public int hashCode() {
        return this.mSet.hashCode();
    }

    @Override
    public Iterable<Integer> iterable() {
        return this.mSet;
    }

    public static class TreeSetIterator
    implements IntIterator {
        private final Iterator<Integer> mSetIter;

        public TreeSetIterator(IntSetTreeSet intSetTreeSet) {
            this.mSetIter = intSetTreeSet.mSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mSetIter.hasNext();
        }

        @Override
        public int next() {
            return this.mSetIter.next();
        }
    }
}

