/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.MapToCollectionIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractRelation<D, R, SET extends Set<R>, MAP extends Map<D, SET>>
implements Iterable<Map.Entry<D, R>> {
    private static final String NOT_YET_IMPLEMENTED = "not yet implemented";
    protected final MAP mMap = this.newMap();

    public AbstractRelation() {
    }

    public AbstractRelation(AbstractRelation<D, R, ?, ?> abstractRelation) {
        this();
        this.addAll(abstractRelation);
    }

    protected abstract MAP newMap();

    protected abstract SET newSet();

    public boolean addPair(D d, R r) {
        Set<Object> set = (Set)this.mMap.get(d);
        if (set == null) {
            set = this.newSet();
            this.mMap.put(d, (Set)set);
        }
        return set.add(r);
    }

    public boolean addAllPairs(D d, Collection<R> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Set<Object> set = (Set)this.mMap.get(d);
        if (set == null) {
            set = this.newSet();
            this.mMap.put(d, (Set)set);
        }
        return set.addAll(collection);
    }

    public boolean removePair(D d, R r) {
        boolean bl;
        Set set = (Set)this.mMap.get(d);
        if (set == null) {
            bl = false;
        } else {
            bl = set.remove(r);
            if (set.isEmpty()) {
                this.mMap.remove(d);
            }
        }
        return bl;
    }

    public void removeAllPairs(AbstractRelation<D, R, ?, ?> abstractRelation) {
        for (Map.Entry<D, R> entry : abstractRelation.getSetOfPairs()) {
            this.removePair(entry.getKey(), entry.getValue());
        }
    }

    public SET removeDomainElement(D d) {
        Set set = (Set)this.mMap.remove(d);
        assert (this.sanityCheck());
        return (SET)set;
    }

    public void removeRangeElement(R r) {
        MAP MAP = this.newMap();
        MAP.putAll(this.mMap);
        for (Map.Entry entry : MAP.entrySet()) {
            ((Set)entry.getValue()).remove(r);
            if (!((Set)entry.getValue()).isEmpty()) continue;
            this.mMap.remove(entry.getKey());
        }
        assert (this.sanityCheck());
    }

    public void replaceDomainElement(D d, D d2) {
        assert (d2 != null);
        Set set = (Set)this.mMap.get(d);
        if (set == null) {
            return;
        }
        for (Object e : set) {
            this.addPair(d2, e);
        }
        this.removeDomainElement(d);
        assert (this.sanityCheck());
    }

    public void replaceRangeElement(R r, R r2) {
        for (Map.Entry entry : this.mMap.entrySet()) {
            if (!((Set)entry.getValue()).contains(r)) continue;
            ((Set)entry.getValue()).remove(r);
            ((Set)entry.getValue()).add(r2);
        }
        assert (this.sanityCheck());
    }

    @Deprecated
    public void transformElements(Function<D, D> function, Function<R, R> function2) {
        for (Map.Entry<D, R> entry : new HashRelation(this)) {
            this.removePair(entry.getKey(), entry.getValue());
            this.addPair(function.apply(entry.getKey()), function2.apply(entry.getValue()));
        }
    }

    public boolean addAll(AbstractRelation<D, R, ?, ?> abstractRelation) {
        boolean bl = false;
        for (Map.Entry entry : abstractRelation.mMap.entrySet()) {
            Set<Object> set = (Set)this.mMap.get(entry.getKey());
            if (set == null) {
                set = this.newSet();
                this.mMap.put(entry.getKey(), (Set)set);
            }
            boolean bl2 = set.addAll((Collection)entry.getValue());
            boolean bl3 = bl = bl || bl2;
        }
        return bl;
    }

    public boolean containsPair(D d, R r) {
        Set set = (Set)this.mMap.get(d);
        if (set == null) {
            return false;
        }
        return set.contains(r);
    }

    public Set<D> getDomain() {
        return this.mMap.keySet();
    }

    public Set<R> getImage(D d) {
        Set set = (Set)this.mMap.get(d);
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)this.mMap.get(d));
    }

    public int size() {
        int n = 0;
        for (Map.Entry entry : this.mMap.entrySet()) {
            n += ((Set)entry.getValue()).size();
        }
        return n;
    }

    public int numberOfPairsWithGivenDomainElement(D d) {
        if (this.getDomain().contains(d)) {
            return this.getImage(d).size();
        }
        return 0;
    }

    public boolean hasEmptyImage(D d) {
        return this.numberOfPairsWithGivenDomainElement(d) == 0;
    }

    public String toString() {
        return this.mMap.toString();
    }

    public String toStringAsTable() {
        StringBuilder stringBuilder = new StringBuilder();
        for (D d : this.getDomain()) {
            for (R r : this.getImage(d)) {
                stringBuilder.append(String.valueOf(d) + ", " + String.valueOf(r) + System.lineSeparator());
            }
        }
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public Iterator<Map.Entry<D, R>> iterator() {
        return new MapToCollectionIterator(this.mMap);
    }

    public void clear() {
        this.mMap.clear();
    }

    public int hashCode() {
        return Objects.hash(this.mMap);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractRelation abstractRelation = (AbstractRelation)object;
        return !(this.mMap == null ? abstractRelation.mMap != null : !this.mMap.equals(abstractRelation.mMap));
    }

    private boolean sanityCheck() {
        for (Map.Entry entry : this.mMap.entrySet()) {
            if (entry.getKey() == null) {
                return false;
            }
            if (entry.getValue() == null) {
                return false;
            }
            if (!((Set)entry.getValue()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Set<Map.Entry<D, SET>> entrySet() {
        return this.mMap.entrySet();
    }

    public Set<Map.Entry<D, R>> getSetOfPairs() {
        return new Set<Map.Entry<D, R>>(){

            @Override
            public boolean add(Map.Entry<D, R> entry) {
                return AbstractRelation.this.addPair(entry.getKey(), entry.getValue());
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<D, R>> collection) {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public boolean contains(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return AbstractRelation.this.containsPair(entry.getKey(), entry.getValue());
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public boolean isEmpty() {
                return AbstractRelation.this.mMap.isEmpty();
            }

            @Override
            public Iterator<Map.Entry<D, R>> iterator() {
                return new Iterator<Map.Entry<D, R>>(){
                    private Map.Entry<D, R> mNextEntry;
                    private Iterator<Map.Entry<D, SET>> mOuterIterator;
                    private Iterator<R> mInnerIterator;
                    private Map.Entry<D, SET> mNextOuter;
                    {
                        this.mOuterIterator = (this).AbstractRelation.this.mMap.entrySet().iterator();
                        this.mNextEntry = this.constructNext();
                    }

                    private Map.Entry<D, R> constructNext() {
                        if (this.mInnerIterator == null || !this.mInnerIterator.hasNext()) {
                            if (this.mOuterIterator.hasNext()) {
                                this.mNextOuter = this.mOuterIterator.next();
                                this.mInnerIterator = ((Set)this.mNextOuter.getValue()).iterator();
                            } else {
                                this.mInnerIterator = null;
                            }
                        }
                        if (this.mInnerIterator != null) {
                            if (!$assertionsDisabled && !this.mInnerIterator.hasNext()) {
                                throw new AssertionError();
                            }
                            Object r = this.mInnerIterator.next();
                            return new Map.Entry<D, R>(r){
                                private final D mKey;
                                private final R mValue;
                                {
                                    this.mKey = mNextOuter.getKey();
                                    this.mValue = object;
                                }

                                @Override
                                public D getKey() {
                                    return this.mKey;
                                }

                                @Override
                                public R getValue() {
                                    return this.mValue;
                                }

                                @Override
                                public R setValue(R r) {
                                    throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mNextEntry != null;
                    }

                    @Override
                    public Map.Entry<D, R> next() {
                        Map.Entry entry = this.mNextEntry;
                        this.mNextEntry = this.constructNext();
                        return entry;
                    }
                };
            }

            @Override
            public boolean remove(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return AbstractRelation.this.removePair(entry.getKey(), entry.getValue());
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public boolean retainAll(Collection<?> collection) {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public int size() {
                return AbstractRelation.this.size();
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                throw new UnsupportedOperationException(AbstractRelation.NOT_YET_IMPLEMENTED);
            }
        };
    }

    public Set<R> projectToRange() {
        return this.getSetOfPairs().stream().map(entry -> entry.getValue()).collect(Collectors.toSet());
    }

    public Set<R> projectToRange(Set<D> set) {
        return set.stream().flatMap(object -> this.getImage(object).stream()).collect(Collectors.toSet());
    }

    public boolean reverseAddAll(Map<R, D> map) {
        boolean bl = false;
        for (Map.Entry<R, D> entry : map.entrySet()) {
            bl |= this.addPair(entry.getValue(), entry.getKey());
        }
        return bl;
    }
}

