/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.IAutomatonStatePartition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.IBlock;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DoubleDeckerVisitor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IPartition;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class QuotientNwaConstructor<LETTER, STATE> {
    protected final IMergeStateFactory<STATE> mStateFactory;
    protected final NestedWordAutomaton<LETTER, STATE> mResult;
    private final AutomataLibraryServices mServices;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final GetOnlyMap mOldState2NewState;
    private final STATE mOldEmptyStackState;
    private final STATE mNewEmptyStackState;
    private final Map<STATE, Map<STATE, DoubleDeckerVisitor.ReachFinal>> mUp2Down;

    public QuotientNwaConstructor(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, IPartition<STATE> iPartition, boolean bl) {
        IResultStateConstructor iResultStateConstructor;
        this.mServices = automataLibraryServices;
        this.mStateFactory = iMinimizationStateFactory;
        this.mOperand = iNestedWordAutomaton;
        if (iNestedWordAutomaton instanceof IDoubleDeckerAutomaton) {
            this.mResult = new DoubleDeckerAutomaton(this.mServices, this.mOperand.getVpAlphabet(), this.mStateFactory);
            this.mUp2Down = new HashMap<STATE, Map<STATE, DoubleDeckerVisitor.ReachFinal>>(iPartition.size());
            ((DoubleDeckerAutomaton)this.mResult).setUp2Down(this.mUp2Down);
        } else {
            this.mResult = new NestedWordAutomaton(this.mServices, this.mOperand.getVpAlphabet(), this.mStateFactory);
            this.mUp2Down = null;
        }
        this.mOldEmptyStackState = this.mOperand.getEmptyStackState();
        this.mNewEmptyStackState = iMinimizationStateFactory.createEmptyStackState();
        if (iPartition instanceof IAutomatonStatePartition) {
            IAutomatonStatePartition iAutomatonStatePartition = (IAutomatonStatePartition)iPartition;
            iResultStateConstructor = new ResultStateConstructorFromAutomatonStatePartition(iAutomatonStatePartition);
            this.constructResultFromAutomatonStatePartition(iResultStateConstructor, iAutomatonStatePartition);
        } else {
            iResultStateConstructor = new ResultStateConstructorFromGeneralPartition(iPartition, this.mOperand);
            this.constructResultFromGeneralPartition(iResultStateConstructor, iPartition);
        }
        this.mOldState2NewState = bl ? new GetOnlyMap(iResultStateConstructor) : null;
    }

    private void constructResultFromAutomatonStatePartition(IResultStateConstructor<STATE> iResultStateConstructor, IAutomatonStatePartition<STATE> iAutomatonStatePartition) {
        Iterator<IBlock<STATE>> iterator = iAutomatonStatePartition.blocksIterator();
        while (iterator.hasNext()) {
            IBlock<STATE> iBlock = iterator.next();
            boolean bl = iBlock.isRepresentativeIndependentInternalsCalls();
            this.constructStateForBlock(iResultStateConstructor, iBlock.iterator(), bl);
        }
    }

    private void constructResultFromGeneralPartition(IResultStateConstructor<STATE> iResultStateConstructor, IPartition<STATE> iPartition) {
        for (Set set : iPartition) {
            this.constructStateForBlock(iResultStateConstructor, set.iterator(), false);
        }
    }

    private void constructStateForBlock(IResultStateConstructor<STATE> iResultStateConstructor, Iterator<STATE> iterator, boolean bl) {
        assert (iterator.hasNext()) : "There must be at least one state.";
        boolean bl2 = false;
        do {
            STATE STATE = iterator.next();
            boolean bl3 = bl && bl2;
            this.constructStateAndSuccessors(iResultStateConstructor, STATE, bl3);
            bl2 = true;
        } while (iterator.hasNext());
    }

    private void constructStateAndSuccessors(IResultStateConstructor<STATE> iResultStateConstructor, STATE STATE, boolean bl) {
        STATE STATE2 = iResultStateConstructor.getOrConstructResultState(STATE);
        if (this.mOperand instanceof IDoubleDeckerAutomaton) {
            this.addDownStates(iResultStateConstructor, STATE, STATE2);
        }
        if (!bl) {
            this.addOutgoingTransitionsInternal(iResultStateConstructor, STATE, STATE2);
            this.addOutgoingTransitionsCall(iResultStateConstructor, STATE, STATE2);
        }
        this.addOutgoingTransitionsReturn(iResultStateConstructor, STATE, STATE2);
    }

    private void addDownStates(IResultStateConstructor<STATE> iResultStateConstructor, STATE STATE, STATE STATE2) {
        assert (this.mOperand instanceof IDoubleDeckerAutomaton);
        assert (this.mResult instanceof DoubleDeckerAutomaton);
        Map<STATE, DoubleDeckerVisitor.ReachFinal> map = this.mUp2Down.get(STATE2);
        if (map == null) {
            map = new HashMap<STATE, DoubleDeckerVisitor.ReachFinal>();
            this.mUp2Down.put(STATE2, map);
        }
        for (STATE STATE3 : ((IDoubleDeckerAutomaton)this.mOperand).getDownStates(STATE)) {
            STATE STATE4 = STATE3 == this.mOldEmptyStackState ? this.mNewEmptyStackState : iResultStateConstructor.getOrConstructResultState(STATE3);
            map.put(STATE4, DoubleDeckerVisitor.ReachFinal.UNKNOWN);
        }
    }

    private void addOutgoingTransitionsInternal(IResultStateConstructor<STATE> iResultStateConstructor, STATE STATE, STATE STATE2) {
        for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE)) {
            STATE STATE3 = iResultStateConstructor.getOrConstructResultState(outgoingInternalTransition.getSucc());
            this.mResult.addInternalTransition(STATE2, outgoingInternalTransition.getLetter(), STATE3);
        }
    }

    private void addOutgoingTransitionsCall(IResultStateConstructor<STATE> iResultStateConstructor, STATE STATE, STATE STATE2) {
        for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(STATE)) {
            STATE STATE3 = iResultStateConstructor.getOrConstructResultState(outgoingCallTransition.getSucc());
            this.mResult.addCallTransition(STATE2, outgoingCallTransition.getLetter(), STATE3);
        }
    }

    private void addOutgoingTransitionsReturn(IResultStateConstructor<STATE> iResultStateConstructor, STATE STATE, STATE STATE2) {
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mOperand.returnSuccessors(STATE)) {
            assert (!(this.mOperand instanceof IDoubleDeckerAutomaton) || ((IDoubleDeckerAutomaton)this.mOperand).isDoubleDecker(STATE, outgoingReturnTransition.getHierPred())) : "Unusable return transitions should not be present.";
            STATE STATE3 = iResultStateConstructor.getOrConstructResultState(outgoingReturnTransition.getSucc());
            STATE STATE4 = iResultStateConstructor.getOrConstructResultState(outgoingReturnTransition.getHierPred());
            this.mResult.addReturnTransition(STATE2, STATE4, outgoingReturnTransition.getLetter(), STATE3);
        }
    }

    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    public Map<STATE, STATE> getOldState2newState() {
        return this.mOldState2NewState;
    }

    private class GetOnlyMap
    implements Map<STATE, STATE> {
        private final IResultStateConstructor<STATE> mResStateConstructor;

        public GetOnlyMap(IResultStateConstructor<STATE> iResultStateConstructor) {
            this.mResStateConstructor = iResultStateConstructor;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public STATE get(Object object) {
            return this.mResStateConstructor.get(object);
        }

        @Override
        public STATE put(STATE STATE, STATE STATE2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public STATE remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends STATE, ? extends STATE> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<STATE> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<STATE> values() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<STATE, STATE>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface IResultStateConstructor<STATE> {
        public STATE getOrConstructResultState(STATE var1);

        public STATE get(STATE var1);
    }

    private class ResultStateConstructorFromAutomatonStatePartition
    implements IResultStateConstructor<STATE> {
        private final ConstructionCache<IBlock<STATE>, STATE> mConstructionCache;
        private final IAutomatonStatePartition<STATE> mPartition;

        public ResultStateConstructorFromAutomatonStatePartition(IAutomatonStatePartition<STATE> iAutomatonStatePartition) {
            this.mPartition = iAutomatonStatePartition;
            ConstructionCache.IValueConstruction iValueConstruction = iBlock -> {
                Object STATE = iBlock.minimize(QuotientNwaConstructor.this.mStateFactory);
                boolean bl = iBlock.isInitial();
                boolean bl2 = iBlock.isFinal();
                QuotientNwaConstructor.this.mResult.addState(bl, bl2, STATE);
                return STATE;
            };
            this.mConstructionCache = new ConstructionCache(iValueConstruction);
        }

        @Override
        public STATE getOrConstructResultState(STATE STATE) {
            IBlock iBlock = this.mPartition.getBlock(STATE);
            assert (iBlock != null) : "Block is not known.";
            return this.mConstructionCache.getOrConstruct(iBlock);
        }

        @Override
        public STATE get(STATE STATE) {
            IBlock iBlock = this.mPartition.getBlock(STATE);
            return this.mConstructionCache.get(iBlock);
        }
    }

    private class ResultStateConstructorFromGeneralPartition
    implements IResultStateConstructor<STATE> {
        private final ConstructionCache<Set<STATE>, STATE> mConstructionCache;
        private final IPartition<STATE> mPartition;
        protected final INestedWordAutomaton<LETTER, STATE> mOperandInner;

        public ResultStateConstructorFromGeneralPartition(IPartition<STATE> iPartition, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
            this.mPartition = iPartition;
            this.mOperandInner = iNestedWordAutomaton;
            ConstructionCache.IValueConstruction iValueConstruction = set -> {
                Object STATE = QuotientNwaConstructor.this.mStateFactory.merge(set);
                boolean bl = false;
                boolean bl2 = false;
                for (Object e : set) {
                    if (!bl && this.mOperandInner.isInitial(e)) {
                        bl = true;
                        if (bl2) break;
                    }
                    if (bl2 || !this.mOperandInner.isFinal(e)) continue;
                    bl2 = true;
                    if (bl) break;
                }
                QuotientNwaConstructor.this.mResult.addState(bl, bl2, STATE);
                return STATE;
            };
            this.mConstructionCache = new ConstructionCache(iValueConstruction);
        }

        @Override
        public STATE getOrConstructResultState(STATE STATE) {
            Set set = this.mPartition.getContainingSet(STATE);
            assert (set != null) : "Block is not known.";
            return this.mConstructionCache.getOrConstruct((Object)set);
        }

        @Override
        public STATE get(STATE STATE) {
            Set set = this.mPartition.getContainingSet(STATE);
            return this.mConstructionCache.get((Object)set);
        }
    }
}

