/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntIterator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import java.util.BitSet;
import java.util.Iterator;

public class IntSetBits
implements IntSet {
    private BitSet mSet = new BitSet();

    @Override
    public IntIterator iterator() {
        return new SparseBitsIterator(this);
    }

    @Override
    public IntSet clone() {
        IntSetBits intSetBits = new IntSetBits();
        intSetBits.mSet = (BitSet)this.mSet.clone();
        return intSetBits;
    }

    @Override
    public void andNot(IntSet intSet) {
        assert (intSet instanceof IntSetBits) : "OPERAND should be BitSet";
        BitSet bitSet = (BitSet)intSet.get();
        this.mSet.andNot(bitSet);
    }

    @Override
    public void and(IntSet intSet) {
        assert (intSet instanceof IntSetBits) : "OPERAND should be BitSet";
        BitSet bitSet = (BitSet)intSet.get();
        this.mSet.and(bitSet);
    }

    @Override
    public void or(IntSet intSet) {
        assert (intSet instanceof IntSetBits) : "OPERAND should be BitSet";
        BitSet bitSet = (BitSet)intSet.get();
        this.mSet.or(bitSet);
    }

    @Override
    public boolean get(int n) {
        return this.mSet.get(n);
    }

    @Override
    public void set(int n) {
        this.mSet.set(n);
    }

    @Override
    public void clear(int n) {
        this.mSet.clear(n);
    }

    @Override
    public void clear() {
        this.mSet.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.mSet.isEmpty();
    }

    @Override
    public int cardinality() {
        return this.mSet.cardinality();
    }

    @Override
    public boolean overlap(IntSet intSet) {
        assert (intSet instanceof IntSetBits) : "OPERAND should be BitSet";
        IntSetBits intSetBits = (IntSetBits)intSet;
        return intSetBits.mSet.intersects(this.mSet);
    }

    @Override
    public boolean subsetOf(IntSet intSet) {
        assert (intSet instanceof IntSetBits) : "OPERAND should be BitSet";
        BitSet bitSet = (BitSet)this.mSet.clone();
        BitSet bitSet2 = (BitSet)intSet.get();
        bitSet.andNot(bitSet2);
        return bitSet.isEmpty();
    }

    @Override
    public boolean contentEq(IntSet intSet) {
        assert (intSet instanceof IntSetBits) : "OPERAND should be BitSet";
        BitSet bitSet = (BitSet)intSet.get();
        return this.mSet.equals(bitSet);
    }

    @Override
    public Object get() {
        return this.mSet;
    }

    @Override
    public String toString() {
        return this.mSet.toString();
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IntSetBits intSetBits = (IntSetBits)object;
        return this.contentEq(intSetBits);
    }

    @Override
    public int hashCode() {
        return this.mSet.hashCode();
    }

    @Override
    public Iterable<Integer> iterable() {
        return () -> new Iterator<Integer>(){
            IntIterator iter;
            {
                this.iter = IntSetBits.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Integer next() {
                return this.iter.next();
            }
        };
    }

    public static class SparseBitsIterator
    implements IntIterator {
        private final BitSet mBits;
        private int mIndex;

        public SparseBitsIterator(IntSetBits intSetBits) {
            this.mBits = intSetBits.mSet;
            this.mIndex = this.mBits.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.mIndex >= 0;
        }

        @Override
        public int next() {
            int n = this.mIndex;
            this.mIndex = this.mBits.nextSetBit(this.mIndex + 1);
            return n;
        }
    }
}

