/*
 * Decompiled with CFR 0.152.
 */
package ap.proof.certificates;

import ap.proof.certificates.AlphaInference;
import ap.proof.certificates.BranchInference;
import ap.proof.certificates.BranchInferenceCertificate$;
import ap.proof.certificates.BranchInferenceCollection;
import ap.proof.certificates.CertArithLiteral;
import ap.proof.certificates.CertCompoundFormula;
import ap.proof.certificates.CertEquation;
import ap.proof.certificates.CertFormula;
import ap.proof.certificates.CertFormula$;
import ap.proof.certificates.CertInequality;
import ap.proof.certificates.CertNegEquation;
import ap.proof.certificates.Certificate;
import ap.proof.certificates.MacroInference;
import ap.proof.certificates.PartialCertificate;
import ap.proof.certificates.PartialCertificateInference;
import ap.proof.certificates.SimpInference;
import ap.terfor.TermOrder;
import ap.terfor.conjunctions.Conjunction;
import ap.terfor.linearcombination.LinearCombination;
import ap.util.Debug$;
import ap.util.Debug$AC_CERTIFICATES$;
import ap.util.Seqs$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class BranchInferenceCollection$ {
    public static BranchInferenceCollection$ MODULE$;
    private final Debug$AC_CERTIFICATES$ AC;
    private final BranchInferenceCollection EMPTY;

    static {
        new BranchInferenceCollection$();
    }

    private Debug$AC_CERTIFICATES$ AC() {
        return this.AC;
    }

    public BranchInferenceCollection EMPTY() {
        return this.EMPTY;
    }

    public BranchInferenceCollection apply(Iterable<Conjunction> initialFors) {
        return this.applyCert((Iterable<CertFormula>)((Iterable)initialFors.map((Function1 & Serializable & scala.Serializable)c -> CertFormula$.MODULE$.apply((Conjunction)c), Iterable$.MODULE$.canBuildFrom())));
    }

    public BranchInferenceCollection applyCert(Iterable<CertFormula> initialFors) {
        if (initialFors.isEmpty()) {
            return this.EMPTY();
        }
        return this.apply((List<BranchInference>)((TraversableOnce)initialFors.flatMap((Function1 & Serializable & scala.Serializable)f -> (Seq)MODULE$.genDefaultInferences((CertFormula)f).map((Function1 & Serializable & scala.Serializable)inf -> inf, Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toList());
    }

    public BranchInferenceCollection apply(List<BranchInference> inferences) {
        return new BranchInferenceCollection(inferences);
    }

    public Seq<BranchInference> genDefaultInferences(CertFormula f) {
        Seq<BranchInference> alphaInfs = this.genAlphaInferences(f);
        Seq<BranchInference> directSimpInfs = this.genSimpInferences(f);
        Seq indirectSimpInfs = (Seq)alphaInfs.flatMap((Function1 & Serializable & scala.Serializable)inf -> (Set)inf.providedFormulas().flatMap((Function1 & Serializable & scala.Serializable)f -> (Seq)MODULE$.genSimpInferences((CertFormula)f).map((Function1 & Serializable & scala.Serializable)i -> i, Seq$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)alphaInfs.$plus$plus(directSimpInfs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)indirectSimpInfs, Seq$.MODULE$.canBuildFrom());
    }

    private Seq<BranchInference> genAlphaInferences(CertFormula cf) {
        CertCompoundFormula certCompoundFormula;
        Conjunction f;
        CertFormula certFormula = cf;
        if (certFormula instanceof CertCompoundFormula && (f = (certCompoundFormula = (CertCompoundFormula)certFormula).f()).size() > 1 && f.quans().isEmpty()) {
            return new .colon.colon((Object)new AlphaInference(certCompoundFormula, (Set<CertFormula>)((Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)f.iterator().map((Function1 & Serializable & scala.Serializable)l -> CertFormula$.MODULE$.apply((Conjunction)l))))), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    private Seq<BranchInference> genSimpInferences(CertFormula f) {
        if (f.isTrue() || f.isFalse()) {
            return Nil$.MODULE$;
        }
        CertFormula certFormula = f;
        if (certFormula instanceof CertInequality) {
            LinearCombination simplified;
            CertInequality certInequality = (CertInequality)certFormula;
            LinearCombination lhs = certInequality._lhs();
            LinearCombination linearCombination = simplified = lhs.makePrimitive();
            LinearCombination linearCombination2 = lhs;
            if (!(linearCombination != null ? !((Object)linearCombination).equals(linearCombination2) : linearCombination2 != null)) {
                return Nil$.MODULE$;
            }
            return new .colon.colon((Object)new SimpInference(certInequality, new CertInequality(simplified), certInequality.order()), (List)Nil$.MODULE$);
        }
        if (certFormula instanceof CertArithLiteral) {
            LinearCombination simplified;
            CertArithLiteral certArithLiteral = (CertArithLiteral)certFormula;
            Debug$.MODULE$.assertInt(this.AC(), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> certArithLiteral instanceof CertEquation || certArithLiteral instanceof CertNegEquation);
            LinearCombination linearCombination = simplified = certArithLiteral.lhs().makePrimitiveAndPositive();
            LinearCombination linearCombination3 = certArithLiteral.lhs();
            if (!(linearCombination != null ? !((Object)linearCombination).equals(linearCombination3) : linearCombination3 != null)) {
                return Nil$.MODULE$;
            }
            return new .colon.colon((Object)new SimpInference(certArithLiteral, certArithLiteral.update(simplified), certArithLiteral.order()), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public Certificate ap$proof$certificates$BranchInferenceCollection$$getCertificateHelp(List<BranchInference> infs, Certificate child, TermOrder order) {
        if (infs.isEmpty()) {
            return child;
        }
        HashSet requiredFormulas = new HashSet();
        HashSet containedConstants = new HashSet();
        requiredFormulas.$plus$plus$eq(child.assumedFormulas());
        containedConstants.$plus$plus$eq(child.constants());
        Nil$ selectedInferences = Nil$.MODULE$;
        ObjectRef remInferences = ObjectRef.create(infs);
        while (!((List)remInferences.elem).isEmpty()) {
            BranchInference inf = (BranchInference)((List)remInferences.elem).head();
            remInferences.elem = (List)((List)remInferences.elem).tail();
            if (Seqs$.MODULE$.disjoint(inf.providedFormulas(), requiredFormulas) && Seqs$.MODULE$.disjoint(inf.localBoundConstants(), containedConstants)) continue;
            BranchInference branchInference = inf;
            if (branchInference instanceof PartialCertificateInference) {
                PartialCertificateInference partialCertificateInference = (PartialCertificateInference)branchInference;
                PartialCertificate pCert = partialCertificateInference.pCert();
                Certificate infCert = BranchInferenceCertificate$.MODULE$.prepend((Seq<BranchInference>)selectedInferences, child, order);
                Certificate newChild = pCert.apply((Seq<Certificate>)new .colon.colon((Object)infCert, (List)Nil$.MODULE$));
                return this.ap$proof$certificates$BranchInferenceCollection$$getCertificateHelp((List<BranchInference>)((List)remInferences.elem), newChild, order);
            }
            if (branchInference instanceof MacroInference) {
                MacroInference macroInference = (MacroInference)branchInference;
                macroInference.expand().foreach((Function1 & Serializable & scala.Serializable)n -> {
                    BranchInferenceCollection$.$anonfun$getCertificateHelp$1(remInferences, n);
                    return BoxedUnit.UNIT;
                });
                continue;
            }
            requiredFormulas.$minus$minus$eq(branchInference.providedFormulas());
            requiredFormulas.$plus$plus$eq(branchInference.assumedFormulas());
            containedConstants.$plus$plus$eq(branchInference.constants());
            containedConstants.$minus$minus$eq(branchInference.localBoundConstants());
            BranchInference branchInference2 = branchInference;
            selectedInferences = selectedInferences.$colon$colon((Object)branchInference2);
        }
        return BranchInferenceCertificate$.MODULE$.prepend((Seq<BranchInference>)selectedInferences, child, order);
    }

    public static final /* synthetic */ void $anonfun$getCertificateHelp$1(ObjectRef remInferences$1, BranchInference n) {
        BranchInference branchInference = n;
        remInferences$1.elem = ((List)remInferences$1.elem).$colon$colon((Object)branchInference);
    }

    private BranchInferenceCollection$() {
        MODULE$ = this;
        this.AC = Debug$AC_CERTIFICATES$.MODULE$;
        this.EMPTY = new BranchInferenceCollection((List<BranchInference>)Nil$.MODULE$);
    }
}

