/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.CommonExternalFormatWriter;
import java.io.PrintWriter;

public final class GoalFormatWriter<LETTER, STATE>
extends CommonExternalFormatWriter<LETTER, STATE> {
    private static final int MINIMUM_SKELETON_SIZE = 130;
    private static final String STATE_ID_CLOSE = "</StateID>";
    private static final String STATE_ID_OPEN = "<StateID>";
    private static final char TAB = '\t';
    private final CommonExternalFormatWriter.IConverter<LETTER> mLetterConverter;
    private final CommonExternalFormatWriter.IConverter<STATE> mStateConverter;

    public GoalFormatWriter(PrintWriter printWriter, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        super(printWriter, iNestedWordAutomaton);
        this.mLetterConverter = new CommonExternalFormatWriter.MapBasedConverter(this.mAlphabetMapping);
        this.mStateConverter = new CommonExternalFormatWriter.MapBasedConverter(this.mStateMapping);
        this.doPrint();
        this.finish();
    }

    private void doPrint() {
        StringBuilder stringBuilder = new StringBuilder(130);
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>").append(NEW_LINE).append("<Structure label-on=\"Transition\" type=\"FiniteStateAutomaton\">").append(NEW_LINE);
        this.constructAlphabetSection(stringBuilder);
        this.constructStateSection(stringBuilder);
        this.constructInitialStateSection(stringBuilder);
        this.constructTransitionSection(stringBuilder);
        this.constructAcceptingStateSection(stringBuilder);
        stringBuilder.append("</Structure>").append(NEW_LINE);
        this.print(stringBuilder);
    }

    private void constructAlphabetSection(StringBuilder stringBuilder) {
        stringBuilder.append('\t').append("<Alphabet type=\"Classical\">").append(NEW_LINE);
        for (Object LETTER : this.mNwa.getVpAlphabet().getInternalAlphabet()) {
            stringBuilder.append('\t').append('\t').append("<Symbol>").append(this.mLetterConverter.convert(LETTER)).append("</Symbol>").append(NEW_LINE);
        }
        stringBuilder.append('\t').append("</Alphabet>").append(NEW_LINE);
    }

    private void constructStateSection(StringBuilder stringBuilder) {
        stringBuilder.append('\t').append("<StateSet>").append(NEW_LINE);
        for (Object STATE : this.mNwa.getStates()) {
            stringBuilder.append('\t').append('\t').append("<State sid=\"").append(this.mStateConverter.convert(STATE)).append("\" />").append(NEW_LINE);
        }
        stringBuilder.append('\t').append("</StateSet>").append(NEW_LINE);
    }

    private void constructInitialStateSection(StringBuilder stringBuilder) {
        stringBuilder.append('\t').append("<InitialStateSet>").append(NEW_LINE);
        for (Object e : this.mNwa.getInitialStates()) {
            stringBuilder.append('\t').append('\t').append(STATE_ID_OPEN).append(this.mStateConverter.convert(e)).append(STATE_ID_CLOSE).append(NEW_LINE);
        }
        stringBuilder.append('\t').append("</InitialStateSet>").append(NEW_LINE);
    }

    private void constructTransitionSection(StringBuilder stringBuilder) {
        int n = 0;
        stringBuilder.append('\t').append("<TransitionSet complete=\"false\">").append(NEW_LINE);
        for (Object STATE : this.mNwa.getStates()) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mNwa.internalSuccessors(STATE)) {
                stringBuilder.append('\t').append('\t').append("<Transition tid=\"").append(n).append("\"><From>").append(this.mStateConverter.convert(STATE)).append("</From><To>").append(this.mStateConverter.convert(outgoingInternalTransition.getSucc())).append("</To><Label>").append(this.mLetterConverter.convert(outgoingInternalTransition.getLetter())).append("</Label></Transition>").append(NEW_LINE);
                ++n;
            }
        }
        stringBuilder.append('\t').append("</TransitionSet>").append(NEW_LINE);
    }

    private void constructAcceptingStateSection(StringBuilder stringBuilder) {
        stringBuilder.append('\t').append("<Acc type=\"Buchi\">").append(NEW_LINE);
        for (Object STATE : this.mNwa.getFinalStates()) {
            stringBuilder.append('\t').append('\t').append(STATE_ID_OPEN).append(this.mStateConverter.convert(STATE)).append(STATE_ID_CLOSE).append(NEW_LINE);
        }
        stringBuilder.append('\t').append("</Acc>").append(NEW_LINE);
    }
}

