/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum HoareAnnotationPositions {
    All,
    LoopHeads,
    LoopsAndPotentialCycles,
    None;


    public <LOC extends IcfgLocation> Set<LOC> getLocations(IIcfg<LOC> iIcfg) {
        HashSet hashSet = new HashSet();
        switch (this) {
            case All: {
                for (Map map : iIcfg.getProgramPoints().values()) {
                    hashSet.addAll(map.values());
                }
                break;
            }
            case LoopsAndPotentialCycles: {
                hashSet.addAll(iIcfg.getLoopLocations());
                hashSet.addAll(IcfgUtils.getCallerAndCalleePoints(iIcfg));
                hashSet.addAll(IcfgUtils.getReturnPredecessorPoints(iIcfg));
                hashSet.addAll(iIcfg.getLocationsOfInterest());
                break;
            }
            case LoopHeads: {
                hashSet.addAll(iIcfg.getLoopLocations());
                hashSet.addAll(IcfgUtils.getCallerAndCalleePoints(iIcfg));
                hashSet.addAll(IcfgUtils.getReturnPredecessorPoints(iIcfg));
                break;
            }
            case None: {
                return Set.of();
            }
            default: {
                throw new AssertionError((Object)("unknown value " + String.valueOf((Object)this)));
            }
        }
        return hashSet;
    }
}

