/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.translator;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.pea.CounterTrace;
import de.uni_freiburg.informatik.ultimate.lib.pea.PEAComplement;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.srparse.Durations;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.IReq2Pea;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.IReq2PeaAnnotator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.ReqCheckAnnotator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.ReqSymboltableBuilder;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RedundancyTransformerReq2Pea
implements IReq2Pea {
    private final ILogger mLogger;
    private final List<DeclarationPattern> mInitPattern;
    private final List<PatternType.ReqPeas> mReqPeas;
    private IReqSymbolTable mSymbolTable;
    private boolean mHasErrors;
    private final IUltimateServiceProvider mServices;
    private final Durations mDurations;

    public RedundancyTransformerReq2Pea(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, List<DeclarationPattern> list) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mInitPattern = list;
        this.mReqPeas = new ArrayList<PatternType.ReqPeas>();
        this.mDurations = new Durations();
    }

    @Override
    public void transform(IReq2Pea iReq2Pea) {
        DeclarationPattern declarationPattern2;
        IReqSymbolTable iReqSymbolTable;
        ReqSymboltableBuilder reqSymboltableBuilder = new ReqSymboltableBuilder(this.mServices, this.mLogger);
        this.mSymbolTable = iReqSymbolTable = iReq2Pea.getSymboltable();
        Set<String> set = this.mSymbolTable.getConstVars();
        for (DeclarationPattern declarationPattern2 : this.mInitPattern) {
            reqSymboltableBuilder.addInitPattern(declarationPattern2);
            this.mDurations.addInitPattern(declarationPattern2);
        }
        declarationPattern2 = iReq2Pea.getReqPeas();
        for (PatternType.ReqPeas reqPeas : declarationPattern2) {
            PatternType patternType = reqPeas.getPattern();
            List list = reqPeas.getCounterTrace2Pea();
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (Map.Entry entry : list) {
                PhaseEventAutomata phaseEventAutomata = (PhaseEventAutomata)entry.getValue();
                PEAComplement pEAComplement = new PEAComplement(phaseEventAutomata, set);
                PhaseEventAutomata phaseEventAutomata2 = pEAComplement.getTotalisedPEA();
                arrayList.add(new Pair((Object)((CounterTrace)entry.getKey()), (Object)phaseEventAutomata2));
                reqSymboltableBuilder.addPea(patternType, phaseEventAutomata2);
            }
            this.mReqPeas.add(new PatternType.ReqPeas(patternType, arrayList));
        }
        this.mSymbolTable = reqSymboltableBuilder.constructSymbolTable();
    }

    @Override
    public List<PatternType.ReqPeas> getReqPeas() {
        return this.mReqPeas;
    }

    @Override
    public IReqSymbolTable getSymboltable() {
        return this.mSymbolTable;
    }

    @Override
    public Durations getDurations() {
        return this.mDurations;
    }

    @Override
    public boolean hasErrors() {
        return this.mHasErrors;
    }

    @Override
    public IReq2PeaAnnotator getAnnotator() {
        return new ReqCheckAnnotator(this.mServices, this.mLogger, this.mReqPeas, this.mSymbolTable, this.mDurations);
    }
}

