/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.CondisTermTransducer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TreeHashRelation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Deprecated
public class DerScout
extends CondisTermTransducer<DerApplicability> {
    public final TermVariable mEliminatee;
    public final Script mScript;
    public final int mQuantifier;

    public DerScout(TermVariable termVariable, Script script, int n) {
        this.mEliminatee = termVariable;
        this.mScript = script;
        this.mQuantifier = n;
    }

    @Override
    protected DerApplicability transduceAtom(Term term) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (Arrays.asList(term.getFreeVars()).contains(this.mEliminatee)) {
            SolvedBinaryRelation solvedBinaryRelation;
            bigInteger2 = BigInteger.ZERO;
            PolynomialRelation polynomialRelation = PolynomialRelation.of(this.mScript, term);
            bigInteger = polynomialRelation == null ? BigInteger.ONE : ((solvedBinaryRelation = polynomialRelation.solveForSubject(this.mScript, (Term)this.mEliminatee)) == null ? BigInteger.ONE : (polynomialRelation.getRelationSymbol() == QuantifierUtils.getDerOperator(this.mQuantifier) ? BigInteger.ZERO : BigInteger.ONE));
        } else {
            bigInteger = BigInteger.ONE;
            bigInteger2 = BigInteger.ONE;
        }
        return new DerApplicability(Adk.ATOM, BigInteger.ONE, bigInteger, bigInteger2);
    }

    @Override
    protected DerApplicability transduceConjunction(ApplicationTerm applicationTerm, List<DerApplicability> list) {
        DerApplicability derApplicability;
        Adk adk = Adk.DISJUNCTION;
        Adk adk2 = Adk.CONJUNCTION;
        if (this.mQuantifier == 0) {
            derApplicability = DerScout.multiply(list, adk, adk2);
        } else if (this.mQuantifier == 1) {
            derApplicability = DerScout.add(list, adk, adk2);
        } else {
            throw new AssertionError();
        }
        return derApplicability;
    }

    @Override
    protected DerApplicability transduceDisjunction(ApplicationTerm applicationTerm, List<DerApplicability> list) {
        DerApplicability derApplicability;
        Adk adk = Adk.CONJUNCTION;
        Adk adk2 = Adk.DISJUNCTION;
        if (this.mQuantifier == 0) {
            derApplicability = DerScout.add(list, adk, adk2);
        } else if (this.mQuantifier == 1) {
            derApplicability = DerScout.multiply(list, adk, adk2);
        } else {
            throw new AssertionError();
        }
        return derApplicability;
    }

    private static DerApplicability multiply(List<DerApplicability> list, Adk adk, Adk adk2) throws AssertionError {
        BigInteger bigInteger = BigInteger.ONE;
        BigInteger bigInteger2 = BigInteger.ONE;
        BigInteger bigInteger3 = BigInteger.ONE;
        for (DerApplicability derApplicability : list) {
            if (derApplicability.getAdk() == Adk.ATOM || derApplicability.getAdk() == adk) {
                bigInteger = bigInteger.multiply(derApplicability.getCases());
                bigInteger2 = bigInteger2.multiply(derApplicability.getWithoutDerCases());
                bigInteger3 = bigInteger3.multiply(derApplicability.getWithoutVarCases());
                continue;
            }
            throw new AssertionError((Object)"expected conjunction-disjunction alternation");
        }
        return new DerApplicability(adk2, bigInteger, bigInteger2, bigInteger3);
    }

    private static DerApplicability add(List<DerApplicability> list, Adk adk, Adk adk2) throws AssertionError {
        BigInteger bigInteger = BigInteger.ZERO;
        BigInteger bigInteger2 = BigInteger.ZERO;
        BigInteger bigInteger3 = BigInteger.ZERO;
        for (DerApplicability derApplicability : list) {
            if (derApplicability.getAdk() == Adk.ATOM || derApplicability.getAdk() == adk) {
                bigInteger = bigInteger.add(derApplicability.getCases());
                bigInteger2 = bigInteger2.add(derApplicability.getWithoutDerCases());
                bigInteger3 = bigInteger3.add(derApplicability.getWithoutVarCases());
                continue;
            }
            throw new AssertionError((Object)"expected conjunction-disjunction alternation");
        }
        return new DerApplicability(adk2, bigInteger, bigInteger2, bigInteger3);
    }

    private static List<Integer> computeMaximum(List<Integer> list, List<Integer> list2) {
        List<Integer> list3;
        List<Integer> list4;
        if (list.size() >= list2.size()) {
            list4 = list;
            list3 = list2;
        } else {
            list4 = list2;
            list3 = list;
        }
        int n = 0;
        while (n < list3.size()) {
            list4.set(n, Integer.max(list4.get(n), list3.get(n)));
            ++n;
        }
        return list4;
    }

    public static TermVariable selectBestEliminatee(Script script, int n, List<TermVariable> list, List<Term> list2) {
        if (list.size() == 1) {
            return list.iterator().next();
        }
        Map<TermVariable, BigInteger> map = DerScout.computeDerApplicabilityScore(script, n, list, list2);
        TreeHashRelation treeHashRelation = new TreeHashRelation();
        treeHashRelation.reverseAddAll(map);
        Map.Entry entry = (Map.Entry)treeHashRelation.entrySet().iterator().next();
        return (TermVariable)((HashSet)entry.getValue()).iterator().next();
    }

    private static Map<TermVariable, BigInteger> computeDerApplicabilityScore(Script script, int n, List<TermVariable> list, List<Term> list2) {
        Term term = QuantifierUtils.applyDualFiniteConnective(script, n, list2);
        HashMap<TermVariable, BigInteger> hashMap = new HashMap<TermVariable, BigInteger>();
        for (TermVariable termVariable : list) {
            DerApplicability derApplicability = (DerApplicability)new DerScout(termVariable, script, n).transduce(term);
            BigInteger bigInteger = derApplicability.getWithoutDerCases().subtract(derApplicability.getWithoutVarCases());
            hashMap.put(termVariable, bigInteger);
        }
        return hashMap;
    }

    public static int computeRecommendation(Script script, Set<TermVariable> set, Term[] termArray, int n) {
        DerApplicability derApplicability;
        Object object;
        HashMap<TermVariable, Object> hashMap = new HashMap<TermVariable, Object>();
        for (TermVariable termVariable : set) {
            Object n6;
            ArrayList arrayList = new ArrayList();
            object = termArray;
            int n2 = termArray.length;
            int n3 = 0;
            while (n3 < n2) {
                n6 = object[n3];
                derApplicability = (DerApplicability)new DerScout(termVariable, script, n).transduce((Term)n6);
                arrayList.add(derApplicability);
                ++n3;
            }
            n6 = DerScout.multiply(arrayList, Adk.getCorrespondingFiniteConnective(n), Adk.getDualFiniteConnective(n));
            Object object2 = ((DerApplicability)n6).getWithoutDerCases().subtract(((DerApplicability)n6).getWithoutVarCases());
            n2 = ((BigInteger)object2).equals(BigInteger.ZERO) ? 1 : 0;
            if (n2 == 0) continue;
            hashMap.put(termVariable, arrayList);
        }
        double[] dArray = new double[termArray.length];
        for (Map.Entry entry : hashMap.entrySet()) {
            int n4 = 0;
            for (Object object2 : (List)entry.getValue()) {
                object = ((DerApplicability)object2).getCases().subtract(((DerApplicability)object2).getWithoutDerCases());
                derApplicability = Rational.valueOf((BigInteger)object, (BigInteger)BigInteger.ONE);
                Rational rational = Rational.valueOf((BigInteger)((DerApplicability)object2).getCases(), (BigInteger)BigInteger.ONE);
                double d = SmtUtils.approximateAsDouble(derApplicability.div(rational));
                int n5 = n4++;
                dArray[n5] = dArray[n5] + d;
            }
        }
        double d = dArray[0];
        int n6 = 0;
        int n7 = 1;
        while (n7 < dArray.length) {
            if (dArray[n7] > d) {
                n6 = n7;
                d = dArray[n7];
            }
            ++n7;
        }
        assert (d >= 0.0);
        if (d > 0.0) {
            return n6;
        }
        return -1;
    }

    public static enum Adk {
        ATOM,
        DISJUNCTION,
        CONJUNCTION;


        public static Adk getCorrespondingFiniteConnective(int n) {
            if (n == 0) {
                return DISJUNCTION;
            }
            if (n == 1) {
                return CONJUNCTION;
            }
            throw new AssertionError((Object)("unknown value " + n));
        }

        public static Adk getDualFiniteConnective(int n) {
            if (n == 0) {
                return CONJUNCTION;
            }
            if (n == 1) {
                return DISJUNCTION;
            }
            throw new AssertionError((Object)("unknown value " + n));
        }
    }

    public static class DerApplicability {
        private final Adk mAdk;
        private final BigInteger mCases;
        private final BigInteger mWitoutDerCases;
        private final BigInteger mWithoutVarCases;

        public DerApplicability(Adk adk, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            this.mAdk = adk;
            this.mCases = bigInteger;
            this.mWitoutDerCases = bigInteger2;
            this.mWithoutVarCases = bigInteger3;
        }

        public Adk getAdk() {
            return this.mAdk;
        }

        public BigInteger getCases() {
            return this.mCases;
        }

        public BigInteger getWithoutDerCases() {
            return this.mWitoutDerCases;
        }

        public BigInteger getWithoutVarCases() {
            return this.mWithoutVarCases;
        }

        public String toString() {
            return this.mAdk.toString() + String.valueOf(this.mCases) + "/" + String.valueOf(this.mWitoutDerCases) + "/" + String.valueOf(this.mWithoutVarCases);
        }
    }
}

