/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class SyntacticNamingExpression
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(SyntacticNamingExpression.class);
    String identifier;
    Expression expression;

    public SyntacticNamingExpression(String string, Expression expression) {
        this.identifier = string;
        this.expression = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid SyntacticNamingExpression: " + String.valueOf(this);
    }

    public SyntacticNamingExpression(ACSLType aCSLType, String string, Expression expression) {
        super(aCSLType);
        this.identifier = string;
        this.expression = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid SyntacticNamingExpression: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SyntacticNamingExpression").append('[');
        stringBuffer.append(this.identifier);
        stringBuffer.append(',').append(this.expression);
        return stringBuffer.append(']').toString();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.expression);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.expression != null) {
                this.expression.accept(aCSLVisitor);
            }
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        Expression expression2 = null;
        if (this.expression != null) {
            expression2 = this.expression.accept(aCSLTransformer);
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        if (this.expression != expression2 || this.type != aCSLType) {
            return new SyntacticNamingExpression(aCSLType, this.identifier, expression2);
        }
        return this;
    }
}

