/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class ArrayStoreExpression
extends Expression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(ArrayStoreExpression.class);
    Expression array;
    Expression[] indices;
    Expression value;

    public ArrayStoreExpression(ILocation iLocation, Expression expression, Expression[] expressionArray, Expression expression2) {
        super(iLocation);
        this.array = expression;
        this.indices = expressionArray;
        this.value = expression2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ArrayStoreExpression: " + String.valueOf((Object)this);
    }

    public ArrayStoreExpression(ILocation iLocation, IBoogieType iBoogieType, Expression expression, Expression[] expressionArray, Expression expression2) {
        super(iLocation, iBoogieType);
        this.array = expression;
        this.indices = expressionArray;
        this.value = expression2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid ArrayStoreExpression: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ArrayStoreExpression").append('[');
        stringBuffer.append((Object)this.array);
        stringBuffer.append(',');
        if (this.indices == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.indices.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.indices[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append((Object)this.value);
        return stringBuffer.append(']').toString();
    }

    public Expression getArray() {
        return this.array;
    }

    public Expression[] getIndices() {
        return this.indices;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.array);
        if (this.indices != null) {
            list.addAll(Arrays.asList(this.indices));
        }
        list.add(this.value);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Expression)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            if (this.array != null) {
                this.array.accept(generatedBoogieAstVisitor);
            }
            if (this.indices != null) {
                Expression[] expressionArray = this.indices;
                int n = this.indices.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression expression = expressionArray[n2];
                    expression.accept(generatedBoogieAstVisitor);
                    ++n2;
                }
            }
            if (this.value != null) {
                this.value.accept(generatedBoogieAstVisitor);
            }
        }
    }

    @Override
    public Expression accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Expression expression;
        Expression expression2 = generatedBoogieAstTransformer.transform(this);
        if (expression2 != this) {
            return expression2;
        }
        Expression expression3 = null;
        if (this.array != null) {
            expression3 = this.array.accept(generatedBoogieAstTransformer);
        }
        boolean bl = false;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (this.indices != null) {
            Expression[] expressionArray = this.indices;
            int n = this.indices.length;
            int n2 = 0;
            while (n2 < n) {
                expression = expressionArray[n2];
                Expression expression4 = expression.accept(generatedBoogieAstTransformer);
                bl = bl || expression4 != expression;
                arrayList.add(expression4);
                ++n2;
            }
        }
        expression = null;
        if (this.value != null) {
            expression = this.value.accept(generatedBoogieAstTransformer);
        }
        if (bl || this.array != expression3 || this.value != expression) {
            return new ArrayStoreExpression(this.loc, this.type, expression3, arrayList.toArray(new Expression[0]), expression);
        }
        return this;
    }
}

