/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiAccepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsIncluded;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.IBuchiNwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LassoExtractor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsDeterministic;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.List;

public final class BuchiIsEquivalent<LETTER, STATE>
extends BinaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private static final int MAXIMUM_AUTOMATON_SIZE_FOR_DYNAMIC_TEST = 10;
    private static final int TIMEOUT_MILLISECONDS_FOR_DYNAMIC_TEST = 1000;
    private static final int NUMBER_OF_ONE_SYMBOL_RANDOM_WORDS = 6;
    private static final int NUMBER_OF_TWO_SYMBOL_RANDOM_WORDS = 11;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    private final boolean mResult;
    private NestedLassoWord<LETTER> mCounterexample;
    private boolean mCompleteTestWasApplied;
    private String mMessage;

    public BuchiIsEquivalent(AutomataLibraryServices automataLibraryServices, IBuchiNwaInclusionStateFactory<STATE> iBuchiNwaInclusionStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException {
        this(automataLibraryServices, iBuchiNwaInclusionStateFactory, iNwaOutgoingLetterAndTransitionProvider, iNwaOutgoingLetterAndTransitionProvider2, TestMode.DYNAMIC);
    }

    public BuchiIsEquivalent(AutomataLibraryServices automataLibraryServices, IBuchiNwaInclusionStateFactory<STATE> iBuchiNwaInclusionStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2, TestMode testMode) throws AutomataLibraryException {
        super(automataLibraryServices);
        this.mFstOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider2;
        if (!NestedWordAutomataUtils.sameAlphabet(this.mFstOperand, this.mSndOperand)) {
            throw new AutomataLibraryException(this.getClass(), "The operands have different alphabets.");
        }
        this.printStartMessage();
        this.mResult = this.run(iBuchiNwaInclusionStateFactory, testMode);
        this.printExitMessage();
    }

    @Override
    public String exitMessage() {
        if (!this.mResult) {
            return "Buchi automata are not equivalent.";
        }
        if (this.mCompleteTestWasApplied) {
            return "Complete test succeeded. Buchi automata are equivalent.";
        }
        return "Incomplete test succeeded. Buchi automata could be equivalent.";
    }

    @Override
    public Boolean getResult() {
        return this.mResult;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mFstOperand;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSndOperand;
    }

    public NestedLassoWord<LETTER> getCounterexample() {
        if (this.mResult) {
            throw new UnsupportedOperationException("No counterexample available.");
        }
        return this.mCounterexample;
    }

    public String getViolationMessage() {
        return this.mMessage;
    }

    public boolean isCompleteTestUsed() {
        return this.mCompleteTestWasApplied;
    }

    private boolean run(IBuchiNwaInclusionStateFactory<STATE> iBuchiNwaInclusionStateFactory, TestMode testMode) throws AutomataLibraryException {
        switch (testMode) {
            case COMPLETE: {
                return this.checkEquivalencePrecisely(this.mServices, iBuchiNwaInclusionStateFactory);
            }
            case DYNAMIC: {
                return this.checkEquivalenceDynamically(iBuchiNwaInclusionStateFactory);
            }
            case INCOMPLETE: {
                return this.checkEquivalenceImprecisely();
            }
        }
        throw new IllegalArgumentException("Unknown test mode: " + String.valueOf((Object)testMode));
    }

    private boolean checkEquivalencePrecisely(AutomataLibraryServices automataLibraryServices, IBuchiNwaInclusionStateFactory<STATE> iBuchiNwaInclusionStateFactory) throws AutomataLibraryException {
        if (!this.checkInclusionPrecisely(automataLibraryServices, iBuchiNwaInclusionStateFactory, this.mFstOperand, this.mSndOperand)) {
            this.mMessage = "The first operand recognizes a word not recognized by the second one.";
            return false;
        }
        if (!this.checkInclusionPrecisely(automataLibraryServices, iBuchiNwaInclusionStateFactory, this.mSndOperand, this.mFstOperand)) {
            this.mMessage = "The second operand recognizes a word not recognized by the first one.";
            return false;
        }
        this.mCompleteTestWasApplied = true;
        return true;
    }

    private boolean checkInclusionPrecisely(AutomataLibraryServices automataLibraryServices, IBuchiNwaInclusionStateFactory<STATE> iBuchiNwaInclusionStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException {
        NestedLassoRun<LETTER, STATE> nestedLassoRun = new BuchiIsIncluded<LETTER, STATE>(automataLibraryServices, iBuchiNwaInclusionStateFactory, iNwaOutgoingLetterAndTransitionProvider, iNwaOutgoingLetterAndTransitionProvider2).getCounterexample();
        if (nestedLassoRun != null) {
            this.mCounterexample = nestedLassoRun.getNestedLassoWord();
            return false;
        }
        return true;
    }

    private boolean checkEquivalenceImprecisely() throws AutomataLibraryException {
        if (!this.extractAndCheckLassoWords(this.mFstOperand, this.mSndOperand)) {
            this.mMessage = "The first operand recognizes a word not recognized by the second one.";
            return false;
        }
        if (!this.extractAndCheckLassoWords(this.mSndOperand, this.mFstOperand)) {
            this.mMessage = "The second operand recognizes a word not recognized by the first one.";
            return false;
        }
        if (!this.generateAndCompareRandomLassoWords()) {
            this.mMessage = "One of the operands recognizes a word not recognized by the other one.";
            return false;
        }
        return true;
    }

    private boolean checkEquivalenceDynamically(IBuchiNwaInclusionStateFactory<STATE> iBuchiNwaInclusionStateFactory) throws AutomataLibraryException {
        boolean bl = this.mFstOperand.size() <= 10 && this.mSndOperand.size() <= 10;
        boolean bl2 = bl = bl || new IsDeterministic<LETTER, STATE>(this.mServices, this.mFstOperand).getResult() != false && new IsDeterministic<LETTER, STATE>(this.mServices, this.mSndOperand).getResult() != false;
        if (bl) {
            try {
                return this.checkEquivalencePrecisely(new AutomataLibraryServices(this.mServices, 1000L), iBuchiNwaInclusionStateFactory);
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {}
        }
        if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
            throw new AutomataOperationCanceledException(this.getClass());
        }
        return this.checkEquivalenceImprecisely();
    }

    private boolean extractAndCheckLassoWords(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException {
        ArrayList<NestedLassoWord<LETTER>> arrayList = new ArrayList<NestedLassoWord<LETTER>>(new LassoExtractor<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider).getResult());
        return this.checkLassoWords(iNwaOutgoingLetterAndTransitionProvider2, arrayList);
    }

    private boolean checkLassoWords(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, List<NestedLassoWord<LETTER>> list) throws AutomataLibraryException {
        for (NestedLassoWord<LETTER> nestedLassoWord : list) {
            if (this.checkLassoWord(iNwaOutgoingLetterAndTransitionProvider, nestedLassoWord)) continue;
            this.mCounterexample = nestedLassoWord;
            return false;
        }
        return true;
    }

    private boolean checkLassoWord(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, NestedLassoWord<LETTER> nestedLassoWord) throws AutomataLibraryException {
        return new BuchiAccepts<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider, nestedLassoWord).getResult();
    }

    private boolean generateAndCompareRandomLassoWords() throws AutomataLibraryException {
        ArrayList<NestedLassoWord<LETTER>> arrayList = new ArrayList<NestedLassoWord<LETTER>>();
        this.addRandomLassoWords(arrayList, 1, 6);
        this.addRandomLassoWords(arrayList, 2, 11);
        return this.compareOnLassoWords(arrayList);
    }

    private void addRandomLassoWords(List<NestedLassoWord<LETTER>> list, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            list.add(NestedWordAutomataUtils.getRandomNestedLassoWord(this.mFstOperand, n, n3));
            ++n3;
        }
    }

    private boolean compareOnLassoWords(List<NestedLassoWord<LETTER>> list) throws AutomataLibraryException {
        for (NestedLassoWord<LETTER> nestedLassoWord : list) {
            boolean bl;
            boolean bl2 = this.checkLassoWord(this.mFstOperand, nestedLassoWord);
            if (bl2 == (bl = this.checkLassoWord(this.mSndOperand, nestedLassoWord))) continue;
            this.mCounterexample = nestedLassoWord;
            return false;
        }
        return true;
    }

    public static enum TestMode {
        COMPLETE,
        DYNAMIC,
        INCOMPLETE;

    }
}

