/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.results.NoBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.ProgramExecutionFormatter;
import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IcfgProgramExecution<L extends IAction>
implements IProgramExecution<L, Term> {
    private final List<AtomicTraceElement<L>> mTrace;
    private final Map<Integer, IProgramExecution.ProgramState<Term>> mPartialProgramStateMapping;
    private final Map<TermVariable, Boolean>[] mBranchEncoders;
    private final boolean mIsConcurrent;
    private final Class<L> mTransitionClazz;

    public IcfgProgramExecution(List<AtomicTraceElement<L>> list, Map<Integer, IProgramExecution.ProgramState<Term>> map, Map<TermVariable, Boolean>[] mapArray, boolean bl, Class<L> clazz) {
        assert (map != null);
        assert (mapArray != null);
        assert (list != null);
        assert (map.size() - 1 <= list.size());
        this.mIsConcurrent = bl;
        this.mTrace = list;
        this.mPartialProgramStateMapping = map;
        assert (this.isProgramStateMappingInRange(list, map));
        this.mBranchEncoders = mapArray;
        this.mTransitionClazz = clazz;
    }

    private boolean isProgramStateMappingInRange(List<AtomicTraceElement<L>> list, Map<Integer, IProgramExecution.ProgramState<Term>> map) {
        for (Map.Entry<Integer, IProgramExecution.ProgramState<Term>> entry : map.entrySet()) {
            if (entry.getKey() < -1) {
                assert (false) : "Position of state below -1: " + String.valueOf(entry);
                return false;
            }
            if (entry.getKey() < list.size()) continue;
            assert (false) : "Position of state above end of trace: " + String.valueOf(entry);
            return false;
        }
        return true;
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(Class<L> clazz) {
        return IcfgProgramExecution.create(Collections.emptyList(), Collections.emptyMap(), new ArrayList().toArray(new Map[0]), null, clazz);
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> list, Map<Integer, IProgramExecution.ProgramState<Term>> map, Map<TermVariable, Boolean>[] mapArray) {
        return IcfgProgramExecution.create(list, map, mapArray, null, IcfgProgramExecution.getClassFromTrace(list));
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> list, Map<Integer, IProgramExecution.ProgramState<Term>> map, Map<TermVariable, Boolean>[] mapArray, Class<L> clazz) {
        return IcfgProgramExecution.create(list, map, mapArray, null, clazz);
    }

    private static <L extends IAction> Class<L> getClassFromTrace(List<L> list) {
        return ((IAction)list.stream().findFirst().orElseThrow(() -> new UnsupportedOperationException("Empty trace is not supported"))).getClass();
    }

    public static <L extends IAction> Class<L> getClassFromAtomicTraceElements(List<AtomicTraceElement<L>> list) {
        return ((IAction)((AtomicTraceElement)list.stream().findFirst().orElseThrow(() -> new UnsupportedOperationException("Empty trace is not supported"))).getTraceElement()).getClass();
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> list, Map<Integer, IProgramExecution.ProgramState<Term>> map) {
        return IcfgProgramExecution.create(list, map, new ArrayList().toArray(new Map[0]), null, IcfgProgramExecution.getClassFromTrace(list));
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> list, Map<Integer, IProgramExecution.ProgramState<Term>> map, Class<L> clazz) {
        return IcfgProgramExecution.create(list, map, new ArrayList().toArray(new Map[0]), null, clazz);
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> list, Map<Integer, IProgramExecution.ProgramState<Term>> map, Map<TermVariable, Boolean>[] mapArray, List<IRelevanceInformation> list2) {
        return IcfgProgramExecution.create(list, map, mapArray, list2, IcfgProgramExecution.getClassFromTrace(list));
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> list, Map<Integer, IProgramExecution.ProgramState<Term>> map, Map<TermVariable, Boolean>[] mapArray, List<IRelevanceInformation> list2, Class<L> clazz) {
        int[] nArray;
        Map<String, Integer> map2;
        boolean bl = IcfgProgramExecution.isConcurrent(list);
        if (bl) {
            map2 = IcfgProgramExecution.createThreadIds(list);
            nArray = IcfgProgramExecution.createThreadIdsFromMap(list, map2);
        } else {
            map2 = null;
            nArray = null;
        }
        return new IcfgProgramExecution<L>(IcfgProgramExecution.createATESequence(list, list2, map2, nArray), map, mapArray, nArray != null, clazz);
    }

    private static int[] createThreadIdsFromMap(List<? extends IAction> list, Map<String, Integer> map) {
        int[] nArray = new int[list.size()];
        int n = 0;
        for (IAction iAction : list) {
            Integer n2 = map.get(iAction.getPrecedingProcedure());
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    private static boolean isConcurrent(List<? extends IAction> list) {
        return list.stream().anyMatch(iAction -> iAction instanceof IIcfgForkTransitionThreadOther || iAction instanceof IIcfgJoinTransitionThreadOther || iAction instanceof IIcfgForkTransitionThreadCurrent || iAction instanceof IIcfgJoinTransitionThreadCurrent);
    }

    private static final Map<String, Integer> createThreadIds(List<? extends IAction> list) {
        int n = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (list.isEmpty()) {
            throw new UnsupportedOperationException("trace has length 0");
        }
        String string = list.get(0).getPrecedingProcedure();
        hashMap.put(string, n);
        ++n;
        for (IAction iAction : list) {
            String string2;
            Integer n2 = (Integer)hashMap.get(iAction.getPrecedingProcedure());
            if (n2 == null) {
                throw new AssertionError((Object)("No thread ID for procedure " + iAction.getPrecedingProcedure()));
            }
            if (!(iAction instanceof IcfgForkThreadOtherTransition) || hashMap.containsKey(string2 = iAction.getSucceedingProcedure())) continue;
            hashMap.put(string2, n);
            ++n;
        }
        return hashMap;
    }

    private static <LETTER extends IAction> List<AtomicTraceElement<LETTER>> createATESequence(List<LETTER> list, List<IRelevanceInformation> list2, Map<String, Integer> map, int[] nArray) {
        assert (list != null);
        assert (list2 == null || list.size() == list2.size()) : "incompatible sizes";
        assert (nArray == null || nArray.length == list.size());
        ArrayList<AtomicTraceElement<LETTER>> arrayList = new ArrayList<AtomicTraceElement<LETTER>>();
        int n = 0;
        while (n < list.size()) {
            IAction iAction = (IAction)list.get(n);
            AtomicTraceElement.AtomicTraceElementBuilder atomicTraceElementBuilder = new AtomicTraceElement.AtomicTraceElementBuilder();
            atomicTraceElementBuilder.setStepAndElement((Object)iAction);
            atomicTraceElementBuilder.setProcedures(iAction.getPrecedingProcedure(), iAction.getSucceedingProcedure());
            if (map != null) {
                atomicTraceElementBuilder.setThreadId(nArray[n]);
            }
            if (list2 != null) {
                atomicTraceElementBuilder.setRelevanceInformation(list2.get(n));
            }
            if (iAction instanceof IIcfgForkTransitionThreadOther) {
                var8_8 = (IIcfgTransition)iAction;
                if (map != null) {
                    var9_9 = map.get(((IcfgLocation)var8_8.getTarget()).getProcedure());
                    assert (var9_9 != null);
                    atomicTraceElementBuilder.setForkedThreadId(var9_9.intValue());
                }
                atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.FORK});
                assert (map != null);
            } else if (iAction instanceof IIcfgForkTransitionThreadCurrent) {
                var8_8 = (IIcfgTransition)iAction;
                if (map != null) {
                    var9_9 = map.get(((IcfgLocation)var8_8.getTarget()).getProcedure());
                    assert (var9_9 != null);
                    atomicTraceElementBuilder.setForkedThreadId(var9_9.intValue());
                }
                atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.FORK});
                assert (map != null);
            } else if (iAction instanceof IIcfgJoinTransitionThreadOther) {
                var8_8 = (IIcfgTransition)iAction;
                if (map != null) {
                    var9_9 = map.get(((IcfgLocation)var8_8.getSource()).getProcedure());
                    assert (var9_9 != null);
                    atomicTraceElementBuilder.setJoinedThreadId(var9_9.intValue());
                }
                atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.JOIN});
                assert (map != null);
            } else if (iAction instanceof IIcfgJoinTransitionThreadCurrent) {
                atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.JOIN});
                assert (map != null);
            } else if (iAction instanceof IIcfgCallTransition) {
                atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.PROC_CALL});
            } else if (iAction instanceof IIcfgReturnTransition) {
                atomicTraceElementBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.PROC_RETURN});
            }
            arrayList.add(atomicTraceElementBuilder.build());
            ++n;
        }
        return arrayList;
    }

    public Map<TermVariable, Boolean>[] getBranchEncoders() {
        return this.mBranchEncoders;
    }

    public int getLength() {
        return this.mTrace.size();
    }

    public AtomicTraceElement<L> getTraceElement(int n) {
        return this.mTrace.get(n);
    }

    public IProgramExecution.ProgramState<Term> getProgramState(int n) {
        if (n < 0 || n >= this.mTrace.size()) {
            throw new IllegalArgumentException("out of range");
        }
        return this.mPartialProgramStateMapping.get(n);
    }

    public IProgramExecution.ProgramState<Term> getInitialProgramState() {
        return this.mPartialProgramStateMapping.get(-1);
    }

    public String toString() {
        ProgramExecutionFormatter programExecutionFormatter = new ProgramExecutionFormatter(new IcfgBacktranslationValueProvider());
        return programExecutionFormatter.formatProgramExecution((IProgramExecution)this);
    }

    public Class<Term> getExpressionClass() {
        return Term.class;
    }

    public Class<? extends L> getTraceElementClass() {
        return this.mTransitionClazz;
    }

    public IcfgProgramExecution<L> addRelevanceInformation(List<IRelevanceInformation> list) {
        ArrayList<AtomicTraceElement<L>> arrayList = new ArrayList<AtomicTraceElement<L>>();
        list.iterator();
        boolean bl = false;
        for (AtomicTraceElement<L> atomicTraceElement : this.mTrace) {
            bl = bl || atomicTraceElement.hasThreadId();
            arrayList.add(atomicTraceElement);
        }
        return new IcfgProgramExecution<L>(arrayList, this.mPartialProgramStateMapping, this.mBranchEncoders, bl, this.mTransitionClazz);
    }

    public IBacktranslationValueProvider<L, Term> getBacktranslationValueProvider() {
        return new NoBacktranslationValueProvider();
    }

    public boolean isConcurrent() {
        return this.mIsConcurrent;
    }
}

