/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class GraphViz {
    public static final String END_GRAPH = "}";
    public static final String START_GRAPH = "digraph G {";
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String DOT = "c:/Program Files/GraphViz/bin/dot.exe";
    private StringBuilder mGraph = new StringBuilder();
    private final ILogger mLogger;

    public GraphViz(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    public String getDotSource() {
        return this.mGraph.toString();
    }

    public void add(String string) {
        this.mGraph.append(string);
    }

    public void addLine(String string) {
        this.mGraph.append(string).append(CoreUtil.getPlatformLineSeparator());
    }

    public void addLine() {
        this.mGraph.append(CoreUtil.getPlatformLineSeparator());
    }

    public byte[] getGraph(String string, String string2) {
        byte[] byArray = new byte[]{};
        File file = this.writeDotSourceToFile(string);
        if (file != null) {
            byArray = this.getImgStream(file, string2);
            if (!file.delete()) {
                this.mLogger.warn((Object)(file.getAbsolutePath() + " could not be deleted!"));
            }
        }
        return byArray;
    }

    public static int writeGraphToFile(byte[] byArray, String string) {
        File file = new File(string);
        return GraphViz.writeGraphToFile(byArray, file);
    }

    public static int writeGraphToFile(byte[] byArray, File file) {
        if (byArray == null || byArray.length == 0 || file == null) {
            return -1;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.write(byArray);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        return 1;
    }

    private byte[] getImgStream(File file, String string) {
        try {
            File file2 = File.createTempFile("graph_", "." + string, new File(TEMP_DIR));
            Runtime runtime = Runtime.getRuntime();
            String[] stringArray = new String[]{DOT, "-T" + string, file.getAbsolutePath(), "-o", file2.getAbsolutePath()};
            Process process = runtime.exec(stringArray);
            process.waitFor();
            byte[] byArray = new byte[]{};
            Throwable throwable = null;
            Object var9_12 = null;
            try (FileInputStream fileInputStream = new FileInputStream(file2.getAbsolutePath());){
                byArray = new byte[fileInputStream.available()];
                int n = fileInputStream.read(byArray);
                if (n != -1) {
                    throw new IOException("Could not read to the end");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (!file2.delete()) {
                this.mLogger.warn((Object)(file2.getAbsolutePath() + " could not be deleted!"));
            }
            return byArray;
        }
        catch (IOException iOException) {
            this.mLogger.error((Object)("I/O processing of tempfile in dir " + TEMP_DIR + " failed. Message: " + iOException.getMessage()));
            return new byte[0];
        }
        catch (InterruptedException interruptedException) {
            this.mLogger.error((Object)("The execution of the external program was interrupted: " + interruptedException.getMessage()));
            Thread.currentThread().interrupt();
            return new byte[0];
        }
    }

    private File writeDotSourceToFile(String string) {
        File file;
        try {
            file = File.createTempFile("graph_", ".dot.tmp", new File(TEMP_DIR));
            CoreUtil.writeFile((File)file, (String)string);
        }
        catch (IOException iOException) {
            this.mLogger.error((Object)("I/O error while writing the dot source to temp file: " + iOException.getMessage()));
            return null;
        }
        return file;
    }

    public void readSource(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            CoreUtil.readFileLineByLine((String)string, stringBuilder::append);
        }
        catch (IOException iOException) {
            this.mLogger.error((Object)("Error: " + iOException.getMessage()));
        }
        this.mGraph = stringBuilder;
    }
}

