/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.Options;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.complement.NCSB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.IntSet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.util.PowerSet;

public class SuccessorGenerator {
    private final boolean mIsCurrBEmpty;
    private final NCSB mSuccNCSB;
    private final IntSet mMinusFSuccs;
    private IntSet mInterFSuccs;
    private final IntSet mF;
    private IntSet mNPrime;
    private IntSet mVPrime;
    private IntSet mMustIn;
    private IntSet mSPrime;
    private IntSet mBPrime;
    private PowerSet mPs;

    public SuccessorGenerator(boolean bl, NCSB nCSB, IntSet intSet, IntSet intSet2, IntSet intSet3) {
        this.mIsCurrBEmpty = bl;
        this.mSuccNCSB = nCSB;
        this.mMinusFSuccs = intSet;
        this.mInterFSuccs = intSet2;
        this.mF = intSet3;
        this.initialize();
    }

    private void initialize() {
        this.mNPrime = this.mSuccNCSB.copyNSet();
        this.mNPrime.andNot(this.mF);
        this.mNPrime.andNot(this.mSuccNCSB.getCSet());
        this.mNPrime.andNot(this.mSuccNCSB.getSSet());
        this.mVPrime = this.mSuccNCSB.copyCSet();
        IntSet intSet = this.mSuccNCSB.copyNSet();
        intSet.and(this.mF);
        this.mVPrime.or(intSet);
        this.mSPrime = this.mSuccNCSB.getSSet();
        this.mBPrime = this.mSuccNCSB.getBSet();
        if (Options.lazyS) {
            if (this.mIsCurrBEmpty) {
                this.mInterFSuccs = this.mSuccNCSB.copyCSet();
                this.mMustIn = this.mSuccNCSB.copyCSet();
                this.mMustIn.and(this.mF);
                this.mMustIn.or(intSet);
            } else {
                this.mMustIn = this.mInterFSuccs.clone();
                this.mMustIn.and(this.mF);
                this.mMustIn.or(this.mMinusFSuccs);
            }
        } else {
            this.mMustIn = this.mInterFSuccs.clone();
            this.mMustIn.and(this.mF);
            this.mMustIn.or(this.mMinusFSuccs);
            this.mMustIn.or(intSet);
        }
        this.mInterFSuccs.andNot(this.mMinusFSuccs);
        this.mInterFSuccs.andNot(this.mSPrime);
        this.mInterFSuccs.andNot(this.mF);
        this.mPs = new PowerSet(this.mInterFSuccs);
    }

    public boolean hasNext() {
        return this.mPs.hasNext();
    }

    public NCSB next() {
        IntSet intSet = this.mPs.next();
        IntSet intSet2 = this.mInterFSuccs.clone();
        intSet2.andNot(intSet);
        IntSet intSet3 = this.mNPrime;
        IntSet intSet4 = null;
        IntSet intSet5 = this.mSPrime.clone();
        IntSet intSet6 = null;
        if (Options.lazyS) {
            intSet5.or(intSet);
            if (this.mIsCurrBEmpty) {
                intSet4 = this.mMustIn.clone();
                intSet4.or(intSet2);
                if (!Options.lazyB) {
                    intSet6 = intSet4;
                } else {
                    intSet6 = this.mSuccNCSB.copyCSet();
                    intSet6.and(intSet4);
                }
            } else {
                intSet6 = this.mMustIn.clone();
                intSet6.or(intSet2);
                intSet4 = this.mVPrime.clone();
                intSet4.andNot(intSet5);
            }
            assert (!intSet5.overlap(this.mF) && !intSet6.overlap(intSet5)) : "S:" + intSet5.toString() + " B:" + intSet6.toString();
        } else {
            intSet4 = this.mMustIn.clone();
            intSet4.or(intSet2);
            intSet5.or(intSet);
            if (this.mIsCurrBEmpty) {
                if (!Options.lazyB) {
                    intSet6 = intSet4;
                } else {
                    intSet6 = this.mSuccNCSB.copyCSet();
                    intSet6.and(intSet4);
                }
            } else {
                intSet6 = this.mBPrime.clone();
                intSet6.and(intSet4);
            }
            assert (!intSet5.overlap(this.mF) && !intSet4.overlap(intSet5)) : "S:" + intSet5.toString() + " C:" + intSet4.toString();
        }
        return new NCSB(intSet3, intSet4, intSet5, intSet6);
    }
}

