/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.ComparisonTables;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CountingMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;

public final class RabitUtil {
    public static final File ENVIRONMENT = new File(new File(System.getProperty("user.home"), "Desktop"), "RabitTestEnvironment");
    public static final File FILE_AUTOMATA = new File(ENVIRONMENT, "automata");
    public static final String FILE_EXTENSION_FILTER = "ba";
    public static final File FILE_OUTPUT = new File(ENVIRONMENT, "testData.tsv");
    public static final int LOG_EVERY = 5;
    public static final int MAX_HEAP_SIZE_GB = 14;
    public static final int MIN_HEAP_SIZE_GB = 2;
    public static final String RABIT_SEPARATOR = " ";
    public static final String SEPARATOR = "\t";
    public static final String TOOL = "Reduce_test.jar";

    private RabitUtil() {
    }

    public static void appendLineToOutput(String string) throws IOException {
        RabitUtil.appendToFile(FILE_OUTPUT, string);
    }

    public static List<File> collectAutomata() {
        LinkedList<File> linkedList = new LinkedList<File>();
        RabitUtil.listFiles(FILE_AUTOMATA, linkedList, FILE_EXTENSION_FILTER);
        return linkedList;
    }

    public static List<String> executeRabit(File file, String string) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        StringBuilder stringBuilder = new StringBuilder("java");
        stringBuilder.append(" -Xms").append(2).append("g -Xms").append(2).append("G");
        stringBuilder.append(" -Xmx").append(14).append("g -Xmx").append(14).append("G");
        stringBuilder.append(" -jar");
        stringBuilder.append(RABIT_SEPARATOR).append(TOOL);
        stringBuilder.append(" \"").append(file.getAbsolutePath()).append("\"");
        stringBuilder.append(RABIT_SEPARATOR).append(string);
        Process process = runtime.exec(stringBuilder.toString(), null, ENVIRONMENT);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String string2 = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            linkedList.add(string2);
        }
        LinkedList<String> linkedList2 = new LinkedList<String>();
        while ((string2 = bufferedReader2.readLine()) != null) {
            linkedList2.add(string2);
        }
        if (!linkedList2.isEmpty()) {
            throw new IllegalStateException("Error in Rabit tool: " + String.valueOf(linkedList2));
        }
        return linkedList;
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("Start");
        LinkedList<Pair<String, SimulationOrMinimizationType>> linkedList = new LinkedList<Pair<String, SimulationOrMinimizationType>>();
        linkedList.add(new Pair((Object)"1 -light", (Object)SimulationOrMinimizationType.EXT_RABIT_LIGHT_1));
        linkedList.add(new Pair((Object)"1 -heavy", (Object)SimulationOrMinimizationType.EXT_RABIT_HEAVY_1));
        List<File> list = RabitUtil.collectAutomata();
        int n = list.size();
        for (File file : list) {
            RabitUtil.processAutomaton(file, linkedList);
            if (--n % 5 != 0) continue;
            System.out.println("\tAutomata to go: " + n);
        }
        System.out.println("Terminated");
    }

    public static void processAutomaton(File file, List<Pair<String, SimulationOrMinimizationType>> list) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("<!--");
        stringBuilder.append(SEPARATOR).append("NAME");
        stringBuilder.append(SEPARATOR).append("TYPE");
        stringBuilder.append(SEPARATOR).append("USED_SCCS");
        stringBuilder.append(SEPARATOR).append("TIMED_OUT");
        stringBuilder.append(SEPARATOR).append("OOM");
        stringBuilder.append(SEPARATOR).append((Object)TimeMeasure.OVERALL);
        stringBuilder.append(SEPARATOR).append((Object)CountingMeasure.BUCHI_ALPHABET_SIZE);
        stringBuilder.append(SEPARATOR).append((Object)CountingMeasure.BUCHI_STATES);
        stringBuilder.append(SEPARATOR).append((Object)CountingMeasure.BUCHI_TRANSITIONS);
        stringBuilder.append(SEPARATOR).append((Object)CountingMeasure.BUCHI_TRANSITIONS_INTERNAL);
        stringBuilder.append(SEPARATOR).append((Object)CountingMeasure.RESULT_ALPHABET_SIZE);
        stringBuilder.append(SEPARATOR).append((Object)CountingMeasure.RESULT_STATES);
        stringBuilder.append(SEPARATOR).append((Object)CountingMeasure.RESULT_TRANSITIONS);
        stringBuilder.append(SEPARATOR).append((Object)CountingMeasure.RESULT_TRANSITIONS_INTERNAL);
        stringBuilder.append(SEPARATOR).append((Object)CountingMeasure.REMOVED_STATES);
        stringBuilder.append(SEPARATOR).append("-->");
        RabitUtil.appendLineToOutput(stringBuilder.toString());
        for (Pair<String, SimulationOrMinimizationType> pair : list) {
            String string = (String)pair.getFirst();
            SimulationOrMinimizationType simulationOrMinimizationType = (SimulationOrMinimizationType)((Object)pair.getSecond());
            List<String> list2 = RabitUtil.executeRabit(file, string);
            if (list2.size() != 1) {
                throw new IllegalStateException("Expected Rabit output to only have one line: " + String.valueOf(list2));
            }
            String[] stringArray = list2.iterator().next().split(RABIT_SEPARATOR);
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(stringArray[0]);
            stringBuilder2.append(SEPARATOR).append((Object)simulationOrMinimizationType);
            stringBuilder2.append(SEPARATOR).append(false);
            stringBuilder2.append(SEPARATOR).append(false);
            stringBuilder2.append(SEPARATOR).append(false);
            stringBuilder2.append(SEPARATOR).append(ComparisonTables.millisToSeconds(Long.parseLong(stringArray[9])));
            stringBuilder2.append(SEPARATOR).append(stringArray[3]);
            stringBuilder2.append(SEPARATOR).append(stringArray[1]);
            stringBuilder2.append(SEPARATOR).append(stringArray[2]);
            stringBuilder2.append(SEPARATOR).append(stringArray[2]);
            stringBuilder2.append(SEPARATOR).append(stringArray[7]);
            stringBuilder2.append(SEPARATOR).append(stringArray[5]);
            stringBuilder2.append(SEPARATOR).append(stringArray[6]);
            stringBuilder2.append(SEPARATOR).append(stringArray[6]);
            stringBuilder2.append(SEPARATOR).append(Integer.parseInt(stringArray[1]) - Integer.parseInt(stringArray[5]));
            RabitUtil.appendLineToOutput(stringBuilder2.toString());
        }
    }

    private static void appendToFile(File file, String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(file, true));
        printWriter.println(string);
        printWriter.close();
    }

    private static void listFiles(File file, List<File> list, String string) {
        File[] fileArray;
        File[] fileArray2 = fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray2[n2];
            if (file2.isFile() && RabitUtil.stripExtension(file2.getName())[1].equals(string)) {
                list.add(file2);
            } else if (file2.isDirectory()) {
                RabitUtil.listFiles(file2, list, string);
            }
            ++n2;
        }
    }

    private static String[] stripExtension(String string) {
        String[] stringArray = new String[2];
        int n = string.lastIndexOf(46);
        if (n == -1) {
            stringArray[0] = string;
            stringArray[1] = "";
        } else {
            stringArray[0] = string.substring(0, n);
            stringArray[1] = string.substring(n + 1);
        }
        return stringArray;
    }
}

