/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.astbuilder;

import de.uni_freiburg.informatik.ultimate.astbuilder.Grammar;
import de.uni_freiburg.informatik.ultimate.astbuilder.Node;
import de.uni_freiburg.informatik.ultimate.astbuilder.Parameter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Emit {
    private static final String INDENT_SPACE = "        ";
    private static final String EMPTY_STRING = "";
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSE_PARENTHESIS_SEMICOLON = ");";
    private static final String COMMA = ", ";
    private static final String SEMICOLON = ";";
    private static final String STAR = " * ";
    private static final String BLANK = " ";
    private static final String BOOLEAN = "boolean";
    private static final int LENGTH_OF_TRUE_PLUS_SPACE = 5;
    private static final int MIN_NAME_LENGTH = 3;
    private static final int MAX_PARAM_LENGTH = 80;
    private static final String DEFAULT_ROOT_CONSTRUCTOR_PARAMETER = "";
    private static final List<String> BOOL_PREFIXES = Arrays.asList("is", "has");
    protected PrintWriter mWriter;
    protected Grammar mGrammar;
    protected Set<String> mEnumTypes = new HashSet<String>();

    public void setGrammar(Grammar grammar) {
        this.mGrammar = grammar;
    }

    public static String capitalize(String string) {
        return Character.toTitleCase(string.charAt(0)) + string.substring(1);
    }

    public static String uncapitalize(String string) {
        return Character.toLowerCase(string.charAt(0)) + string.substring(1);
    }

    public static String breakWords(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (Character.isUpperCase(c) || Character.isTitleCase(c)) {
                if (n2 > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(Character.toLowerCase(c));
            } else {
                stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String buildFieldComment(String string, String string2, String string3) {
        if (BOOLEAN.equals(string3) && string2.length() >= 3 && string2.startsWith("is") && (Character.isUpperCase(string2.charAt(2)) || Character.isTitleCase(string2.charAt(2)))) {
            return "True iff this " + Emit.breakWords(string) + BLANK + Emit.breakWords(string2) + ".";
        }
        return "The " + Emit.breakWords(string2) + " of this " + Emit.breakWords(string) + ".";
    }

    public static String buildClassComment(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder("Represents a ");
        stringBuilder.append(Emit.breakWords(string));
        if (string2 != null) {
            stringBuilder.append(" which is a special form of a ").append(Emit.breakWords(string2));
        }
        stringBuilder.append('.');
        return stringBuilder.toString();
    }

    private static String getShortComment(String string) {
        int n = string.indexOf(46) + 1;
        if (n == 0) {
            n = string.length();
        }
        return string.substring(0, n);
    }

    protected static void formatComment(PrintWriter printWriter, String string, String string2) {
        printWriter.println(string + "/**");
        String string3 = string2;
        int n = string3.indexOf(10);
        while (n >= 0) {
            printWriter.println(string + STAR + string3.substring(0, n));
            string3 = string3.substring(n + 1);
            n = string3.indexOf(10);
        }
        printWriter.println(string + STAR + string3);
        printWriter.println(string + " */");
    }

    public void emitClasses() throws IOException {
        for (Node node : this.mGrammar.getNodeTable().values()) {
            String string = node.getName();
            System.err.println("Building: " + string);
            this.mWriter = new PrintWriter(new FileWriter(string + ".java"));
            this.emitNode(node);
            this.mWriter.close();
            this.mWriter = null;
        }
    }

    public void emitPreamble(Node node) {
        this.mWriter.println();
        String string = this.mGrammar.getPackageName();
        if (string.length() > 0) {
            this.mWriter.println("package " + string + SEMICOLON);
        }
        for (String string2 : this.mGrammar.getImports()) {
            if (!string2.endsWith(".*")) {
                boolean bl = false;
                Node node2 = node;
                while (!bl && node2 != null) {
                    int n = string2.lastIndexOf(46);
                    String string3 = string2.substring(n + 1);
                    if (node2.getUsedTypes().contains(string3)) {
                        bl = true;
                    }
                    node2 = node2.getParent();
                }
                if (!bl) continue;
            }
            this.mWriter.println("import " + string2 + SEMICOLON);
        }
        this.mWriter.println();
    }

    public void emitToplevelComment(Node node) {
        this.mWriter.println(String.format("/* %s -- Automatically generated by TreeBuilder */", node.getName()));
    }

    public void emitClassDeclaration(Node node) {
        Object object;
        String string2;
        String string3;
        String string4 = node.isAbstract() ? "abstract " : "";
        String string5 = this.getBaseClass(node).map(string -> " extends " + string).orElse("");
        String string6 = string3 = node.getInterfaces() != null ? " implements " + node.getInterfaces() : "";
        if (this.isSealed(node) && node.isAbstract()) {
            string2 = "sealed ";
            object = " permits " + this.mGrammar.getNodeTable().values().stream().filter(node2 -> node.equals(node2.getParent())).map(Node::getName).collect(Collectors.joining(COMMA));
        } else if (this.isSealed(node)) {
            string2 = "final ";
            object = "";
        } else {
            string2 = node.getParent() != null && this.isSealed(node.getParent()) ? "non-sealed " : "";
            object = "";
        }
        this.mWriter.println("public " + string4 + string2 + "class " + node.getName() + string5 + string3 + (String)object + " {");
    }

    protected Optional<String> getBaseClass(Node node) {
        return Optional.ofNullable(node.getParent()).map(Node::getName);
    }

    protected boolean isSealed(Node node) {
        return true;
    }

    public String getConstructorParam(Node node, boolean bl) {
        if (node == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getConstructorParam(node.getParent(), bl));
        String string = "";
        if (stringBuilder.length() > 0) {
            string = COMMA;
        }
        Parameter[] parameterArray = node.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            if (bl || !parameter.isOptional()) {
                String string2 = parameter.getName();
                stringBuilder.append(string).append(string2);
                string = COMMA;
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public String getRootConstructorParam(Node node) {
        return "";
    }

    protected void fillConstructorParamComment(Node node, StringBuilder stringBuilder, StringBuilder stringBuilder2, boolean bl) {
        Node node2 = node.getParent();
        if (node2 != null) {
            this.fillConstructorParamComment(node2, stringBuilder, stringBuilder2, bl);
        }
        String string = "";
        if (stringBuilder.length() > 0) {
            string = COMMA;
        }
        Parameter[] parameterArray = node.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            if (bl || !parameter.isOptional()) {
                String string2 = parameter.getName();
                String string3 = Emit.uncapitalize(Emit.getShortComment(parameter.getComment()));
                stringBuilder2.append("\n@param ").append(string2).append(' ').append(string3);
                stringBuilder.append(string);
                stringBuilder.append(parameter.getType()).append(' ').append(string2);
                string = COMMA;
            }
            ++n2;
        }
    }

    public void emitConstructor(Node node, boolean bl) {
        String string = node.getName();
        String string2 = node.getParent() == null ? this.getRootConstructorParam(node) : this.getConstructorParam(node.getParent(), bl);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder("The constructor taking initial values.");
        this.fillConstructorParamComment(node, stringBuilder, stringBuilder2, bl);
        Emit.formatComment(this.mWriter, "    ", stringBuilder2.toString());
        this.mWriter.println("    public " + string + OPEN_PARENTHESIS + stringBuilder.toString() + ") {");
        if (string2 != null) {
            this.mWriter.println("        super(" + string2 + CLOSE_PARENTHESIS_SEMICOLON);
        }
        Parameter[] parameterArray = node.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            if (bl || !parameter.isOptional()) {
                String string3 = parameter.getName();
                this.mWriter.println("        this." + string3 + " = " + string3 + SEMICOLON);
            }
            ++n2;
        }
        this.emitConstructorAfterParamAssign(node, bl);
        this.mWriter.println("    }");
        this.mWriter.println();
    }

    public void emitConstructorAfterParamAssign(Node node, boolean bl) {
    }

    public void emitConstructors(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Node node2 = node;
        while (node2 != null) {
            Parameter[] parameterArray = node2.parameters;
            int n4 = node2.parameters.length;
            int n5 = 0;
            while (n5 < n4) {
                Parameter parameter = parameterArray[n5];
                ++n3;
                if (!parameter.isWriteable()) {
                    ++n;
                }
                if (!parameter.isOptional()) {
                    ++n2;
                }
                ++n5;
            }
            node2 = node2.getParent();
        }
        if (n2 == 0 || n == 0) {
            Emit.formatComment(this.mWriter, "    ", "The default constructor.");
            this.mWriter.println("    public " + node.getName() + "() {");
            this.mWriter.println("    }");
            this.mWriter.println();
        }
        if (n2 > 0 && n2 < n3) {
            this.emitConstructor(node, false);
        }
        if (n3 > 0) {
            this.emitConstructor(node, true);
        }
    }

    private void emitArrayToStringCode(String string, String string2, String string3, int n) {
        String string4 = "i" + n;
        String string5 = string2.substring(0, string2.length() - 2);
        String string6 = string3 + INDENT_SPACE;
        Object object = string;
        this.mWriter.println(string3 + "if (" + (String)object + " == null) {");
        this.mWriter.println(string3 + "    sb.append(\"null\");");
        this.mWriter.println(string3 + "} else {");
        this.mWriter.println(string3 + "    sb.append('[');");
        this.mWriter.println(string3 + "    for(int " + string4 + " = 0; " + string4 + " < " + (String)object + ".length; " + string4 + "++) {");
        this.mWriter.println(string6 + "if (" + string4 + " > 0) sb.append(',');");
        object = (String)object + "[" + string4 + "]";
        if (string5.endsWith("[]")) {
            this.emitArrayToStringCode((String)object, string5, string6, n + 1);
        } else {
            this.mWriter.println(string6 + "    sb.append(" + (String)object + CLOSE_PARENTHESIS_SEMICOLON);
        }
        this.mWriter.println(string3 + "    }");
        this.mWriter.println(string3 + "    sb.append(']');");
        this.mWriter.println(string3 + "}");
    }

    public void emitNodeHook(Node node) {
    }

    public void emitNode(Node node) {
        boolean bl;
        String string = node.getName();
        Parameter[] parameterArray = node.getParameters();
        this.emitToplevelComment(node);
        this.emitPreamble(node);
        Emit.formatComment(this.mWriter, "", node.getComment());
        this.emitClassDeclaration(node);
        boolean bl2 = bl = parameterArray != null && parameterArray.length > 0;
        if (bl) {
            this.emitParams1(parameterArray);
        }
        this.emitConstructors(node);
        Emit.formatComment(this.mWriter, "    ", "Returns a textual description of this object.");
        this.mWriter.println("    public String toString() {");
        if (bl) {
            this.emitParams2(string, parameterArray);
        } else {
            this.mWriter.println("        return \"" + string + "\";");
        }
        this.mWriter.println("    }");
        if (bl) {
            this.emitParams3(parameterArray);
        }
        this.emitNodeHook(node);
        this.mWriter.println("}");
        this.mWriter.close();
    }

    private void emitParams1(Parameter[] parameterArray) {
        Parameter parameter;
        Parameter[] parameterArray2 = parameterArray;
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            parameter = parameterArray2[n2];
            String string = parameter.getType();
            if (string.startsWith("!")) {
                var7_7 = string.indexOf(44, 1);
                if (var7_7 == -1) {
                    var7_7 = string.length();
                }
                String string2 = string.substring(1, var7_7);
                this.mWriter.println("    public enum " + string2 + " {");
                var9_10 = new StringBuilder();
                ((StringBuilder)var9_10).append(INDENT_SPACE);
                String string3 = "";
                string = string.substring(var7_7);
                while (string.length() > 0) {
                    var7_7 = string.indexOf(44, 1);
                    if (var7_7 == -1) {
                        var7_7 = string.length();
                    }
                    ((StringBuilder)var9_10).append(string3);
                    if (((StringBuilder)var9_10).length() + var7_7 > 80) {
                        this.mWriter.println(((StringBuilder)var9_10).toString());
                        var9_10 = new StringBuilder();
                        ((StringBuilder)var9_10).append(INDENT_SPACE);
                    }
                    ((StringBuilder)var9_10).append(string.substring(1, var7_7));
                    string3 = COMMA;
                    string = string.substring(var7_7);
                }
                this.mWriter.println(((StringBuilder)var9_10).toString());
                this.mWriter.println("    }");
                this.mWriter.println();
                parameter.setType(string2);
                this.mEnumTypes.add(string2);
            } else if (string.startsWith(",")) {
                var7_7 = 0;
                while (string.length() > 0) {
                    int n3 = string.indexOf(44, 1);
                    if (n3 == -1) {
                        n3 = string.length();
                    }
                    var9_10 = string.substring(1, n3);
                    this.mWriter.println("    public final static int " + (String)var9_10 + " = " + var7_7 + SEMICOLON);
                    ++var7_7;
                    string = string.substring(n3);
                }
                this.mWriter.println();
                parameter.setType("int");
            }
            ++n2;
        }
        parameterArray2 = parameterArray;
        n = parameterArray.length;
        n2 = 0;
        while (n2 < n) {
            parameter = parameterArray2[n2];
            Emit.formatComment(this.mWriter, "    ", parameter.getComment());
            this.mWriter.println("    " + parameter.getType() + BLANK + parameter.getName() + SEMICOLON);
            this.mWriter.println();
            ++n2;
        }
    }

    private void emitParams2(String string, Parameter[] parameterArray) {
        this.mWriter.println("        StringBuffer sb = new StringBuffer();");
        this.mWriter.println("        sb.append(\"" + string + "\").append('[');");
        String string2 = "";
        Parameter[] parameterArray2 = parameterArray;
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray2[n2];
            String string3 = parameter.getName();
            String string4 = parameter.getType();
            if (string4.endsWith("[]")) {
                if (!"".equals(string2)) {
                    this.mWriter.println("        sb" + string2 + SEMICOLON);
                }
                this.emitArrayToStringCode(string3, string4, INDENT_SPACE, 1);
            } else {
                this.mWriter.println("        sb" + string2 + ".append(" + string3 + CLOSE_PARENTHESIS_SEMICOLON);
            }
            string2 = ".append(',')";
            ++n2;
        }
        this.mWriter.println("        return sb.append(']').toString();");
    }

    private void emitParams3(Parameter[] parameterArray) {
        Parameter[] parameterArray2 = parameterArray;
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            String string2;
            Parameter parameter = parameterArray2[n2];
            this.mWriter.println();
            String string3 = parameter.getName();
            String string4 = parameter.getType();
            String string5 = parameter.getComment();
            String string6 = Emit.capitalize(string3);
            Object object = "get" + string6;
            String string7 = "set" + string6;
            if (BOOLEAN.equals(string4)) {
                String string82;
                int n3 = 0;
                for (String string82 : BOOL_PREFIXES) {
                    if (!string3.startsWith(string82)) continue;
                    n3 = string82.length();
                    break;
                }
                if (n3 > 0) {
                    object = string3;
                    string7 = "set" + string3.substring(n3);
                }
                if ((string82 = string5).startsWith("True ")) {
                    string82 = string82.substring(5);
                }
                string2 = "Checks " + Emit.uncapitalize(string82) + "\n@return " + Emit.uncapitalize(Emit.getShortComment(string5));
                string = "Sets " + Emit.uncapitalize(string82) + "\n@param " + string3 + BLANK + Emit.uncapitalize(Emit.getShortComment(string5));
            } else {
                string2 = "Gets " + Emit.uncapitalize(string5) + "\n@return " + Emit.uncapitalize(Emit.getShortComment(string5));
                string = "Sets " + Emit.uncapitalize(string5) + "\n@param " + string3 + BLANK + Emit.uncapitalize(Emit.getShortComment(string5));
            }
            Emit.formatComment(this.mWriter, "    ", string2);
            this.mWriter.println("    public " + string4 + BLANK + (String)object + "() {");
            this.mWriter.println("        return " + string3 + SEMICOLON);
            this.mWriter.println("    }");
            if (parameter.isWriteable()) {
                this.mWriter.println();
                Emit.formatComment(this.mWriter, "    ", string);
                this.mWriter.println("    public void " + string7 + OPEN_PARENTHESIS + string4 + BLANK + string3 + ") {");
                if (parameter.isWriteableOnce) {
                    this.mWriter.println("        //Writeable only once");
                    this.mWriter.println("        if(this." + string3 + " != null && " + string3 + " != this." + string3 + "){");
                    this.mWriter.println("                throw new AssertionError(\"Value is only writeable once\");");
                    this.mWriter.println("        }");
                }
                this.mWriter.println("        this." + string3 + " = " + string3 + SEMICOLON);
                this.mWriter.println("    }");
            }
            ++n2;
        }
    }
}

