/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomatonOnDemandStateAndLetter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.TransitionType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.DuplicatorNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.DuplicatorWinningSink;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerWinningSink;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.GameSpoilerNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.IGameLetter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.IGameState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.ISimulationInfoProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.HashSet;
import java.util.Set;

public class GameAutomaton<LETTER, STATE>
extends NestedWordAutomatonOnDemandStateAndLetter<IGameLetter<LETTER, STATE>, IGameState> {
    private final boolean mInitiallyOmitSymmetricPairs = true;
    private final boolean mAlwaysOmitSymmetricPairsWithFalseBit = false;
    private final ISetOfPairs<STATE, ?> mInitialPairs;
    private final IDoubleDeckerAutomaton<LETTER, STATE> mOperand;
    private final ISimulationInfoProvider<LETTER, STATE> mSimulationInfoProvider;
    private final GameStateFactory mGameStateFactory;
    private final GameLetterFactory mGameLetterFactory;

    public GameAutomaton(AutomataLibraryServices automataLibraryServices, IEmptyStackStateFactory<IGameState> iEmptyStackStateFactory, ISetOfPairs<STATE, ?> iSetOfPairs, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, ISimulationInfoProvider<LETTER, STATE> iSimulationInfoProvider, SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iEmptyStackStateFactory);
        this.mInitialPairs = iSetOfPairs;
        this.mOperand = iDoubleDeckerAutomaton;
        this.mSimulationInfoProvider = iSimulationInfoProvider;
        this.mGameLetterFactory = new GameLetterFactory();
        this.mGameStateFactory = new GameStateFactory(spoilerNwaVertex);
        this.constructInitialStates();
    }

    @Override
    protected void constructInitialStates() throws AutomataOperationCanceledException {
        for (Pair pair : this.mInitialPairs) {
            Object object;
            Object object2;
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                object2 = new RunningTaskInfo(this.getClass(), "constructing initial vertices for automaton with " + this.mOperand.size() + " states");
                throw new AutomataOperationCanceledException((RunningTaskInfo)object2);
            }
            object2 = pair.getFirst();
            if (object2.equals(object = pair.getSecond())) continue;
            this.constructInitialVertex(object2, object);
        }
        this.mInitialStateHaveBeenConstructed = true;
    }

    @Override
    public boolean hasModifiableAlphabet() {
        return true;
    }

    private IGameState constructInitialVertex(STATE STATE, STATE STATE2) {
        boolean bl = this.mOperand.isFinal(STATE);
        boolean bl2 = this.mOperand.isFinal(STATE2);
        boolean bl3 = this.mSimulationInfoProvider.isImmediatelyWinningForSpoiler(bl, bl2);
        boolean bl4 = this.mSimulationInfoProvider.computeBitForInitialVertex(bl, bl2);
        int n = this.mSimulationInfoProvider.computePriority(bl4, bl, bl2);
        IGameState iGameState = this.mGameStateFactory.getOrConstructGameState(STATE, STATE2, bl4, n, bl3, false);
        return iGameState;
    }

    @Override
    protected void constructInternalSuccessors(IGameState iGameState) {
        if (!GameAutomaton.isSpoilerSink(iGameState) && !GameAutomaton.isDuplicatorSink(iGameState)) {
            SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex = GameAutomaton.unwrapSpoilerNwaVertex(iGameState);
            HashRelation<IGameLetter<LETTER, STATE>, IGameState> hashRelation = this.constructSuccessors(spoilerNwaVertex, new InternalLetterAndSuccessorProvider(), TransitionType.INTERNAL, false);
            this.addInternalTransitionsToAutomaton(iGameState, hashRelation);
        }
    }

    @Override
    protected void constructCallSuccessors(IGameState iGameState) {
        if (!GameAutomaton.isSpoilerSink(iGameState) && !GameAutomaton.isDuplicatorSink(iGameState)) {
            SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex = GameAutomaton.unwrapSpoilerNwaVertex(iGameState);
            HashRelation<IGameLetter<LETTER, STATE>, IGameState> hashRelation = this.constructSuccessors(spoilerNwaVertex, new CallLetterAndSuccessorProvider(), TransitionType.CALL, false);
            this.addCallTransitionsToAutomaton(iGameState, hashRelation);
        }
    }

    @Override
    protected void constructReturnSuccessors(IGameState iGameState, IGameState iGameState2) {
        if (!GameAutomaton.isSpoilerSink(iGameState) && !GameAutomaton.isDuplicatorSink(iGameState)) {
            SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex = GameAutomaton.unwrapSpoilerNwaVertex(iGameState);
            HashRelation<IGameLetter<LETTER, STATE>, IGameState> hashRelation = this.constructSuccessors(spoilerNwaVertex, new ReturnLetterAndSuccessorProvider(GameAutomaton.unwrapSpoilerNwaVertex(iGameState2)), TransitionType.RETURN, true);
            this.addReturnTransitionsToAutomaton(iGameState, iGameState2, hashRelation);
        }
    }

    public static <LETTER, STATE> SpoilerNwaVertex<LETTER, STATE> unwrapSpoilerNwaVertex(IGameState iGameState) {
        GameSpoilerNwaVertex gameSpoilerNwaVertex = (GameSpoilerNwaVertex)iGameState;
        SpoilerNwaVertex spoilerNwaVertex = gameSpoilerNwaVertex.getSpoilerNwaVertex();
        return spoilerNwaVertex;
    }

    private HashRelation<IGameLetter<LETTER, STATE>, IGameState> constructSuccessors(SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex, LetterAndSuccessorProvider<LETTER, STATE, ? extends IOutgoingTransitionlet<LETTER, STATE>> letterAndSuccessorProvider, TransitionType transitionType, boolean bl) {
        Object STATE = spoilerNwaVertex.getQ0();
        Object STATE2 = spoilerNwaVertex.getQ1();
        HashRelation hashRelation = new HashRelation();
        for (LETTER LETTER : letterAndSuccessorProvider.getLettersForSpoiler(STATE)) {
            Iterable<? extends IOutgoingTransitionlet<LETTER, STATE>> iterable = letterAndSuccessorProvider.getOutgoingTransitionsForSpoiler(STATE, LETTER);
            Set set = NestedWordAutomataUtils.constructSuccessorSet(iterable);
            Iterable<? extends IOutgoingTransitionlet<LETTER, STATE>> iterable2 = letterAndSuccessorProvider.getOutgoingTransitionsForDuplicator(STATE2, LETTER);
            Set set2 = NestedWordAutomataUtils.constructSuccessorSet(iterable2);
            HashRelation<IGameLetter<LETTER, STATE>, IGameState> hashRelation2 = this.computeSuccessorTransitions(spoilerNwaVertex, LETTER, transitionType, set, set2, bl);
            hashRelation.addAll(hashRelation2);
        }
        return hashRelation;
    }

    private void addInternalTransitionsToAutomaton(IGameState iGameState, HashRelation<IGameLetter<LETTER, STATE>, IGameState> hashRelation) {
        for (IGameLetter iGameLetter : hashRelation.getDomain()) {
            this.mCache.addInternalTransitions(iGameState, iGameLetter, hashRelation.getImage((Object)iGameLetter));
        }
    }

    private void addCallTransitionsToAutomaton(IGameState iGameState, HashRelation<IGameLetter<LETTER, STATE>, IGameState> hashRelation) {
        for (IGameLetter iGameLetter : hashRelation.getDomain()) {
            this.mCache.addCallTransitions(iGameState, iGameLetter, hashRelation.getImage((Object)iGameLetter));
        }
    }

    private void addReturnTransitionsToAutomaton(IGameState iGameState, IGameState iGameState2, HashRelation<IGameLetter<LETTER, STATE>, IGameState> hashRelation) {
        for (IGameLetter iGameLetter : hashRelation.getDomain()) {
            this.mCache.addReturnTransitions(iGameState, iGameState2, iGameLetter, hashRelation.getImage((Object)iGameLetter));
        }
    }

    private HashRelation<IGameLetter<LETTER, STATE>, IGameState> computeSuccessorTransitions(SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex, LETTER LETTER, TransitionType transitionType, Set<STATE> set, Set<STATE> set2, boolean bl) {
        HashRelation hashRelation = new HashRelation();
        for (STATE STATE : set) {
            Object object;
            if (set2.contains(STATE)) {
                // empty if block
            }
            IGameLetter<LETTER, STATE> iGameLetter = this.getOrConstructSuccessorGameLetter(spoilerNwaVertex, LETTER, transitionType, STATE);
            if (set2.isEmpty()) {
                object = this.getOrConstructSuccessorSpoilerWinningSinkVertex(spoilerNwaVertex, LETTER, STATE, bl);
                assert (object != null);
                hashRelation.addPair(iGameLetter, object);
                continue;
            }
            object = (DuplicatorNwaVertex)iGameLetter;
            for (STATE STATE2 : set2) {
                IGameState iGameState = this.getOrConstructSuccessorVertex(((Vertex)object).isB(), LETTER, STATE, STATE2, bl);
                assert (iGameState != null);
                hashRelation.addPair(iGameLetter, (Object)iGameState);
            }
        }
        return hashRelation;
    }

    private IGameState getOrConstructSuccessorSpoilerWinningSinkVertex(SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex, LETTER LETTER, STATE STATE, boolean bl) {
        boolean bl2 = this.mOperand.isFinal(spoilerNwaVertex.getQ1());
        boolean bl3 = this.mSimulationInfoProvider.computeBitForDuplicatorVertex(spoilerNwaVertex.isB(), bl2);
        IGameState iGameState = this.mGameStateFactory.getOrConstructGameState(STATE, null, bl3, 2, true, bl);
        return iGameState;
    }

    private IGameState getOrConstructSuccessorVertex(boolean bl, LETTER LETTER, STATE STATE, STATE STATE2, boolean bl2) {
        boolean bl3 = this.mOperand.isFinal(STATE);
        boolean bl4 = this.mOperand.isFinal(STATE2);
        boolean bl5 = this.mSimulationInfoProvider.isImmediatelyWinningForSpoiler(bl3, bl4);
        boolean bl6 = this.mSimulationInfoProvider.computeBitForSpoilerVertex(bl, bl4);
        int n = this.mSimulationInfoProvider.computePriority(bl6, bl3, bl4);
        IGameState iGameState = this.mGameStateFactory.getOrConstructGameState(STATE, STATE2, bl6, n, bl5, bl2);
        return iGameState;
    }

    private IGameLetter<LETTER, STATE> getOrConstructSuccessorGameLetter(SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex, LETTER LETTER, TransitionType transitionType, STATE STATE) {
        boolean bl = this.mOperand.isFinal(STATE);
        boolean bl2 = this.mSimulationInfoProvider.computeBitForDuplicatorVertex(spoilerNwaVertex.isB(), bl);
        IGameLetter iGameLetter = this.mGameLetterFactory.getOrConstructGameLetter(STATE, spoilerNwaVertex.getQ1(), LETTER, bl2, transitionType);
        return iGameLetter;
    }

    public static boolean isDuplicatorSink(IGameState iGameState) {
        return GameAutomaton.unwrapSpoilerNwaVertex(iGameState).getSink() instanceof DuplicatorWinningSink;
    }

    public static boolean isSpoilerSink(IGameState iGameState) {
        return GameAutomaton.unwrapSpoilerNwaVertex(iGameState).getSink() instanceof SpoilerWinningSink;
    }

    private class CallLetterAndSuccessorProvider
    implements LetterAndSuccessorProvider<LETTER, STATE, OutgoingCallTransition<LETTER, STATE>> {
        private CallLetterAndSuccessorProvider() {
        }

        @Override
        public Set<LETTER> getLettersForSpoiler(STATE STATE) {
            return GameAutomaton.this.mOperand.lettersCall(STATE);
        }

        @Override
        public Iterable<OutgoingCallTransition<LETTER, STATE>> getOutgoingTransitionsForSpoiler(STATE STATE, LETTER LETTER) {
            return GameAutomaton.this.mOperand.callSuccessors(STATE, LETTER);
        }

        @Override
        public Iterable<OutgoingCallTransition<LETTER, STATE>> getOutgoingTransitionsForDuplicator(STATE STATE, LETTER LETTER) {
            return GameAutomaton.this.mOperand.callSuccessors(STATE, LETTER);
        }
    }

    private class GameLetterFactory {
        private final NestedMap3<STATE, STATE, LETTER, IGameLetter<LETTER, STATE>> mSpoi2Dupl2letter2GameLetter_ForFalse_ForInternal = new NestedMap3();
        private final NestedMap3<STATE, STATE, LETTER, IGameLetter<LETTER, STATE>> mSpoi2Dupl2letter2GameLetter_ForTrue_ForInternal = new NestedMap3();
        private final NestedMap3<STATE, STATE, LETTER, IGameLetter<LETTER, STATE>> mSpoi2Dupl2letter2GameLetter_ForFalse_ForCall = new NestedMap3();
        private final NestedMap3<STATE, STATE, LETTER, IGameLetter<LETTER, STATE>> mSpoi2Dupl2letter2GameLetter_ForTrue_ForCall = new NestedMap3();
        private final NestedMap3<STATE, STATE, LETTER, IGameLetter<LETTER, STATE>> mSpoi2Dupl2letter2GameLetter_ForFalse_ForReturn = new NestedMap3();
        private final NestedMap3<STATE, STATE, LETTER, IGameLetter<LETTER, STATE>> mSpoi2Dupl2letter2GameLetter_ForTrue_ForReturn = new NestedMap3();

        private GameLetterFactory() {
        }

        private IGameLetter<LETTER, STATE> getGameLetter(STATE STATE, STATE STATE2, LETTER LETTER, boolean bl, TransitionType transitionType) {
            switch (transitionType) {
                case CALL: {
                    if (bl) {
                        return (IGameLetter)this.mSpoi2Dupl2letter2GameLetter_ForTrue_ForCall.get(STATE, STATE2, LETTER);
                    }
                    return (IGameLetter)this.mSpoi2Dupl2letter2GameLetter_ForFalse_ForCall.get(STATE, STATE2, LETTER);
                }
                case INTERNAL: {
                    if (bl) {
                        return (IGameLetter)this.mSpoi2Dupl2letter2GameLetter_ForTrue_ForInternal.get(STATE, STATE2, LETTER);
                    }
                    return (IGameLetter)this.mSpoi2Dupl2letter2GameLetter_ForFalse_ForInternal.get(STATE, STATE2, LETTER);
                }
                case RETURN: {
                    if (bl) {
                        return (IGameLetter)this.mSpoi2Dupl2letter2GameLetter_ForTrue_ForReturn.get(STATE, STATE2, LETTER);
                    }
                    return (IGameLetter)this.mSpoi2Dupl2letter2GameLetter_ForFalse_ForReturn.get(STATE, STATE2, LETTER);
                }
            }
            throw new AssertionError((Object)"illegal transition type");
        }

        public IGameLetter<LETTER, STATE> getOrConstructGameLetter(STATE STATE, STATE STATE2, LETTER LETTER, boolean bl, TransitionType transitionType) {
            assert (STATE != null);
            assert (STATE2 != null);
            assert (LETTER != null);
            IGameLetter iGameLetter = this.getGameLetter(STATE, STATE2, LETTER, bl, transitionType);
            if (iGameLetter == null) {
                iGameLetter = this.constructGameLetter(STATE, STATE2, LETTER, bl, transitionType);
            }
            return iGameLetter;
        }

        private IGameLetter<LETTER, STATE> constructGameLetter(STATE STATE, STATE STATE2, LETTER LETTER, boolean bl, TransitionType transitionType) {
            DuplicatorNwaVertex duplicatorNwaVertex = new DuplicatorNwaVertex(2, bl, STATE, STATE2, LETTER, transitionType);
            switch (transitionType) {
                case CALL: {
                    if (bl) {
                        this.mSpoi2Dupl2letter2GameLetter_ForTrue_ForCall.put(STATE, STATE2, LETTER, duplicatorNwaVertex);
                    } else {
                        this.mSpoi2Dupl2letter2GameLetter_ForFalse_ForCall.put(STATE, STATE2, LETTER, duplicatorNwaVertex);
                    }
                    GameAutomaton.this.mCallAlphabet.add(duplicatorNwaVertex);
                    break;
                }
                case INTERNAL: {
                    if (bl) {
                        this.mSpoi2Dupl2letter2GameLetter_ForTrue_ForInternal.put(STATE, STATE2, LETTER, duplicatorNwaVertex);
                    } else {
                        this.mSpoi2Dupl2letter2GameLetter_ForFalse_ForInternal.put(STATE, STATE2, LETTER, duplicatorNwaVertex);
                    }
                    GameAutomaton.this.mInternalAlphabet.add(duplicatorNwaVertex);
                    break;
                }
                case RETURN: {
                    if (bl) {
                        this.mSpoi2Dupl2letter2GameLetter_ForTrue_ForReturn.put(STATE, STATE2, LETTER, duplicatorNwaVertex);
                    } else {
                        this.mSpoi2Dupl2letter2GameLetter_ForFalse_ForReturn.put(STATE, STATE2, LETTER, duplicatorNwaVertex);
                    }
                    GameAutomaton.this.mReturnAlphabet.add(duplicatorNwaVertex);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"illegal transition type");
                }
            }
            return duplicatorNwaVertex;
        }
    }

    private class GameStateFactory {
        private final NestedMap2<STATE, STATE, IGameState> mSpoiler2duplicator2vertexForFalse = new NestedMap2();
        private final NestedMap2<STATE, STATE, IGameState> mSpoiler2duplicator2vertexForTrue = new NestedMap2();
        private final SpoilerWinningSink<LETTER, STATE> mSpoilerWinningSinkMarker;
        private final GameSpoilerNwaVertex<LETTER, STATE> mUniqueSpoilerWinningSink;

        public GameStateFactory(SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex) {
            this.mUniqueSpoilerWinningSink = new GameSpoilerNwaVertex(spoilerNwaVertex);
            this.mSpoilerWinningSinkMarker = (SpoilerWinningSink)spoilerNwaVertex.getSink();
        }

        private IGameState getGameState(STATE STATE, STATE STATE2, boolean bl) {
            if (bl) {
                return (IGameState)this.mSpoiler2duplicator2vertexForTrue.get(STATE, STATE2);
            }
            return (IGameState)this.mSpoiler2duplicator2vertexForFalse.get(STATE, STATE2);
        }

        public IGameState getOrConstructGameState(STATE STATE, STATE STATE2, boolean bl, int n, boolean bl2, boolean bl3) {
            assert (STATE != null);
            assert (STATE2 != null || bl2);
            IGameState iGameState = this.getGameState(STATE, STATE2, bl);
            if (iGameState == null) {
                iGameState = this.constructGameState(STATE, STATE2, bl, n, bl2);
            } else assert (n == GameAutomaton.unwrapSpoilerNwaVertex(iGameState).getPriority()) : "inconsistent priority";
            return iGameState;
        }

        private IGameState constructGameState(STATE STATE, STATE STATE2, boolean bl, int n, boolean bl2) {
            SpoilerNwaVertex spoilerNwaVertex = bl2 ? new SpoilerNwaVertex(n, bl, STATE, STATE2, this.mSpoilerWinningSinkMarker) : new SpoilerNwaVertex(n, bl, STATE, STATE2);
            GameSpoilerNwaVertex gameSpoilerNwaVertex = new GameSpoilerNwaVertex(spoilerNwaVertex);
            if (bl) {
                this.mSpoiler2duplicator2vertexForTrue.put(STATE, STATE2, gameSpoilerNwaVertex);
            } else {
                this.mSpoiler2duplicator2vertexForFalse.put(STATE, STATE2, gameSpoilerNwaVertex);
            }
            GameAutomaton.this.mCache.addState(true, true, gameSpoilerNwaVertex);
            return gameSpoilerNwaVertex;
        }
    }

    private class InternalLetterAndSuccessorProvider
    implements LetterAndSuccessorProvider<LETTER, STATE, OutgoingInternalTransition<LETTER, STATE>> {
        private InternalLetterAndSuccessorProvider() {
        }

        @Override
        public Set<LETTER> getLettersForSpoiler(STATE STATE) {
            return GameAutomaton.this.mOperand.lettersInternal(STATE);
        }

        @Override
        public Iterable<OutgoingInternalTransition<LETTER, STATE>> getOutgoingTransitionsForSpoiler(STATE STATE, LETTER LETTER) {
            return GameAutomaton.this.mOperand.internalSuccessors(STATE, LETTER);
        }

        @Override
        public Iterable<OutgoingInternalTransition<LETTER, STATE>> getOutgoingTransitionsForDuplicator(STATE STATE, LETTER LETTER) {
            return GameAutomaton.this.mOperand.internalSuccessors(STATE, LETTER);
        }
    }

    private static interface LetterAndSuccessorProvider<LETTER, STATE, T extends IOutgoingTransitionlet<LETTER, STATE>> {
        public Set<LETTER> getLettersForSpoiler(STATE var1);

        public Iterable<T> getOutgoingTransitionsForSpoiler(STATE var1, LETTER var2);

        public Iterable<T> getOutgoingTransitionsForDuplicator(STATE var1, LETTER var2);
    }

    private class ReturnLetterAndSuccessorProvider
    implements LetterAndSuccessorProvider<LETTER, STATE, OutgoingReturnTransition<LETTER, STATE>> {
        private final SpoilerNwaVertex<LETTER, STATE> mHier;

        public ReturnLetterAndSuccessorProvider(SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex) {
            this.mHier = spoilerNwaVertex;
        }

        @Override
        public Set<LETTER> getLettersForSpoiler(STATE STATE) {
            HashSet hashSet = new HashSet();
            for (OutgoingReturnTransition outgoingReturnTransition : GameAutomaton.this.mOperand.returnSuccessors(STATE)) {
                if (!outgoingReturnTransition.getHierPred().equals(this.mHier.getQ0())) continue;
                hashSet.add(outgoingReturnTransition.getLetter());
            }
            return hashSet;
        }

        @Override
        public Iterable<OutgoingReturnTransition<LETTER, STATE>> getOutgoingTransitionsForSpoiler(STATE STATE, LETTER LETTER) {
            return GameAutomaton.this.mOperand.returnSuccessors(STATE, this.mHier.getQ0(), LETTER);
        }

        @Override
        public Iterable<OutgoingReturnTransition<LETTER, STATE>> getOutgoingTransitionsForDuplicator(STATE STATE, LETTER LETTER) {
            return GameAutomaton.this.mOperand.returnSuccessors(STATE, this.mHier.getQ1(), LETTER);
        }
    }
}

