/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.icfgtransformation;

import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.BvToIntTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformerSequence;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.InvariantBasedSimplification;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.LocalTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.MapEliminationTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.heapseparator.HeapSepIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.CopyingTransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.IdentityTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.biesenbach.IcfgLoopAcceleration;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.JordanLoopAccelerationIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.mohr.IcfgLoopTransformerMohr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.QvasrsIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.WernerLoopAccelerationIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing.LoopAccelerationIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.mapelim.monniaux.MonniauxMapEliminator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.DNF;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.ModuloNeighborTransformation;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteDivision;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteIte;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.SimplifyPreprocessor;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ConjunctiveAbstractInterpretationUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.DefaultEqualityAnalysisProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityAnalysisResultProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminationSettings;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.IntToBvBackTranslation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationConstrainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtransformation.AbsIntEqualityProvider;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtransformation.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtransformation.preferences.IcfgTransformationPreferences;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class IcfgTransformationObserver
implements IUnmanagedObserver {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final IcfgTransformationBacktranslator mBacktranslator;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private IIcfg<?> mResult;

    public IcfgTransformationObserver(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, IcfgTransformationBacktranslator icfgTransformationBacktranslator, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mBacktranslator = icfgTransformationBacktranslator;
        this.mSimplificationTechnique = simplificationTechnique;
        this.mResult = null;
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public void finish() throws Throwable {
    }

    public boolean performedChanges() {
        return false;
    }

    public IElement getModel() {
        return this.mResult;
    }

    public boolean process(IElement iElement) throws Exception {
        if (iElement instanceof IIcfg) {
            this.processIcfg((IIcfg)iElement);
            return false;
        }
        return true;
    }

    private <INLOC extends IcfgLocation> void processIcfg(IIcfg<INLOC> iIcfg) {
        IcfgTransformationBacktranslator icfgTransformationBacktranslator = this.mBacktranslator;
        this.mResult = iIcfg.getLocationClass().equals(BoogieIcfgLocation.class) ? this.createTransformer(iIcfg, IcfgTransformationObserver.createBoogieLocationFactory(), BoogieIcfgLocation.class, icfgTransformationBacktranslator) : this.createTransformer(iIcfg, IcfgTransformationObserver.createIcfgLocationFactory(), IcfgLocation.class, icfgTransformationBacktranslator);
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> createTransformer(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator) {
        ReplacementVarFactory replacementVarFactory = new ReplacementVarFactory(iIcfg.getCfgSmtToolkit(), false);
        IPreferenceProvider iPreferenceProvider = IcfgTransformationPreferences.getPreferenceProvider(this.mServices);
        IcfgTransformationPreferences.TransformationTestType transformationTestType = (IcfgTransformationPreferences.TransformationTestType)iPreferenceProvider.getEnum("TransformationType", IcfgTransformationPreferences.TransformationTestType.class);
        this.mLogger.info("Applying ICFG transformation %s", new Object[]{transformationTestType});
        switch (transformationTestType) {
            case HEAP_SEPARATOR: {
                return this.applyHeapSeparator(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory, this.mServices, new AbsIntEqualityProvider(this.mServices));
            }
            case LOOP_ACCELERATION_EXAMPLE: {
                return this.applyLoopAccelerationEx(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator);
            }
            case LOOP_ACCELERATION_BIESENBACH: {
                return this.applyLoopAccelerationBiesenbach(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory);
            }
            case LOOP_ACCELERATION_JORDAN: {
                return this.applyLoopAccelerationJordan(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory);
            }
            case LOOP_ACCELERATION_QVASR: {
                return this.applyLoopAccelerationQvasr(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory);
            }
            case LOOP_ACCELERATION_QVASRS: {
                return this.applyLoopAccelerationQvasrs(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory);
            }
            case LOOP_ACCELERATION_MOHR: {
                return this.applyLoopAccelerationMohr(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory);
            }
            case LOOP_ACCELERATION_WOELFING: {
                return this.applyLoopAccelerationWoelfing(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory);
            }
            case LOOP_ACCELERATION_FASTUPR: {
                return this.applyLoopAccelerationFastUPR(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory);
            }
            case LOOP_ACCELERATION_WERNER: {
                return this.applyLoopAccelerationWerner(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory);
            }
            case MAP_ELIMINATION_NO_EQUALITY: {
                return this.applyMapElimination(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory, (IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>>)new DefaultEqualityAnalysisProvider());
            }
            case MAP_ELIMINATION_EQUALITY: {
                return this.applyMapElimination(iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory, new AbsIntEqualityProvider(this.mServices));
            }
            case REMOVE_DIV_MOD: {
                return IcfgTransformationObserver.applyRemoveDivMod(this.mLogger, iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory);
            }
            case MODULO_NEIGHBOR: {
                return IcfgTransformationObserver.applyModuloNeighbor(this.mLogger, iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory, this.mServices);
            }
            case BV_TO_INT_SUM: {
                return IcfgTransformationObserver.applyBvToIntTranslation(this.mLogger, iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, this.mServices, TranslationConstrainer.ConstraintsForBitwiseOperations.SUM);
            }
            case BV_TO_INT_BITWISE: {
                return IcfgTransformationObserver.applyBvToIntTranslation(this.mLogger, iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, this.mServices, TranslationConstrainer.ConstraintsForBitwiseOperations.BITWISE);
            }
            case BV_TO_INT_LAZY: {
                return IcfgTransformationObserver.applyBvToIntTranslation(this.mLogger, iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, this.mServices, TranslationConstrainer.ConstraintsForBitwiseOperations.LAZY);
            }
            case BV_TO_INT_NONE: {
                return IcfgTransformationObserver.applyBvToIntTranslation(this.mLogger, iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, this.mServices, TranslationConstrainer.ConstraintsForBitwiseOperations.NONE);
            }
            case MAP_ELIMINATION_MONNIAUX: {
                return this.applyMapEliminationMonniaux(iIcfg, icfgTransformationBacktranslator);
            }
            case ABSTRACT_INTERPRETATION_BASED_SIMPLIFICATION: {
                return IcfgTransformationObserver.applyAbstractInterpretationBasedSimplification(this.mLogger, iIcfg, iLocationFactory, clazz, icfgTransformationBacktranslator, replacementVarFactory, this.mServices);
            }
        }
        throw new UnsupportedOperationException("Unknown transformation type: " + String.valueOf((Object)transformationTestType));
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyHeapSeparator(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory, IUltimateServiceProvider iUltimateServiceProvider, IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> iEqualityAnalysisResultProvider) {
        IProgramNonOldVar iProgramNonOldVar3;
        IProgramNonOldVar iProgramNonOldVar2 = null;
        for (IProgramNonOldVar iProgramNonOldVar3 : iIcfg.getCfgSmtToolkit().getSymbolTable().getGlobals()) {
            if (!iProgramNonOldVar3.getGloballyUniqueId().equals("#valid")) continue;
            iProgramNonOldVar2 = iProgramNonOldVar3;
            break;
        }
        if (iProgramNonOldVar2 == null) {
            this.mLogger.warn((Object)"HeapSeparator: input icfg has no '#valid' array -- returning unchanged Icfg!");
            return new IcfgTransformer(this.mLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, iIcfg.getIdentifier() + "left_unchanged_by_heapseparator", (ITransformulaTransformer)new IdentityTransformer(iIcfg.getCfgSmtToolkit())).getResult();
        }
        iProgramNonOldVar3 = new HeapSepIcfgTransformer(this.mLogger, this.mServices, iIcfg, iLocationFactory, replacementVarFactory, icfgTransformationBacktranslator, clazz, "heap_separated_icfg", iEqualityAnalysisResultProvider, iProgramNonOldVar2);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult(Activator.PLUGIN_ID, "Abstract Interpretation statistics", ((AbsIntEqualityProvider)iEqualityAnalysisResultProvider).getAbsIntBenchmark()));
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult(Activator.PLUGIN_ID, "HeapSeparatorStatistics", (ICsvProviderProvider)iProgramNonOldVar3.getStatistics()));
        return iProgramNonOldVar3.getResult();
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyLoopAccelerationMohr(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory) {
        return new IcfgLoopTransformerMohr(this.mLogger, this.mServices, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, "IcfgWithLoopAccelerationMohr").getResult();
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyLoopAccelerationWoelfing(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory) {
        return new LoopAccelerationIcfgTransformer(this.mLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, "IcfgWithLoopAccelerationWoelfing", this.mServices).getResult();
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyLoopAccelerationBiesenbach(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory) {
        IcfgLoopAcceleration.LoopAccelerationOptions loopAccelerationOptions = (IcfgLoopAcceleration.LoopAccelerationOptions)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("Loopacceleration Biesenbach Mode", IcfgLoopAcceleration.LoopAccelerationOptions.class);
        return new IcfgLoopAcceleration(this.mLogger, iIcfg, clazz, iLocationFactory, iIcfg.getIdentifier() + "IcfgDuplicate", icfgTransformationBacktranslator, this.mServices, loopAccelerationOptions).getResult();
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyLoopAccelerationJordan(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory) {
        return new JordanLoopAccelerationIcfgTransformer(this.mLogger, iIcfg, clazz, iLocationFactory, iIcfg.getIdentifier() + "Jordan", icfgTransformationBacktranslator, this.mServices).getResult();
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyLoopAccelerationQvasr(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory) {
        return new QvasrIcfgTransformer(this.mLogger, iIcfg, clazz, iLocationFactory, iIcfg.getIdentifier() + "qvasr", icfgTransformationBacktranslator, this.mServices).getResult();
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyLoopAccelerationQvasrs(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory) {
        CopyingTransformulaTransformer copyingTransformulaTransformer = new CopyingTransformulaTransformer(this.mLogger, iIcfg.getCfgSmtToolkit().getManagedScript(), iIcfg.getCfgSmtToolkit());
        return new QvasrsIcfgTransformer(this.mLogger, iIcfg, clazz, iLocationFactory, iIcfg.getIdentifier() + "qvasrs transformation", (ITransformulaTransformer)copyingTransformulaTransformer, icfgTransformationBacktranslator, this.mServices).getResult();
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyLoopAccelerationFastUPR(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory) {
        FastUPRTransformer.FastUPRReplacementMethod fastUPRReplacementMethod = (FastUPRTransformer.FastUPRReplacementMethod)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("FastUPR replacement mode", FastUPRTransformer.FastUPRReplacementMethod.class);
        return new FastUPRTransformer(this.mLogger, iIcfg, clazz, iLocationFactory, iIcfg.getIdentifier() + "FastUPR", icfgTransformationBacktranslator, this.mServices, fastUPRReplacementMethod).getResult();
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyLoopAccelerationWerner(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory) {
        WernerLoopAccelerationIcfgTransformer.DealingWithArraysTypes dealingWithArraysTypes = (WernerLoopAccelerationIcfgTransformer.DealingWithArraysTypes)this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getEnum("Loopacceleration Werner Mode", WernerLoopAccelerationIcfgTransformer.DealingWithArraysTypes.class);
        return new WernerLoopAccelerationIcfgTransformer(this.mLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, iIcfg.getIdentifier() + "IcfgDuplicate", this.mServices, dealingWithArraysTypes, 10).getResult();
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyLoopAccelerationEx(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator) {
        CopyingTransformulaTransformer copyingTransformulaTransformer = new CopyingTransformulaTransformer(this.mLogger, iIcfg.getCfgSmtToolkit().getManagedScript(), iIcfg.getCfgSmtToolkit());
        return new IcfgTransformer(this.mLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, iIcfg.getIdentifier() + "IcfgDuplicate", (ITransformulaTransformer)copyingTransformulaTransformer).getResult();
    }

    private static <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyRemoveDivMod(ILogger iLogger, IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory) {
        LocalTransformer localTransformer = new LocalTransformer((TransitionPreprocessor)new RewriteDivision(replacementVarFactory), iIcfg.getCfgSmtToolkit().getManagedScript(), replacementVarFactory);
        IcfgTransformer icfgTransformer = new IcfgTransformer(iLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, iIcfg.getIdentifier() + "TransformedIcfg", (ITransformulaTransformer)localTransformer);
        return icfgTransformer.getResult();
    }

    private static <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyModuloNeighbor(ILogger iLogger, IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory, IUltimateServiceProvider iUltimateServiceProvider) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new RewriteIte());
        arrayList.add(new SimplifyPreprocessor(iUltimateServiceProvider, SmtUtils.SimplificationTechnique.SIMPLIFY_QUICK));
        arrayList.add(new ModuloNeighborTransformation(iUltimateServiceProvider, true));
        arrayList.add(new DNF(iUltimateServiceProvider));
        LocalTransformer localTransformer = new LocalTransformer(arrayList, iIcfg.getCfgSmtToolkit().getManagedScript(), replacementVarFactory);
        IcfgTransformer icfgTransformer = new IcfgTransformer(iLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, iIcfg.getIdentifier() + "TransformedIcfg", (ITransformulaTransformer)localTransformer);
        return icfgTransformer.getResult();
    }

    private static <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyAbstractInterpretationBasedSimplification(ILogger iLogger, IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory, IUltimateServiceProvider iUltimateServiceProvider) {
        Map map = ConjunctiveAbstractInterpretationUtils.computeInvariants((IUltimateServiceProvider)iUltimateServiceProvider, iIcfg, (ConjunctiveAbstractInterpretationUtils.Widening)ConjunctiveAbstractInterpretationUtils.Widening.INTERSECTION);
        InvariantBasedSimplification invariantBasedSimplification = new InvariantBasedSimplification(iUltimateServiceProvider, iLogger, iIcfg.getCfgSmtToolkit(), map);
        IcfgTransformer icfgTransformer = new IcfgTransformer(iLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, iIcfg.getIdentifier() + "TransformedIcfg", (ITransformulaTransformer)invariantBasedSimplification);
        iLogger.info((Object)String.format("Processed %s edges. Simplified %s edges. %s edges simplified from non-false term to false. Overall treesize reduction %s.", invariantBasedSimplification.getEdges(), invariantBasedSimplification.getSimplifiedEdges(), invariantBasedSimplification.getSimplifiedToFalse(), invariantBasedSimplification.getOverallTreesizeReduction()));
        return icfgTransformer.getResult();
    }

    private static <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyBvToIntTranslation(ILogger iLogger, IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, IUltimateServiceProvider iUltimateServiceProvider, TranslationConstrainer.ConstraintsForBitwiseOperations constraintsForBitwiseOperations) {
        IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID);
        BvToIntTransformulaTransformer bvToIntTransformulaTransformer = new BvToIntTransformulaTransformer(iIcfg.getCfgSmtToolkit().getManagedScript(), constraintsForBitwiseOperations, iPreferenceProvider.getBoolean("Use Nutz Transformation in bitvector translation"));
        IcfgTransformer icfgTransformer = new IcfgTransformer(iLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, iIcfg.getIdentifier() + "TransformedIcfg", (ITransformulaTransformer)bvToIntTransformulaTransformer);
        UnaryOperator unaryOperator = term -> new IntToBvBackTranslation(iIcfg.getCfgSmtToolkit().getManagedScript(), new LinkedHashMap(bvToIntTransformulaTransformer.getBacktranslationMap()), Collections.emptySet(), null).transform(term);
        icfgTransformationBacktranslator.addExpressionBacktranslation((Function)unaryOperator);
        return icfgTransformer.getResult();
    }

    private <INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> IIcfg<OUTLOC> applyMapElimination(IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, Class<OUTLOC> clazz, IcfgTransformationBacktranslator icfgTransformationBacktranslator, ReplacementVarFactory replacementVarFactory, IEqualityAnalysisResultProvider<IcfgLocation, IIcfg<?>> iEqualityAnalysisResultProvider) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new LocalTransformer((TransitionPreprocessor)new DNF(this.mServices), iIcfg.getCfgSmtToolkit().getManagedScript(), replacementVarFactory));
        MapEliminationSettings mapEliminationSettings = this.getMapElimSettings();
        arrayList.add(new MapEliminationTransformer(this.mServices, this.mLogger, iIcfg.getCfgSmtToolkit().getManagedScript(), iIcfg.getCfgSmtToolkit().getSymbolTable(), replacementVarFactory, mapEliminationSettings, iEqualityAnalysisResultProvider));
        return new IcfgTransformerSequence(this.mLogger, iIcfg, iLocationFactory, iLocationFactory, icfgTransformationBacktranslator, clazz, iIcfg.getIdentifier() + "IcfgWithMapElim", arrayList).getResult();
    }

    private IIcfg<IcfgLocation> applyMapEliminationMonniaux(IIcfg<IcfgLocation> iIcfg, IcfgTransformationBacktranslator icfgTransformationBacktranslator) {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        int n = iPreferenceProvider.getInt("Map elimination Monniaux: number of cells");
        return new MonniauxMapEliminator(this.mServices, this.mLogger, iIcfg, icfgTransformationBacktranslator, n).getResult();
    }

    private MapEliminationSettings getMapElimSettings() {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        boolean bl = iPreferenceProvider.getBoolean("Map elimination: also add inequalities");
        boolean bl2 = iPreferenceProvider.getBoolean("Map elimination: add only trivial implications for modified arguments");
        boolean bl3 = iPreferenceProvider.getBoolean("Map elimination: add only trivial implications for array writes");
        boolean bl4 = iPreferenceProvider.getBoolean("Map elimination: add only implications when all vars are in transformula");
        return new MapEliminationSettings(bl, bl2, bl3, bl4, this.mSimplificationTechnique);
    }

    private static ILocationFactory<BoogieIcfgLocation, BoogieIcfgLocation> createBoogieLocationFactory() {
        return (boogieIcfgLocation, debugIdentifier, string) -> {
            BoogieIcfgLocation boogieIcfgLocation2 = new BoogieIcfgLocation(debugIdentifier, string, boogieIcfgLocation.isErrorLocation(), boogieIcfgLocation.getBoogieASTNode());
            ModelUtils.copyAnnotations((IElement)boogieIcfgLocation, (IElement)boogieIcfgLocation2);
            return boogieIcfgLocation2;
        };
    }

    private static <INLOC extends IcfgLocation> ILocationFactory<INLOC, IcfgLocation> createIcfgLocationFactory() {
        return (icfgLocation, debugIdentifier, string) -> {
            IcfgLocation icfgLocation2 = new IcfgLocation(debugIdentifier, string);
            ModelUtils.copyAnnotations((IElement)icfgLocation, (IElement)icfgLocation2);
            return icfgLocation2;
        };
    }
}

