/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsDeterministic;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DeterminizeDD;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DeterminizeSadd<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>> {
    private final Map<Macrostate, STATE> mMacrostate2detState = new HashMap<Macrostate, STATE>();
    private final Map<STATE, Macrostate> mDetState2macrostate = new HashMap<STATE, Macrostate>();
    private final Map<STATE, Set<STATE>> mSummary = new HashMap<STATE, Set<STATE>>();
    private final STATE mAuxiliaryEmptyStackState;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final NestedWordAutomaton<LETTER, STATE> mResult;
    private final IDeterminizeStateFactory<STATE> mStateFactory;
    private final List<StatePair> mQueue = new LinkedList<StatePair>();
    private final Map<STATE, Set<STATE>> mVisited = new HashMap<STATE, Set<STATE>>();

    public DeterminizeSadd(AutomataLibraryServices automataLibraryServices, IDeterminizeStateFactory<STATE> iDeterminizeStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNestedWordAutomaton;
        this.mStateFactory = iDeterminizeStateFactory;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = new NestedWordAutomaton(this.mServices, this.mOperand.getVpAlphabet(), iDeterminizeStateFactory);
        this.mAuxiliaryEmptyStackState = this.mOperand.getEmptyStackState();
        this.determinize();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult.sizeInformation();
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    public boolean wasVisited(STATE STATE, STATE STATE2) {
        Set<STATE> set = this.mVisited.get(STATE);
        if (set == null) {
            return false;
        }
        return set.contains(STATE2);
    }

    public void markVisited(STATE STATE, STATE STATE2) {
        Set<STATE> set = this.mVisited.get(STATE);
        if (set == null) {
            set = new HashSet<STATE>();
            this.mVisited.put(STATE, set);
        }
        set.add(STATE2);
    }

    public void addSummary(STATE STATE, STATE STATE2) {
        Set<STATE> set = this.mSummary.get(STATE);
        if (set == null) {
            set = new HashSet<STATE>();
            this.mSummary.put(STATE, set);
        }
        set.add(STATE2);
    }

    public void enqueueAndMark(STATE STATE, STATE STATE2) {
        if (!this.wasVisited(STATE, STATE2)) {
            this.markVisited(STATE, STATE2);
            StatePair statePair = new StatePair(STATE, STATE2);
            this.mQueue.add(statePair);
        }
    }

    private Set<STATE> getKnownCallerStates(STATE STATE) {
        Set<STATE> set = this.mVisited.get(STATE);
        if (set == null) {
            return new HashSet(0);
        }
        return set;
    }

    private void determinize() throws AutomataOperationCanceledException {
        Object object2;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Starting determinizeSadd. Operand " + this.mOperand.sizeInformation()));
        }
        Macrostate macrostate = new Macrostate();
        for (Object object2 : this.mOperand.getInitialStates()) {
            macrostate.addPair(object2, this.mAuxiliaryEmptyStackState);
        }
        object2 = macrostate.getContent();
        this.mResult.addState(true, macrostate.mIsFinal, object2);
        this.mMacrostate2detState.put(macrostate, object2);
        this.mDetState2macrostate.put(object2, macrostate);
        this.enqueueAndMark(object2, this.mAuxiliaryEmptyStackState);
        while (!this.mQueue.isEmpty()) {
            StatePair statePair = this.mQueue.remove(0);
            this.processStatePair(statePair);
            if (!this.mSummary.containsKey(statePair.mState)) continue;
            for (STATE STATE : this.mSummary.get(statePair.mState)) {
                this.enqueueAndMark(STATE, statePair.mCallerState);
            }
        }
        assert (new IsDeterministic<LETTER, STATE>(this.mServices, this.mResult).getResult().booleanValue());
    }

    private void processStatePair(StatePair statePair) {
        Object object;
        Iterator<Object> iterator22;
        Object object222;
        Object object3;
        Object object422;
        Object STATE = statePair.mState;
        Macrostate macrostate = this.mDetState2macrostate.get(STATE);
        HashSet hashSet = new HashSet();
        for (Object object422 : macrostate.getStates()) {
            hashSet.addAll(this.mOperand.lettersInternal(object422));
        }
        for (Object object422 : hashSet) {
            object3 = this.internalSuccMacrostate(macrostate, object422);
            object222 = this.mMacrostate2detState.get(object3);
            if (object222 == null) {
                object222 = ((Macrostate)object3).getContent();
                this.mResult.addState(false, ((Macrostate)object3).mIsFinal, object222);
                this.mMacrostate2detState.put((Macrostate)object3, object222);
                this.mDetState2macrostate.put(object222, (Macrostate)object3);
            }
            this.mResult.addInternalTransition(STATE, object422, object222);
            this.enqueueAndMark(object222, statePair.mCallerState);
        }
        object422 = new HashSet();
        for (Iterator<Object> iterator22 : macrostate.getStates()) {
            object422.addAll(this.mOperand.lettersCall(iterator22));
        }
        object3 = object422.iterator();
        while (object3.hasNext()) {
            iterator22 = object3.next();
            object222 = this.callSuccMacrostate(macrostate, iterator22);
            object = this.mMacrostate2detState.get(object222);
            if (object == null) {
                object = ((Macrostate)object222).getContent();
                this.mResult.addState(false, ((Macrostate)object222).mIsFinal, object);
                this.mMacrostate2detState.put((Macrostate)object222, object);
                this.mDetState2macrostate.put(object, (Macrostate)object222);
            }
            this.mResult.addCallTransition(STATE, iterator22, object);
            this.enqueueAndMark(object, STATE);
        }
        iterator22 = statePair.mCallerState;
        if (iterator22 != this.mAuxiliaryEmptyStackState) {
            object3 = new HashSet();
            for (Object object222 : macrostate.getStates()) {
                object3.addAll(this.mOperand.lettersReturn(object222));
            }
            object = object3.iterator();
            while (object.hasNext()) {
                object222 = object.next();
                Macrostate macrostate2 = this.mDetState2macrostate.get(iterator22);
                Macrostate macrostate3 = this.returnSuccMacrostate(macrostate, macrostate2, object222);
                if (macrostate3.getStates().isEmpty()) continue;
                STATE STATE2 = this.mMacrostate2detState.get(macrostate3);
                if (STATE2 == null) {
                    STATE2 = macrostate3.getContent();
                    this.mResult.addState(false, macrostate3.mIsFinal, STATE2);
                    this.mMacrostate2detState.put(macrostate3, STATE2);
                    this.mDetState2macrostate.put(STATE2, macrostate3);
                }
                this.mResult.addReturnTransition(STATE, iterator22, (STATE)object222, STATE2);
                this.addSummary(iterator22, STATE2);
                for (Object object5 : this.getKnownCallerStates(iterator22)) {
                    this.enqueueAndMark(STATE2, object5);
                }
            }
        }
    }

    private Macrostate internalSuccMacrostate(Macrostate macrostate, LETTER LETTER) {
        Macrostate macrostate2 = new Macrostate();
        for (Object STATE : macrostate.getStates()) {
            for (OutgoingInternalTransition outgoingInternalTransition : this.mOperand.internalSuccessors(STATE, LETTER)) {
                Object STATE2 = outgoingInternalTransition.getSucc();
                Set set = macrostate.getCallerStates(STATE);
                macrostate2.addPairs(STATE2, set);
            }
        }
        return macrostate2;
    }

    private Macrostate callSuccMacrostate(Macrostate macrostate, LETTER LETTER) {
        Macrostate macrostate2 = new Macrostate();
        for (Object STATE : macrostate.getStates()) {
            for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(STATE, LETTER)) {
                Object STATE2 = outgoingCallTransition.getSucc();
                macrostate2.addPair(STATE2, STATE);
            }
        }
        return macrostate2;
    }

    private Macrostate returnSuccMacrostate(Macrostate macrostate, Macrostate macrostate2, LETTER LETTER) {
        Macrostate macrostate3 = new Macrostate();
        for (Object STATE : macrostate.getStates()) {
            for (Object STATE2 : macrostate.getCallerStates(STATE)) {
                for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessors(STATE, STATE2, LETTER)) {
                    this.returnSuccMacrostateHelper(macrostate2, macrostate3, STATE2, outgoingReturnTransition);
                }
            }
        }
        return macrostate3;
    }

    private void returnSuccMacrostateHelper(Macrostate macrostate, Macrostate macrostate2, STATE STATE, OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition) {
        STATE STATE2 = outgoingReturnTransition.getSucc();
        Set set = macrostate.getCallerStates(STATE);
        if (set != null) {
            macrostate2.addPairs(STATE2, set);
        }
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)"Testing correctness of determinization");
        }
        Object object = new DeterminizeDD<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mOperand).getResult();
        boolean bl = new IsEquivalent<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, object, this.mResult).getResult();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)"Finished testing correctness of determinization");
        }
        return bl;
    }

    private class Macrostate {
        private final Map<STATE, Set<STATE>> mPairList = new HashMap();
        private boolean mIsFinal = false;

        Set<STATE> getStates() {
            return this.mPairList.keySet();
        }

        Set<STATE> getCallerStates(STATE STATE) {
            return this.mPairList.get(STATE);
        }

        boolean isFinal() {
            return this.mIsFinal;
        }

        STATE getContent() {
            return DeterminizeSadd.this.mStateFactory.determinize(this.mPairList);
        }

        private void addPair(STATE STATE, STATE STATE2) {
            Set set;
            if (DeterminizeSadd.this.mOperand.isFinal(STATE)) {
                this.mIsFinal = true;
            }
            if ((set = this.mPairList.get(STATE)) == null) {
                set = new HashSet();
                this.mPairList.put(STATE, set);
            }
            set.add(STATE2);
        }

        private void addPairs(STATE STATE, Set<STATE> set) {
            Set set2;
            if (DeterminizeSadd.this.mOperand.isFinal(STATE)) {
                this.mIsFinal = true;
            }
            if ((set2 = this.mPairList.get(STATE)) == null) {
                set2 = new HashSet();
                this.mPairList.put(STATE, set2);
            }
            set2.addAll(set);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Macrostate macrostate = (Macrostate)object;
            return this.mPairList.equals(macrostate.mPairList);
        }

        public int hashCode() {
            return this.mPairList.hashCode();
        }

        public String toString() {
            return this.mPairList.toString();
        }
    }

    private class StatePair {
        private final STATE mState;
        private final STATE mCallerState;
        private final int mHashCode;

        public StatePair(STATE STATE, STATE STATE2) {
            this.mState = STATE;
            this.mCallerState = STATE2;
            this.mHashCode = this.computeHashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StatePair statePair = (StatePair)object;
            if (!this.getOuterType().equals(statePair.getOuterType())) {
                return false;
            }
            if (this.mCallerState == null ? statePair.mCallerState != null : !this.mCallerState.equals(statePair.mCallerState)) {
                return false;
            }
            return !(this.mState == null ? statePair.mState != null : !this.mState.equals(statePair.mState));
        }

        public int hashCode() {
            return this.mHashCode;
        }

        private final int computeHashCode() {
            int n = 31 + this.getOuterType().hashCode();
            n = 31 * n + (this.mCallerState == null ? 0 : this.mCallerState.hashCode());
            n = 31 * n + (this.mState == null ? 0 : this.mState.hashCode());
            return n;
        }

        public String toString() {
            return "CallerState: " + String.valueOf(this.mCallerState) + "  State: " + String.valueOf(this.mState);
        }

        private DeterminizeSadd<LETTER, STATE> getOuterType() {
            return DeterminizeSadd.this;
        }
    }
}

