/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.AGetRandomFtaBU;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.math.BigInteger;

public final class GetRandomNftaBU
extends AGetRandomFtaBU {
    private static final long DEFAULT_SEED = 0L;
    private double[] mRankToTransitionDensity = null;

    public static void main(String[] stringArray) throws AutomataOperationCanceledException {
        AutomataLibraryServices automataLibraryServices = new AutomataLibraryServices((IUltimateServiceProvider)new ToolchainStorage());
        int[] nArray = new int[]{2, 1, 3};
        double[] dArray = new double[]{0.1, 0.2, 0.5};
        GetRandomNftaBU getRandomNftaBU = new GetRandomNftaBU(automataLibraryServices, 10, nArray, dArray, 0.2);
        TreeAutomatonBU treeAutomatonBU = getRandomNftaBU.getResult();
        System.out.println(treeAutomatonBU);
    }

    private static int[] convertTransitionDensitiesToNumbers(int n, double[] dArray) {
        int[] nArray = new int[dArray.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            int n3;
            BigInteger bigInteger = BigInteger.valueOf(n).pow(n2 + 1);
            int n4 = bigInteger.intValueExact();
            double d = dArray[n2];
            nArray[n2] = n3 = GetRandomNftaBU.densityToAbsolute(d, n4);
            ++n2;
        }
        return nArray;
    }

    public GetRandomNftaBU(AutomataLibraryServices automataLibraryServices, int n, int[] nArray, double[] dArray, double d) throws AutomataOperationCanceledException {
        this(automataLibraryServices, n, nArray, dArray, d, 0L);
    }

    public GetRandomNftaBU(AutomataLibraryServices automataLibraryServices, int n, int[] nArray, double[] dArray, double d, long l) throws AutomataOperationCanceledException {
        super(automataLibraryServices, n, nArray, GetRandomNftaBU.convertTransitionDensitiesToNumbers(n, dArray), d, false, l);
        this.mRankToTransitionDensity = dArray;
        this.startGeneration();
    }

    public GetRandomNftaBU(AutomataLibraryServices automataLibraryServices, int n, int[] nArray, int[] nArray2, double d) throws AutomataOperationCanceledException {
        this(automataLibraryServices, n, nArray, nArray2, d, 0L);
    }

    public GetRandomNftaBU(AutomataLibraryServices automataLibraryServices, int n, int[] nArray, int[] nArray2, double d, long l) throws AutomataOperationCanceledException {
        super(automataLibraryServices, n, nArray, nArray2, d, false, l);
        this.startGeneration();
    }

    @Override
    protected void checkInputValidity() throws IllegalArgumentException {
        super.checkInputValidity();
        if (this.mRankToTransitionDensity == null) {
            return;
        }
        double[] dArray = this.mRankToTransitionDensity;
        int n = this.mRankToTransitionDensity.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d < 0.0 || d > 1.0) {
                throw new IllegalArgumentException("Illegal transition density.");
            }
            ++n2;
        }
    }
}

