/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CExpressionTranslator;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.FloatFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.INameHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;

public class MathLibraryModel
implements ILibraryModel {
    private static final String[] UNSUPPORTED_FLOAT_OPERATIONS = new String[]{"frexp", "ldexp", "pow", "hypot", "cbrt", "drem", "significand", "j0", "j1", "jn", "y0", "y1", "yn", "erfc", "lgamma", "tgamma", "gamma", "lgamma_r", "nextafter", "nexttoward", "scalbn", "ilogb", "scalbln", "remquo", "lrint", "llrint", "fma", "scalb", "frexpf", "ldexpf", "powf", "hypotf", "cbrtf", "dremf", "significandf", "j0f", "j1f", "jnf", "y0f", "y1f", "ynf", "erfcf", "lgammaf", "tgammaf", "gammaf", "lgammaf_r", "nextafterf", "nexttowardf", "scalbnf", "ilogbf", "scalblnf", "remquof", "lrintf", "llrintf", "fmaf", "scalbf", "frexpl", "ldexpl", "powl", "hypotl", "cbrtl", "dreml", "significandl", "j0l", "j1l", "jnl", "y0l", "y1l", "ynl", "erfcl", "lgammal", "tgammal", "gammal", "lgammal_r", "nextafterl", "nexttowardl", "scalbnl", "ilogbl", "scalblnl", "remquol", "lrintl", "llrintl", "fmal", "scalbl", "signgam;", "modf", "modff", "modfl"};
    private static final List<String> UNARY_FUNCTIONS = List.of("fpclassify", "__fpclassify", "__fpclassifyf", "__fpclassifyl", "isfinite", "isinf", "__isinf", "isnan", "__isnan", "finite", "__finite", "finitef", "__finitef", "finitel", "__finitel", "isinff", "__isinff", "isinfl", "__isinfl", "isnanf", "isnanl", "__isnanf", "__isnanl", "isnormal", "sqrt", "sqrtf", "sqrtl", "fabs", "fabsf", "fabsl", "trunc", "truncf", "truncl", "round", "roundf", "roundl", "lround", "lroundf", "lroundl", "llround", "llroundf", "llroundl", "floor", "floorf", "floorl", "ceil", "ceilf", "ceilr");
    private static final List<String> BINARY_FUNCTIONS = List.of("fmax", "fmaxf", "fmaxl", "fmin", "fminf", "fminl", "fmod", "fmodf", "fmodl", "fdim", "fdimf", "fdiml");
    private final FunctionModelHelper mHelper;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final ExpressionTranslation mExpressionTranslation;
    private final CExpressionTranslator mCEpressionTranslator;
    private final INameHandler mNameHandler;

    public MathLibraryModel(FunctionModelHelper functionModelHelper, ExpressionResultTransformer expressionResultTransformer, ExpressionTranslation expressionTranslation, CExpressionTranslator cExpressionTranslator, INameHandler iNameHandler) {
        this.mHelper = functionModelHelper;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mExpressionTranslation = expressionTranslation;
        this.mCEpressionTranslator = cExpressionTranslator;
        this.mNameHandler = iNameHandler;
    }

    private static List<Pair<String, CPrimitive.CPrimitives>> getOverapproximatedUnaryFunctions() {
        ArrayList<Pair<String, CPrimitive.CPrimitives>> arrayList = new ArrayList<Pair<String, CPrimitive.CPrimitives>>();
        arrayList.add(new Pair((Object)"sin", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"sinf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"sinl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"exp", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"expf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"expl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"expm1", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"expm1f", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"expm1l", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"tanh", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"tanhf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"tanhl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"erf", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"erff", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"erfl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"log", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"logf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"logl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"cos", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"cosf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"cosl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"log1p", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"log1pf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"log1pl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"rint", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"rintf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"rintl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"atanh", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"atanhf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"atanhl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"asin", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"asinf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"asinl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"acos", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"acosf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"acosl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"nearbyint", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"nearbyintf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"nearbyintl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"signbit", (Object)CPrimitive.CPrimitives.INT));
        arrayList.add(new Pair((Object)"__signbit", (Object)CPrimitive.CPrimitives.INT));
        arrayList.add(new Pair((Object)"__signbitl", (Object)CPrimitive.CPrimitives.INT));
        arrayList.add(new Pair((Object)"__signbitf", (Object)CPrimitive.CPrimitives.INT));
        arrayList.add(new Pair((Object)"atan", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"atanf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"atanl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"atan2", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"atan2f", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"atan2l", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"tan", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"tanf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"tanl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"cosh", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"coshf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"coshl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"sinh", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"sinhf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"sinhl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"acosh", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"acoshf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"acoshl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"asinh", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"asinhf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"asinhl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"log10", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"log10f", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"log10l", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"logb", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"logbf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"logbl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"exp2", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"exp2f", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"exp2l", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"log2", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"log2f", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"log2l", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        return arrayList;
    }

    private static List<Pair<String, CPrimitive.CPrimitives>> getOverapproximatedBinaryFunctions() {
        ArrayList<Pair<String, CPrimitive.CPrimitives>> arrayList = new ArrayList<Pair<String, CPrimitive.CPrimitives>>();
        arrayList.add(new Pair((Object)"remainder", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"remainderf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"remainderl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        arrayList.add(new Pair((Object)"copysign", (Object)CPrimitive.CPrimitives.DOUBLE));
        arrayList.add(new Pair((Object)"copysignf", (Object)CPrimitive.CPrimitives.FLOAT));
        arrayList.add(new Pair((Object)"copysignl", (Object)CPrimitive.CPrimitives.LONGDOUBLE));
        return arrayList;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        ArrayList<ILibraryModel.FunctionModel> arrayList = new ArrayList<ILibraryModel.FunctionModel>();
        for (Pair<String, CPrimitive.CPrimitives> object : MathLibraryModel.getOverapproximatedUnaryFunctions()) {
            arrayList.add(new ILibraryModel.FunctionModel((String)object.getFirst(), (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive((CPrimitive.CPrimitives)((Object)((Object)((Object)object.getSecond())))))));
        }
        for (Pair<String, CPrimitive.CPrimitives> pair : MathLibraryModel.getOverapproximatedBinaryFunctions()) {
            arrayList.add(new ILibraryModel.FunctionModel((String)pair.getFirst(), (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, new CPrimitive((CPrimitive.CPrimitives)((Object)((Object)((Object)object.getSecond())))))));
        }
        for (String string2 : UNARY_FUNCTIONS) {
            arrayList.add(new ILibraryModel.FunctionModel(string2, this::handleUnaryFloatFunction));
        }
        for (String string3 : BINARY_FUNCTIONS) {
            arrayList.add(new ILibraryModel.FunctionModel(string3, this::handleBinaryFloatFunction));
        }
        arrayList.add(new ILibraryModel.FunctionModel("nan", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNaNOrInfinity(iLocation, string)));
        arrayList.add(new ILibraryModel.FunctionModel("nanf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNaNOrInfinity(iLocation, string)));
        arrayList.add(new ILibraryModel.FunctionModel("nanl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNaNOrInfinity(iLocation, string)));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_nan", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNaNOrInfinity(iLocation, "nan")));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_nanf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNaNOrInfinity(iLocation, "nanf")));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_nanl", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNaNOrInfinity(iLocation, "nanl")));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_inff", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNaNOrInfinity(iLocation, "inff")));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_huge_val", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNaNOrInfinity(iLocation, "inf")));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_huge_valf", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleNaNOrInfinity(iLocation, "inff")));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_isgreater", this::handleIsGreater));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_isgreaterequal", this::handleIsGreaterEqual));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_isless", this::handleIsLess));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_islessequal", this::handleIsLessEqual));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_isunordered", this::handleIsUnordered));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_islessgreater", this::handleIsLessGreater));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_isnan", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleUnaryFloatFunction(iDispatcher, iASTFunctionCallExpression, iLocation, "isnan")));
        arrayList.add(new ILibraryModel.FunctionModel("isgreater", this::handleIsGreater));
        arrayList.add(new ILibraryModel.FunctionModel("isgreaterequal", this::handleIsGreaterEqual));
        arrayList.add(new ILibraryModel.FunctionModel("isless", this::handleIsLess));
        arrayList.add(new ILibraryModel.FunctionModel("islessequal", this::handleIsLessEqual));
        arrayList.add(new ILibraryModel.FunctionModel("isunordered", this::handleIsUnordered));
        arrayList.add(new ILibraryModel.FunctionModel("islessgreater", this::handleIsLessGreater));
        return arrayList;
    }

    @Override
    public Collection<String> getUnsupportedFunctions() {
        return Arrays.asList(UNSUPPORTED_FLOAT_OPERATIONS);
    }

    private Result handleNaNOrInfinity(ILocation iLocation, String string) {
        return this.mExpressionTranslation.createNanOrInfinity(iLocation, string);
    }

    private Result handleUnaryFloatFunction(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        FloatFunction floatFunction = FloatFunction.decode(string);
        ExpressionResult expressionResult = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, floatFunction).get(0);
        RValue rValue = this.mExpressionTranslation.constructOtherUnaryFloatOperation(iLocation, floatFunction, (RValue)expressionResult.getLrValue());
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult).setLrValue(rValue).build();
    }

    private Result handleBinaryFloatFunction(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        FloatFunction floatFunction = FloatFunction.decode(string);
        List<ExpressionResult> list = this.handleFloatArguments(iDispatcher, iASTFunctionCallExpression, iLocation, string, 2, floatFunction);
        RValue rValue = this.mExpressionTranslation.constructOtherBinaryFloatOperation(iLocation, floatFunction, (RValue)list.get(0).getLrValue(), (RValue)list.get(1).getLrValue());
        return new ExpressionResultBuilder().addAllExceptLrValue(list).setLrValue(rValue).build();
    }

    private List<ExpressionResult> handleFloatArguments(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, int n, FloatFunction floatFunction) {
        CPrimitive cPrimitive;
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, n, string, iASTInitializerClauseArray);
        if (floatFunction == null) {
            throw new IllegalArgumentException("Ultimate declared float handling for " + string + ", but is not known float function");
        }
        ArrayList<ExpressionResult> arrayList = new ArrayList<ExpressionResult>();
        IASTInitializerClause[] iASTInitializerClauseArray2 = iASTInitializerClauseArray;
        int n2 = iASTInitializerClauseArray.length;
        int n3 = 0;
        while (n3 < n2) {
            cPrimitive = iASTInitializerClauseArray2[n3];
            ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, (IASTInitializerClause)cPrimitive);
            ExpressionResult expressionResult2 = this.mExprResultTransformer.convertIfNecessary(iLocation, expressionResult, floatFunction.getType());
            arrayList.add(expressionResult2);
            ++n3;
        }
        cPrimitive = floatFunction.getType();
        if (cPrimitive != null) {
            ArrayList<ExpressionResult> arrayList2 = new ArrayList<ExpressionResult>();
            for (ExpressionResult expressionResult : arrayList) {
                arrayList2.add(this.mExprResultTransformer.convertIfNecessary(iLocation, expressionResult, cPrimitive));
            }
            return arrayList2;
        }
        return arrayList;
    }

    private Result handleIsLess(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleBinaryComparison(iDispatcher, iASTFunctionCallExpression, iLocation, string, 8);
    }

    private Result handleIsLessEqual(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleBinaryComparison(iDispatcher, iASTFunctionCallExpression, iLocation, string, 10);
    }

    private Result handleIsGreater(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleBinaryComparison(iDispatcher, iASTFunctionCallExpression, iLocation, string, 9);
    }

    private Result handleIsGreaterEqual(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        return this.handleBinaryComparison(iDispatcher, iASTFunctionCallExpression, iLocation, string, 11);
    }

    private Result handleBinaryComparison(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, int n) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        return this.mCEpressionTranslator.handleRelationalOperators(iLocation, n, expressionResult, expressionResult2);
    }

    private Result handleIsUnordered(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        ExpressionResult expressionResult3 = this.mExpressionTranslation.createNan(iLocation, (CPrimitive)expressionResult.getLrValue().getCType());
        ExpressionResult expressionResult4 = this.mExpressionTranslation.createNan(iLocation, (CPrimitive)expressionResult2.getLrValue().getCType());
        Expression expression = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expressionResult.getLrValue().getValue(), (Expression)expressionResult3.getLrValue().getValue());
        Expression expression2 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)expressionResult2.getLrValue().getValue(), (Expression)expressionResult4.getLrValue().getValue());
        Expression expression3 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expression, (Expression)expression2);
        RValue rValue = new RValue(expression3, new CPrimitive(CPrimitive.CPrimitives.INT), true);
        ExpressionResult expressionResult5 = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2, expressionResult3, expressionResult4).setLrValue(rValue).build();
        assert (CTranslationUtil.isAuxVarMapComplete(this.mNameHandler, expressionResult5.getDeclarations(), expressionResult5.getAuxVars()));
        return expressionResult5;
    }

    private Result handleIsLessGreater(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        Pair<ExpressionResult, ExpressionResult> pair = this.mExprResultTransformer.usualArithmeticConversions(iLocation, expressionResult, expressionResult2);
        expressionResult = (ExpressionResult)pair.getFirst();
        expressionResult2 = (ExpressionResult)pair.getSecond();
        ExpressionResult expressionResult3 = this.mCEpressionTranslator.handleRelationalOperators(iLocation, 8, expressionResult, expressionResult2);
        ExpressionResult expressionResult4 = this.mCEpressionTranslator.handleRelationalOperators(iLocation, 9, expressionResult, expressionResult2);
        Expression expression = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.LOGICOR, (Expression)expressionResult3.getLrValue().getValue(), (Expression)expressionResult4.getLrValue().getValue());
        RValue rValue = new RValue(expression, new CPrimitive(CPrimitive.CPrimitives.INT), true);
        ExpressionResult expressionResult5 = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult3, expressionResult4).setLrValue(rValue).build();
        assert (CTranslationUtil.isAuxVarMapComplete(this.mNameHandler, expressionResult5.getDeclarations(), expressionResult5.getAuxVars()));
        return expressionResult5;
    }

    @Override
    public Collection<ILibraryModel.TypeModel> getTypeModels() {
        return List.of(new ILibraryModel.TypeModel("float_t", new CPrimitive(CPrimitive.CPrimitives.FLOAT)), new ILibraryModel.TypeModel("double_t", new CPrimitive(CPrimitive.CPrimitives.DOUBLE)));
    }

    private ILibraryModel.ConstantModel modelNumberClassificationMacro(String string) {
        return new ILibraryModel.ConstantModel(string, iLocation -> new ExpressionResult(this.mExpressionTranslation.handleNumberClassificationMacro(iLocation, string)));
    }

    @Override
    public Collection<ILibraryModel.ConstantModel> getConstantModels() {
        return List.of(new ILibraryModel.ConstantModel("NAN", iLocation -> this.mExpressionTranslation.createNanOrInfinity(iLocation, "NAN")), new ILibraryModel.ConstantModel("INFINITY", iLocation -> this.mExpressionTranslation.createNanOrInfinity(iLocation, "INFINITY")), new ILibraryModel.ConstantModel("inf", iLocation -> this.mExpressionTranslation.createNanOrInfinity(iLocation, "inf")), this.modelNumberClassificationMacro("FP_NAN"), this.modelNumberClassificationMacro("FP_INFINITE"), this.modelNumberClassificationMacro("FP_ZERO"), this.modelNumberClassificationMacro("FP_SUBNORMAL"), this.modelNumberClassificationMacro("FP_NORMAL"));
    }
}

