/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.Case;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.MultiCaseSolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.SupportingTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.LexicographicCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MultiCaseSolutionBuilder {
    private final Term mSubject;
    private final MultiCaseSolvedBinaryRelation.Xnf mXnf;
    private final Set<TermVariable> mAdditionalAuxiliaryVariables;
    private final Set<MultiCaseSolvedBinaryRelation.IntricateOperation> mAdditionalIntricateOperations;
    private List<Case> mCases;
    private boolean mConstructionFinished = false;

    public MultiCaseSolutionBuilder(Term term, MultiCaseSolvedBinaryRelation.Xnf xnf) {
        this.mXnf = xnf;
        this.mSubject = term;
        this.mCases = new ArrayList<Case>();
        this.mAdditionalAuxiliaryVariables = new HashSet<TermVariable>();
        this.mAdditionalIntricateOperations = new HashSet<MultiCaseSolvedBinaryRelation.IntricateOperation>();
    }

    public void addAtoms(Object ... objectArray) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("construction already finished");
        }
        if (this.mCases.isEmpty()) {
            this.mCases.add(new Case(null, Collections.emptySet(), this.mXnf));
        }
        this.mCases = this.buildCopyAndAddToEachCase(this.mCases, this.buildCase(objectArray));
    }

    public void splitCases(Collection<Case> collection) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("construction already finished");
        }
        ArrayList<Case> arrayList = new ArrayList<Case>();
        for (Case case_ : collection) {
            if (this.mCases.isEmpty()) {
                arrayList.add(case_);
                continue;
            }
            arrayList.addAll(this.buildCopyAndAddToEachCase(this.mCases, case_));
        }
        this.mCases = arrayList;
    }

    private static List<List<?>> convertDnfToCnf(List<List<?>> list2) {
        int[] nArray = list2.stream().mapToInt(list -> list.size()).toArray();
        LexicographicCounter lexicographicCounter = new LexicographicCounter(nArray);
        ArrayList arrayList = new ArrayList();
        do {
            ArrayList arrayList2 = new ArrayList();
            int n = 0;
            while (n < list2.size()) {
                Object obj = list2.get(n).get(lexicographicCounter.getCurrentValue()[n]);
                arrayList2.add(obj);
                ++n;
            }
            arrayList.add(arrayList2);
            lexicographicCounter.increment();
        } while (!lexicographicCounter.isZero());
        return arrayList;
    }

    public void reportAdditionalIntricateOperation(MultiCaseSolvedBinaryRelation.IntricateOperation intricateOperation) {
        this.mAdditionalIntricateOperations.add(intricateOperation);
    }

    public void reportAdditionalAuxiliaryVariable(TermVariable termVariable) {
        this.mAdditionalAuxiliaryVariables.add(termVariable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Case buildCase(Object ... objectArray) throws AssertionError {
        SolvedBinaryRelation solvedBinaryRelation = null;
        HashSet<SupportingTerm> hashSet = new HashSet<SupportingTerm>();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof SolvedBinaryRelation) {
                if (solvedBinaryRelation != null) throw new AssertionError((Object)"already have a solvedBinayRelation");
                solvedBinaryRelation = (SolvedBinaryRelation)object;
            } else {
                if (!(object instanceof SupportingTerm)) throw new UnsupportedOperationException();
                hashSet.add((SupportingTerm)object);
            }
            ++n2;
        }
        return new Case(solvedBinaryRelation, hashSet, this.mXnf);
    }

    private List<Case> buildSingletonCases(Object ... objectArray) throws AssertionError {
        ArrayList<Case> arrayList = new ArrayList<Case>();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof SolvedBinaryRelation) {
                var7_7 = new Case((SolvedBinaryRelation)object, Collections.emptySet(), this.mXnf);
                arrayList.add(var7_7);
            } else if (object instanceof SupportingTerm) {
                var7_7 = new Case(null, Collections.singleton((SupportingTerm)object), this.mXnf);
                arrayList.add(var7_7);
            } else {
                throw new UnsupportedOperationException();
            }
            ++n2;
        }
        return arrayList;
    }

    private List<Case> buildCopyAndAddToEachCase(List<Case> list, Case case_) {
        ArrayList<Case> arrayList = new ArrayList<Case>();
        for (Case case_2 : list) {
            SolvedBinaryRelation solvedBinaryRelation = null;
            HashSet<SupportingTerm> hashSet = new HashSet<SupportingTerm>(case_2.getSupportingTerms());
            solvedBinaryRelation = case_2.getSolvedBinaryRelation();
            if (case_.getSolvedBinaryRelation() != null) {
                if (solvedBinaryRelation == null) {
                    solvedBinaryRelation = case_.getSolvedBinaryRelation();
                } else {
                    throw new AssertionError((Object)"already have a solvedBinayRelation");
                }
            }
            hashSet.addAll(case_.getSupportingTerms());
            Case case_3 = new Case(solvedBinaryRelation, hashSet, this.mXnf);
            arrayList.add(case_3);
        }
        return arrayList;
    }

    private List<Case> buildProduct(List<Case> list, Object ... objectArray) {
        ArrayList<Case> arrayList = new ArrayList<Case>();
        for (Case case_ : list) {
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray2[n2];
                if (case_.getSolvedBinaryRelation() != null) {
                    throw new AssertionError((Object)"already have a solvedBinayRelation");
                }
                if (object instanceof SolvedBinaryRelation) {
                    var10_10 = (SolvedBinaryRelation)object;
                    var11_11 = new Case((SolvedBinaryRelation)var10_10, case_.getSupportingTerms(), this.mXnf);
                    arrayList.add(var11_11);
                } else if (object instanceof SupportingTerm) {
                    var10_10 = new HashSet<SupportingTerm>(case_.getSupportingTerms());
                    var10_10.add((SupportingTerm)object);
                    var11_11 = new Case(case_.getSolvedBinaryRelation(), (Set<SupportingTerm>)var10_10, this.mXnf);
                    arrayList.add(var11_11);
                } else {
                    throw new UnsupportedOperationException();
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public MultiCaseSolvedBinaryRelation buildResult() {
        this.mConstructionFinished = true;
        EnumSet<MultiCaseSolvedBinaryRelation.IntricateOperation> enumSet = this.mAdditionalIntricateOperations.isEmpty() ? EnumSet.noneOf(MultiCaseSolvedBinaryRelation.IntricateOperation.class) : EnumSet.copyOf(this.mAdditionalIntricateOperations);
        return new MultiCaseSolvedBinaryRelation(this.mSubject, this.mCases, this.mAdditionalAuxiliaryVariables, enumSet, this.mXnf);
    }
}

