/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MutableAffineTerm {
    TreeMap<LinVar, Rational> mSummands = new TreeMap();
    InfinitesimalNumber mConstant = InfinitesimalNumber.ZERO;

    public MutableAffineTerm add(Rational rational) {
        this.mConstant = this.mConstant.add(new InfinitesimalNumber(rational, 0));
        return this;
    }

    public MutableAffineTerm add(InfinitesimalNumber infinitesimalNumber) {
        this.mConstant = this.mConstant.add(infinitesimalNumber);
        return this;
    }

    public MutableAffineTerm add(Rational rational, LinVar linVar) {
        if (rational.equals((Object)Rational.ZERO)) {
            return this;
        }
        if (linVar.isInitiallyBasic()) {
            for (Map.Entry<LinVar, BigInteger> entry : linVar.getLinTerm().entrySet()) {
                this.add(rational.mul(entry.getValue()), entry.getKey());
            }
        } else {
            this.addSimple(rational, linVar);
        }
        return this;
    }

    private void addMap(Rational rational, Map<LinVar, Rational> map) {
        for (Map.Entry<LinVar, Rational> entry : map.entrySet()) {
            this.addSimple(rational.mul(entry.getValue()), entry.getKey());
        }
    }

    private void addSimple(Rational rational, LinVar linVar) {
        assert (!rational.equals((Object)Rational.ZERO));
        Rational rational2 = this.mSummands.remove(linVar);
        if (rational2 != null && (rational = rational2.add(rational)).equals((Object)Rational.ZERO)) {
            return;
        }
        this.mSummands.put(linVar, rational);
    }

    public MutableAffineTerm add(Rational rational, MutableAffineTerm mutableAffineTerm) {
        if (rational != Rational.ZERO) {
            this.addMap(rational, mutableAffineTerm.mSummands);
            this.mConstant = this.mConstant.add(mutableAffineTerm.mConstant.mul(rational));
        }
        return this;
    }

    public MutableAffineTerm mul(Rational rational) {
        if (rational.equals((Object)Rational.ZERO)) {
            this.mSummands.clear();
        } else if (!rational.equals((Object)Rational.ONE)) {
            for (Map.Entry<LinVar, Rational> entry : this.mSummands.entrySet()) {
                entry.setValue(rational.mul(entry.getValue()));
            }
            this.mConstant = this.mConstant.mul(rational);
        }
        return this;
    }

    public MutableAffineTerm div(Rational rational) {
        return this.mul(rational.inverse());
    }

    public MutableAffineTerm negate() {
        return this.mul(Rational.MONE);
    }

    public boolean isConstant() {
        return this.mSummands.isEmpty();
    }

    public InfinitesimalNumber getConstant() {
        return this.mConstant;
    }

    public TreeMap<LinVar, Rational> getSummands() {
        return this.mSummands;
    }

    public Rational getGCD() {
        assert (!this.mSummands.isEmpty());
        Iterator<Rational> iterator = this.mSummands.values().iterator();
        Rational rational = iterator.next();
        boolean bl = rational.isNegative();
        rational = rational.abs();
        while (iterator.hasNext()) {
            rational = rational.gcd(iterator.next().abs());
        }
        if (bl) {
            rational = rational.negate();
        }
        return rational;
    }

    void normalize() {
        this.mul(this.getGCD().inverse());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Map.Entry<LinVar, Rational> entry : this.mSummands.entrySet()) {
            LinVar linVar = entry.getKey();
            Rational rational = entry.getValue();
            if (rational.isNegative()) {
                stringBuilder.append(bl ? "-" : " - ");
            } else {
                stringBuilder.append(bl ? "" : " + ");
            }
            rational = rational.abs();
            if (!rational.equals((Object)Rational.ONE)) {
                stringBuilder.append(rational).append('*');
            }
            stringBuilder.append(linVar);
            bl = false;
        }
        if (bl) {
            stringBuilder.append(this.mConstant);
        } else {
            int n = this.mConstant.compareTo(InfinitesimalNumber.ZERO);
            if (n < 0) {
                stringBuilder.append(" - ");
                stringBuilder.append(this.mConstant.mul(Rational.MONE));
            } else if (n > 0) {
                stringBuilder.append(" + ");
                stringBuilder.append(this.mConstant);
            }
        }
        return stringBuilder.toString();
    }

    public Sort getSort(Theory theory) {
        return this.isInt() ? theory.getSort("Int", new Sort[0]) : theory.getSort("Real", new Sort[0]);
    }

    public Term toSMTLib(Theory theory, boolean bl) {
        Sort sort;
        Sort sort2 = sort = bl ? theory.getSort("Int", new Sort[0]) : theory.getSort("Real", new Sort[0]);
        assert (sort != null);
        Sort[] sortArray = new Sort[]{sort, sort};
        FunctionSymbol functionSymbol = theory.getFunction("*", sortArray);
        FunctionSymbol functionSymbol2 = theory.getFunction("+", sortArray);
        FunctionSymbol functionSymbol3 = theory.getFunction("-", new Sort[]{sort});
        if (functionSymbol3 == null) {
            functionSymbol3 = theory.getFunction("-", new Sort[]{sort});
        }
        assert (!bl || this.mConstant.mReal.isIntegral());
        Term term = this.mConstant.mReal.equals((Object)Rational.ZERO) ? null : this.mConstant.mReal.toTerm(sort);
        Term[] termArray = new Term[this.mSummands.size() + (term == null ? 0 : 1)];
        if (term != null) {
            termArray[this.mSummands.size()] = term;
        }
        int n = 0;
        for (Map.Entry<LinVar, Rational> entry : this.mSummands.entrySet()) {
            Term[] termArray2;
            LinVar linVar = entry.getKey();
            Term term2 = linVar.getTerm();
            Term[] termArray3 = term2 instanceof ApplicationTerm && ((ApplicationTerm)term2).getFunction().getName().equals("*") ? ((ApplicationTerm)term2).getParameters() : new Term[]{term2};
            assert (!bl || linVar.isInt());
            assert (!bl || entry.getValue().isIntegral());
            if (!bl && linVar.isInt()) {
                termArray2 = theory.getSort("Int", new Sort[0]);
                FunctionSymbol functionSymbol4 = theory.getFunction("to_real", new Sort[]{termArray2});
                int n2 = 0;
                while (n2 < termArray3.length) {
                    termArray3[n2] = theory.term(functionSymbol4, new Term[]{termArray3[n2]});
                    ++n2;
                }
            }
            if (!entry.getValue().equals((Object)Rational.ONE)) {
                termArray2 = new Term[termArray3.length + 1];
                termArray2[0] = entry.getValue().toTerm(sort);
                System.arraycopy(termArray3, 0, termArray2, 1, termArray3.length);
                termArray3 = termArray2;
            }
            Term term3 = termArray[n++] = termArray3.length == 1 ? termArray3[0] : theory.term(functionSymbol, termArray3);
        }
        if (termArray.length == 0) {
            return Rational.ZERO.toTerm(sort);
        }
        if (termArray.length == 1) {
            return termArray[0];
        }
        return theory.term(functionSymbol2, termArray);
    }

    public boolean isInt() {
        for (LinVar linVar : this.mSummands.keySet()) {
            if (linVar.isInt()) continue;
            return false;
        }
        return true;
    }

    public Term toSMTLibLeq0(Theory theory) {
        assert (this.mConstant.mEps >= 0);
        if (this.isConstant()) {
            return this.mConstant.compareTo(InfinitesimalNumber.ZERO) <= 0 ? theory.mTrue : theory.mFalse;
        }
        boolean bl = this.isInt();
        Sort sort = theory.getSort(bl ? "Int" : "Real", new Sort[0]);
        String string = this.mConstant.mEps == 0 ? "<=" : "<";
        Term term = Rational.ZERO.toTerm(sort);
        return theory.term(string, new Term[]{this.toSMTLib(theory, bl), term});
    }
}

