/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.TraceCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders.AssertOrderInsideLoopFirst1;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders.AssertOrderMixInsideOutside;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders.AssertOrderNotIncrementally;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders.AssertOrderOutsideLoopFirst1;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders.AssertOrderOutsideLoopFirst2;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders.AssertOrderShuffledSingletons;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders.AssertOrderSmallConstantsFirst;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders.AssertOrderSmtFeatureHeuristic;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders.IAssertOrder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.AnnotateAndAssertCodeBlocks;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.ModifiableNestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class AnnotateAndAsserter<L extends IAction> {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mMgdScriptTc;
    private Script.LBool mSatisfiable;
    private final NestedFormulas<L, Term, Term> mSSA;
    private ModifiableNestedFormulas<L, Term, Term> mAnnotSSA;
    private final AnnotateAndAssertCodeBlocks<L> mAnnotateAndAssertCodeBlocks;
    private final TraceCheckStatisticsGenerator mTcbg;
    private final ITraceCheckPreferences.AssertCodeBlockOrder mAssertCodeBlocksOrder;
    private int mCheckSat;
    private int mAssertedStatements;

    public AnnotateAndAsserter(ManagedScript managedScript, NestedFormulas<L, Term, Term> nestedFormulas, AnnotateAndAssertCodeBlocks<L> annotateAndAssertCodeBlocks, TraceCheckStatisticsGenerator traceCheckStatisticsGenerator, ITraceCheckPreferences.AssertCodeBlockOrder assertCodeBlockOrder, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(TraceCheckerUtils.PLUGIN_ID);
        this.mMgdScriptTc = managedScript;
        this.mSSA = nestedFormulas;
        this.mAnnotateAndAssertCodeBlocks = annotateAndAssertCodeBlocks;
        this.mTcbg = traceCheckStatisticsGenerator;
        this.mAssertCodeBlocksOrder = assertCodeBlockOrder;
        this.mCheckSat = 0;
        this.mAssertedStatements = 0;
        this.buildAnnotatedSsaAndAssertTerms();
    }

    private void buildAnnotatedSsaAndAssertTerms() {
        this.mAnnotSSA = new ModifiableNestedFormulas(this.mSSA.getCounterexample(), new TreeMap());
        this.mAnnotSSA.setPrecondition(this.mAnnotateAndAssertCodeBlocks.annotateAndAssertPrecondition());
        this.mAnnotSSA.setPostcondition(this.mAnnotateAndAssertCodeBlocks.annotateAndAssertPostcondition());
        this.mTcbg.reportNewCodeBlocks(this.mSSA.getCounterexample().length());
        List<Set<Integer>> list = this.getAssertOrder(this.mAssertCodeBlocksOrder).partition(this.mSSA.getCounterexample());
        this.mLogger.info((Object)String.format("Assert order %s partitioned %s statements into %s equivalence classes.", this.mAssertCodeBlocksOrder, this.mSSA.getCounterexample().length(), list.size()));
        this.mSatisfiable = this.annotateAndAssert(this.mSSA.getTrace(), list);
        this.mLogger.info((Object)String.format("Assert order %s issued %s check-sat command(s) and asserted %s of %s statements.", this.mAssertCodeBlocksOrder, this.mCheckSat, this.mAssertedStatements, this.mSSA.getCounterexample().length()));
        this.mLogger.info((Object)("Assert order " + String.valueOf(this.mAssertCodeBlocksOrder) + " issued " + this.mCheckSat + " check-sat command(s)"));
        this.mLogger.info((Object)("Conjunction of SSA is " + String.valueOf(this.mSatisfiable)));
    }

    private IAssertOrder<L> getAssertOrder(ITraceCheckPreferences.AssertCodeBlockOrder assertCodeBlockOrder) {
        return switch (assertCodeBlockOrder.getAssertCodeBlockOrderType()) {
            case ITraceCheckPreferences.AssertCodeBlockOrderType.NOT_INCREMENTALLY -> new AssertOrderNotIncrementally();
            case ITraceCheckPreferences.AssertCodeBlockOrderType.OUTSIDE_LOOP_FIRST1 -> new AssertOrderOutsideLoopFirst1();
            case ITraceCheckPreferences.AssertCodeBlockOrderType.OUTSIDE_LOOP_FIRST2 -> new AssertOrderOutsideLoopFirst2();
            case ITraceCheckPreferences.AssertCodeBlockOrderType.INSIDE_LOOP_FIRST1 -> new AssertOrderInsideLoopFirst1();
            case ITraceCheckPreferences.AssertCodeBlockOrderType.MIX_INSIDE_OUTSIDE -> new AssertOrderMixInsideOutside();
            case ITraceCheckPreferences.AssertCodeBlockOrderType.TERMS_WITH_SMALL_CONSTANTS_FIRST -> new AssertOrderSmallConstantsFirst();
            case ITraceCheckPreferences.AssertCodeBlockOrderType.SMT_FEATURE_HEURISTIC -> new AssertOrderSmtFeatureHeuristic(assertCodeBlockOrder.getSmtFeatureHeuristicScoringMethod(), assertCodeBlockOrder.getSmtFeatureHeuristicNumPartitions(), assertCodeBlockOrder.getSmtFeatureHeuristicThreshold(), assertCodeBlockOrder.getSmtFeatureHeuristicPartitioningType(), this.mLogger);
            case ITraceCheckPreferences.AssertCodeBlockOrderType.SHUFFLED_SINGLETONS -> new AssertOrderShuffledSingletons();
            default -> throw new MatchException(null, null);
        };
    }

    private Script.LBool annotateAndAssert(NestedWord<? extends IAction> nestedWord, List<Set<Integer>> list) {
        Script.LBool lBool = null;
        boolean bl = true;
        for (Set<Integer> set : list) {
            this.buildAnnotatedSsaAndAssertTermsWithPriorizedOrder(nestedWord, set, bl);
            this.mAssertedStatements += set.size();
            ++this.mCheckSat;
            lBool = this.mMgdScriptTc.getScript().checkSat();
            this.mTcbg.reportNewCheckSat();
            this.mTcbg.reportNewAssertedCodeBlocks(set.size());
            if (lBool == Script.LBool.UNSAT) {
                return lBool;
            }
            bl = false;
        }
        return lBool;
    }

    private void buildAnnotatedSsaAndAssertTermsWithPriorizedOrder(NestedWord<? extends IAction> nestedWord, Set<Integer> set, boolean bl) {
        for (Integer n : set) {
            if (nestedWord.isCallPosition(n.intValue())) {
                this.mAnnotSSA.setGlobalVarAssignmentAtPos(n, this.mAnnotateAndAssertCodeBlocks.annotateAndAssertGlobalVarAssignemntCall(n));
                this.mAnnotSSA.setLocalVarAssignmentAtPos(n, this.mAnnotateAndAssertCodeBlocks.annotateAndAssertLocalVarAssignemntCall(n));
                this.mAnnotSSA.setOldVarAssignmentAtPos(n, this.mAnnotateAndAssertCodeBlocks.annotateAndAssertOldVarAssignemntCall(n));
                continue;
            }
            this.mAnnotSSA.setFormulaAtNonCallPos(n, this.mAnnotateAndAssertCodeBlocks.annotateAndAssertNonCall(n));
        }
        if (bl) {
            int n = -1 - this.mSSA.getTrace().getPendingReturns().size();
            for (Object object : this.mSSA.getTrace().getPendingReturns().keySet()) {
                assert (nestedWord.isPendingReturn(((Integer)object).intValue()));
                Term term = this.mAnnotateAndAssertCodeBlocks.annotateAndAssertPendingContext((Integer)object, n);
                this.mAnnotSSA.setPendingContext((Integer)object, term);
                term = this.mAnnotateAndAssertCodeBlocks.annotateAndAssertLocalVarAssignemntPendingContext((Integer)object, n);
                this.mAnnotSSA.setLocalVarAssignmentAtPos((Integer)object, term);
                term = this.mAnnotateAndAssertCodeBlocks.annotateAndAssertOldVarAssignemntPendingContext((Integer)object, n);
                this.mAnnotSSA.setOldVarAssignmentAtPos((Integer)object, term);
                ++n;
            }
        }
    }

    public Script.LBool isInputSatisfiable() {
        return this.mSatisfiable;
    }

    public NestedFormulas<L, Term, Term> getAnnotatedSsa() {
        return this.mAnnotSSA;
    }
}

