/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.language.settings.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsBaseProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsStorage;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.resources.IResource;

public class ReferencedProjectsLanguageSettingsProvider
extends LanguageSettingsBaseProvider {
    public static final String ID = "org.eclipse.cdt.core.ReferencedProjectsLanguageSettingsProvider";
    private final ThreadLocal<Boolean> recursiveCallIndicator = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    @Override
    public List<ICLanguageSettingEntry> getSettingEntries(ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
        if (this.recursiveCallIndicator.get().booleanValue()) {
            return null;
        }
        if (cfgDescription == null) {
            return null;
        }
        ICProjectDescription prjDescription = cfgDescription.getProjectDescription();
        if (prjDescription == null) {
            return null;
        }
        try {
            ICConfigurationDescription[] refCfgDescriptions;
            this.recursiveCallIndicator.set(true);
            ArrayList<ICLanguageSettingEntry> entries = new ArrayList<ICLanguageSettingEntry>();
            ICConfigurationDescription[] iCConfigurationDescriptionArray = refCfgDescriptions = CoreModelUtil.getReferencedConfigurationDescriptions(cfgDescription, false);
            int n = refCfgDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription refCfgDescription = iCConfigurationDescriptionArray[n2];
                List<ICLanguageSettingEntry> refEntries = LanguageSettingsManager.getSettingEntriesByKind(refCfgDescription, rc, languageId, -1);
                for (ICLanguageSettingEntry refEntry : refEntries) {
                    int flags = refEntry.getFlags();
                    if ((flags & 0x80) != 128) continue;
                    ICLanguageSettingEntry entry = CDataUtil.createEntry(refEntry, flags & 0xFFFFFF7F);
                    entries.add(entry);
                }
                ++n2;
            }
            List<ICLanguageSettingEntry> list = LanguageSettingsStorage.getPooledList(new ArrayList<ICLanguageSettingEntry>(entries));
            return list;
        }
        finally {
            this.recursiveCallIndicator.set(false);
        }
    }
}

