/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;

public abstract class OctTerm {
    protected final TermVariable mFirstVar;
    protected final TermVariable mSecondVar;
    protected final boolean mFirstNegative;
    protected final boolean mSecondNegative;
    protected final Object mValue;

    public OctTerm(Object object, TermVariable termVariable, boolean bl, TermVariable termVariable2, boolean bl2) {
        this.mValue = object;
        this.mFirstVar = termVariable;
        this.mFirstNegative = bl;
        this.mSecondVar = termVariable2;
        this.mSecondNegative = bl2;
    }

    public OctTerm(Object object, TermVariable termVariable, boolean bl) {
        this.mValue = object;
        this.mFirstVar = termVariable;
        this.mFirstNegative = bl;
        this.mSecondVar = termVariable;
        this.mSecondNegative = bl;
    }

    public Term toTerm(Script script) {
        Term term = this.leftTerm(script);
        Term term2 = this.rightTerm(script);
        return script.term("<=", new Term[]{term, term2});
    }

    protected Term leftTerm(Script script) {
        if (this.isOneVar()) {
            return script.term("*", new Term[]{this.isFirstNegative() ? SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.valueOf(-2L)) : SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.valueOf(2L)), this.mFirstVar});
        }
        return script.term("+", new Term[]{this.isFirstNegative() ? script.term("*", new Term[]{script.decimal("-1"), this.mFirstVar}) : this.mFirstVar, this.isSecondNegative() ? script.term("*", new Term[]{script.decimal("-1"), this.mSecondVar}) : this.mSecondVar});
    }

    protected abstract Term rightTerm(Script var1);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isOneVar()) {
            stringBuilder.append((this.isFirstNegative() ? "-" : "") + "2*" + this.mFirstVar.toString());
        } else {
            stringBuilder.append((this.isFirstNegative() ? "-" : "") + this.mFirstVar.toString() + " + " + (this.isSecondNegative() ? "-" : "") + this.mSecondVar.toString());
        }
        stringBuilder.append(" <= ");
        stringBuilder.append(this.rightString());
        return stringBuilder.toString();
    }

    protected abstract String rightString();

    public abstract Object getValue();

    public boolean isOneVar() {
        return this.mFirstNegative == this.mSecondNegative && this.mFirstVar == this.mSecondVar;
    }

    public TermVariable getFirstVar() {
        return this.mFirstVar;
    }

    public TermVariable getSecondVar() {
        return this.mSecondVar;
    }

    public boolean isFirstNegative() {
        return this.mFirstNegative;
    }

    public boolean isSecondNegative() {
        return this.mSecondNegative;
    }
}

