/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.Payload;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ConcurrencyInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.RootEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.RootNode;
import de.uni_freiburg.informatik.ultimate.util.datastructures.SerialProvider;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class BoogieIcfgContainer
extends ModernAnnotations
implements IIcfg<BoogieIcfgLocation> {
    private static final long serialVersionUID = -221145005712480077L;
    private static final boolean PREPEND_CLASSNAME_TO_IDENTIFIER = false;
    private static final String KEY = BoogieIcfgContainer.class.getName();
    private final BoogieDeclarations mBoogieDeclarations;
    private final Map<String, BoogieIcfgLocation> mEntryNodes = new LinkedHashMap<String, BoogieIcfgLocation>();
    private final Map<String, BoogieIcfgLocation> mExitNode = new LinkedHashMap<String, BoogieIcfgLocation>();
    private final Set<BoogieIcfgLocation> mLoopLocations;
    private final Set<BoogieIcfgLocation> mLocationsOfInterest;
    private final Map<String, Set<BoogieIcfgLocation>> mErrorNodes;
    private final Map<String, Map<DebugIdentifier, BoogieIcfgLocation>> mLocNodes;
    public final Map<String, BoogieIcfgLocation> mFinalNode = new LinkedHashMap<String, BoogieIcfgLocation>();
    private final Boogie2SMT mBoogie2SMT;
    private final CodeBlockFactory mCodeBlockFactory;
    private final CfgSmtToolkit mCfgSmtToolkit;
    private final IPayload mPayload;
    private final Set<BoogieIcfgLocation> mInitialNodes;

    public BoogieIcfgContainer(IUltimateServiceProvider iUltimateServiceProvider, BoogieDeclarations boogieDeclarations, Boogie2SMT boogie2SMT, ConcurrencyInformation concurrencyInformation) {
        this.mLocNodes = new LinkedHashMap<String, Map<DebugIdentifier, BoogieIcfgLocation>>();
        this.mErrorNodes = new LinkedHashMap<String, Set<BoogieIcfgLocation>>();
        this.mLoopLocations = new LinkedHashSet<BoogieIcfgLocation>();
        this.mLocationsOfInterest = new LinkedHashSet<BoogieIcfgLocation>();
        this.mInitialNodes = new LinkedHashSet<BoogieIcfgLocation>();
        this.mBoogieDeclarations = boogieDeclarations;
        this.mBoogie2SMT = boogie2SMT;
        ManagedScript managedScript = boogie2SMT.getManagedScript();
        LinkedHashSet linkedHashSet = new LinkedHashSet(boogieDeclarations.getProcImplementation().keySet());
        linkedHashSet.addAll(boogieDeclarations.getProcSpecification().keySet());
        SerialProvider serialProvider = new SerialProvider();
        this.mCfgSmtToolkit = new CfgSmtToolkit(new ModifiableGlobalsTable(boogie2SMT.getBoogie2SmtSymbolTable().constructProc2ModifiableGlobalsMapping()), managedScript, (IIcfgSymbolTable)boogie2SMT.getBoogie2SmtSymbolTable(), linkedHashSet, boogie2SMT.getBoogie2SmtSymbolTable().getProc2InParams(), boogie2SMT.getBoogie2SmtSymbolTable().getProc2OutParams(), new IcfgEdgeFactory(serialProvider), concurrencyInformation, this.mBoogie2SMT.getSmtFunctionsAndAxioms());
        this.mCodeBlockFactory = new CodeBlockFactory(iUltimateServiceProvider, managedScript, this.mCfgSmtToolkit, (IIcfgSymbolTable)this.mBoogie2SMT.getBoogie2SmtSymbolTable(), serialProvider);
        this.mPayload = new Payload();
        this.mPayload.getAnnotations().put(KEY, this);
    }

    @Visualizable
    public Map<String, Map<DebugIdentifier, BoogieIcfgLocation>> getProgramPoints() {
        return this.mLocNodes;
    }

    public int getNumberOfProgramPoints() {
        int n = 0;
        for (String string : this.getProgramPoints().keySet()) {
            n += this.getProgramPoints().get(string).size();
        }
        return n;
    }

    public Map<String, BoogieIcfgLocation> getProcedureEntryNodes() {
        return this.mEntryNodes;
    }

    public Map<String, BoogieIcfgLocation> getProcedureExitNodes() {
        return this.mExitNode;
    }

    public Map<String, Set<BoogieIcfgLocation>> getProcedureErrorNodes() {
        return this.mErrorNodes;
    }

    public int getNumberOfErrorNodes() {
        int n = 0;
        for (String string : this.getProcedureErrorNodes().keySet()) {
            n += this.getProcedureErrorNodes().get(string).size();
        }
        return n;
    }

    public Boogie2SMT getBoogie2SMT() {
        return this.mBoogie2SMT;
    }

    @Visualizable
    public Set<BoogieIcfgLocation> getLoopLocations() {
        return this.mLoopLocations;
    }

    @Visualizable
    public Set<BoogieIcfgLocation> getLocationsOfInterest() {
        return this.mLocationsOfInterest;
    }

    public BoogieDeclarations getBoogieDeclarations() {
        return this.mBoogieDeclarations;
    }

    public CodeBlockFactory getCodeBlockFactory() {
        return this.mCodeBlockFactory;
    }

    public CfgSmtToolkit getCfgSmtToolkit() {
        return this.mCfgSmtToolkit;
    }

    public IPayload getPayload() {
        return this.mPayload;
    }

    public boolean hasPayload() {
        return true;
    }

    public String getFilename() {
        String string = ILocation.getAnnotation((IElement)this).getFileName();
        return new File(string).getName();
    }

    public static Collection<IcfgEdge> extractStartEdges(BoogieIcfgContainer boogieIcfgContainer) {
        return IcfgUtils.extractStartEdges((IIcfg)boogieIcfgContainer);
    }

    @Deprecated
    public RootNode constructRootNode() {
        RootNode rootNode = new RootNode(ILocation.getAnnotation((IElement)this), this);
        for (Map.Entry<String, BoogieIcfgLocation> entry : this.getProcedureEntryNodes().entrySet()) {
            new RootEdge(rootNode, entry.getValue());
        }
        return rootNode;
    }

    public String getIdentifier() {
        return this.getFilename();
    }

    public Set<BoogieIcfgLocation> getInitialNodes() {
        return this.mInitialNodes;
    }

    public Class<BoogieIcfgLocation> getLocationClass() {
        return BoogieIcfgLocation.class;
    }

    public static BoogieIcfgContainer getAnnotation(IElement iElement) {
        return (BoogieIcfgContainer)ModelUtils.getAnnotation((IElement)iElement, (String)KEY, iAnnotations -> (BoogieIcfgContainer)((Object)iAnnotations));
    }

    public String toString() {
        return this.graphStructureToString();
    }
}

