/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.pea.RelationDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.Transition;
import de.uni_freiburg.informatik.ultimate.lib.pea.ZDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.TCSWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.czt.z.util.ZString;

public final class PEA2TCSConverter {
    public static final String REAL_TYPE = "\u211d";
    public static final String LEN = "len";
    private CDD clockConstraintForCurrentTrans;
    private final List<String> clocks;
    private Transition currentTransition;
    private Iterator<CDD> disjunctIterator;
    private CDD initClockConstraint;
    private Iterator<CDD> initDisjunctIterator;
    private int initPhaseCounter;
    private final List<Phase> initPhases;
    private final PhaseEventAutomata pea;
    private int phaseCounter;
    private final List<Phase> phases;
    private final TCSWriter tcsWriter;
    private Iterator<Transition> transitionIterator;
    private final Map<String, String> variables;
    private boolean useBooleanDecision = false;
    private final CDD lenConstraint;
    private final Map<String, CDD> clockUpdatesReset;
    private final Map<String, CDD> clockUpdates;
    private final Map<String, CDD> stoppedClockUpdatesReset;
    private final Map<String, CDD> stoppedClockUpdates;
    private CDD globalInvariant = CDD.TRUE;

    public PEA2TCSConverter(TCSWriter tCSWriter, PhaseEventAutomata phaseEventAutomata) {
        this.tcsWriter = tCSWriter;
        this.tcsWriter.setConverter(this);
        this.pea = phaseEventAutomata;
        this.phases = phaseEventAutomata.getPhases();
        this.initPhases = phaseEventAutomata.getInit();
        this.clocks = phaseEventAutomata.getClocks();
        this.variables = phaseEventAutomata.getVariables();
        if (phaseEventAutomata.getPhases().size() == 0) {
            throw new RuntimeException("PEA with phase count = 0 is not allowed");
        }
        if (phaseEventAutomata.getInit().size() == 0) {
            throw new RuntimeException("PEA with initial phase count = 0 is not allowed");
        }
        this.globalInvariant = this.tcsWriter.processDeclarations(phaseEventAutomata.getDeclarations(), this.variables);
        this.variables.put(LEN, REAL_TYPE);
        for (String string : this.clocks) {
            this.variables.put(string, REAL_TYPE);
        }
        if (this.phases.size() > 1) {
            this.variables.put("pc", ZString.NUM);
        }
        this.initClockConstraint = this.useBooleanDecision ? RelationDecision.create("0", RelationDecision.Operator.LESS, LEN) : ZDecision.create("len>0");
        for (String string : this.clocks) {
            CDD cDD = this.useBooleanDecision ? RelationDecision.create(string, RelationDecision.Operator.EQUALS, LEN) : ZDecision.create(string + ZString.EQUALS + LEN);
            this.initClockConstraint = this.initClockConstraint.and(cDD);
        }
        this.lenConstraint = this.useBooleanDecision ? RelationDecision.create("0", RelationDecision.Operator.LESS, LEN + String.valueOf((Object)RelationDecision.Operator.PRIME)) : ZDecision.create(LEN + ZString.PRIME + ZString.GREATER + "0");
        this.clockUpdatesReset = new HashMap<String, CDD>();
        this.clockUpdates = new HashMap<String, CDD>();
        this.stoppedClockUpdatesReset = new HashMap<String, CDD>();
        this.stoppedClockUpdates = new HashMap<String, CDD>();
        if (this.useBooleanDecision) {
            for (String string : this.clocks) {
                this.clockUpdatesReset.put(string, RelationDecision.create(string + String.valueOf((Object)RelationDecision.Operator.PRIME), RelationDecision.Operator.EQUALS, LEN + String.valueOf((Object)RelationDecision.Operator.PRIME)));
                this.clockUpdates.put(string, RelationDecision.create(string + String.valueOf((Object)RelationDecision.Operator.PRIME), RelationDecision.Operator.EQUALS, string + String.valueOf((Object)RelationDecision.Operator.PLUS) + LEN + String.valueOf((Object)RelationDecision.Operator.PRIME)));
                this.stoppedClockUpdatesReset.put(string, RelationDecision.create(string + String.valueOf((Object)RelationDecision.Operator.PRIME), RelationDecision.Operator.EQUALS, "0"));
                this.stoppedClockUpdates.put(string, RelationDecision.create(string + String.valueOf((Object)RelationDecision.Operator.PRIME), RelationDecision.Operator.EQUALS, string));
            }
        } else {
            for (String string : this.clocks) {
                this.clockUpdatesReset.put(string, ZDecision.create(string + ZString.PRIME + ZString.EQUALS + LEN + ZString.PRIME));
                this.clockUpdates.put(string, ZDecision.create(string + ZString.PRIME + ZString.EQUALS + string + ZString.PLUS + LEN + ZString.PRIME));
                this.stoppedClockUpdatesReset.put(string, ZDecision.create(string + ZString.PRIME + ZString.EQUALS + "0"));
                this.stoppedClockUpdates.put(string, ZDecision.create(string + ZString.PRIME + ZString.EQUALS + string));
            }
        }
    }

    public void convert() {
        this.phaseCounter = -1;
        this.chooseNextTransition();
        this.initPhaseCounter = -1;
        this.chooseNextInitPhase();
        this.tcsWriter.write();
    }

    private boolean chooseNextInitPhase() {
        if (++this.initPhaseCounter >= this.initPhases.size()) {
            return false;
        }
        CDD cDD = this.initPhases.get(this.initPhaseCounter).getStateInvariant().and(this.globalInvariant);
        CDD cDD2 = this.initPhases.get(this.initPhaseCounter).getClockInvariant();
        CDD[] cDDArray = cDD.and(cDD2).toDNF();
        this.initDisjunctIterator = Arrays.asList(cDDArray).iterator();
        return true;
    }

    private boolean chooseNextTransition() {
        CDD cDD;
        CDD cDD2;
        Object object;
        while (this.transitionIterator == null || !this.transitionIterator.hasNext()) {
            if (++this.phaseCounter >= this.phases.size()) {
                return false;
            }
            object = this.phases.get(this.phaseCounter).getTransitions();
            this.transitionIterator = object.iterator();
        }
        this.currentTransition = this.transitionIterator.next();
        object = this.currentTransition.getGuard();
        if (object == CDD.FALSE) {
            return this.chooseNextTransition();
        }
        CDD[] cDDArray = ((CDD)object).toDNF();
        CDD cDD3 = this.currentTransition.getDest().getStateInvariant().and(this.globalInvariant);
        CDD cDD4 = this.currentTransition.getDest().getClockInvariant();
        CDD[] cDDArray2 = cDD3.and(cDD4).toDNF();
        ArrayList<CDD> arrayList = new ArrayList<CDD>();
        CDD[] cDDArray3 = cDDArray;
        int n = cDDArray.length;
        int n2 = 0;
        while (n2 < n) {
            cDD2 = cDDArray3[n2];
            CDD[] cDDArray4 = cDDArray2;
            int n3 = cDDArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                cDD = cDDArray4[n4];
                arrayList.add(cDD2.and(cDD.prime(Collections.emptySet())));
                ++n4;
            }
            ++n2;
        }
        this.disjunctIterator = arrayList.iterator();
        cDD2 = this.lenConstraint;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.currentTransition.getResets()));
        for (String string : this.clocks) {
            cDD = hashSet.contains(string) ? (this.currentTransition.getDest().isStopped(string) ? this.stoppedClockUpdatesReset.get(string) : this.clockUpdatesReset.get(string)) : (this.currentTransition.getDest().isStopped(string) ? this.stoppedClockUpdates.get(string) : this.clockUpdates.get(string));
            cDD2 = cDD2.and(cDD);
        }
        this.clockConstraintForCurrentTrans = cDD2;
        return true;
    }

    public List<String> getDeclarations() {
        return this.pea.getDeclarations();
    }

    public String getName() {
        return this.pea.getName();
    }

    public TransitionConstraint getNextInitConstraint() {
        if (!this.initDisjunctIterator.hasNext() && !this.chooseNextInitPhase()) {
            return null;
        }
        CDD cDD = this.initDisjunctIterator.next();
        CDD cDD2 = cDD.and(this.initClockConstraint);
        String string = this.initPhases.get(this.initPhaseCounter).getName();
        return new TransitionConstraint(cDD2, string);
    }

    public TransitionConstraint getNextTransitionConstraint() {
        if (!this.disjunctIterator.hasNext()) {
            if (!this.chooseNextTransition()) {
                return null;
            }
            if (!this.disjunctIterator.hasNext()) {
                System.out.println();
            }
        }
        CDD cDD = this.disjunctIterator.next();
        CDD cDD2 = cDD.and(this.clockConstraintForCurrentTrans);
        String string = this.currentTransition.getSrc().getName();
        String string2 = this.currentTransition.getDest().getName();
        return new TransitionConstraint(cDD2, string, string2);
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public PhaseEventAutomata getPEA() {
        return this.pea;
    }

    public void useBooleanDecision() {
        this.useBooleanDecision = true;
    }

    public void useZDecision() {
        this.useBooleanDecision = false;
    }

    public static class TransitionConstraint {
        CDD constraint;
        String dest;
        String initLoc;
        String source;

        public TransitionConstraint(CDD cDD, String string) {
            this.constraint = cDD;
            this.initLoc = string;
        }

        public TransitionConstraint(CDD cDD, String string, String string2) {
            this.constraint = cDD;
            this.dest = string2;
            this.source = string;
        }

        public CDD getConstraint() {
            return this.constraint;
        }

        public String getDest() {
            return this.dest;
        }

        public String getInitLoc() {
            return this.initLoc;
        }

        public String getSource() {
            return this.source;
        }
    }
}

