/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.DawgFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgbuilders.DawgBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgletters.DawgLetter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgState;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.epr.dawgs.dawgstates.DawgStateFactory;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProjectDawgBuilder<LETTER, COLNAMES>
extends DawgBuilder<LETTER> {
    private final DawgStateFactory<LETTER> mDawgStateFactory;
    private final DawgFactory<LETTER, COLNAMES> mDawgFactory;
    private final Map<Set<DawgState<LETTER, Boolean>>, DawgState<LETTER, Boolean>> mCache;
    private final int mNumColumns;
    private final BitSet mProjectedColumns;

    public ProjectDawgBuilder(DawgFactory<LETTER, COLNAMES> dawgFactory, int n, BitSet bitSet) {
        this.mDawgFactory = dawgFactory;
        this.mDawgStateFactory = this.mDawgFactory.getDawgStateFactory();
        this.mNumColumns = n;
        this.mProjectedColumns = bitSet;
        this.mCache = new HashMap<Set<DawgState<LETTER, Boolean>>, DawgState<LETTER, Boolean>>();
    }

    private DawgState<LETTER, Boolean> projectAndJoin(Set<DawgState<LETTER, Boolean>> set, int n) {
        DawgState<LETTER, Boolean> dawgState = this.mCache.get(set);
        if (dawgState != null) {
            return dawgState;
        }
        if (n == this.mNumColumns) {
            for (DawgState<LETTER, Boolean> dawgState2 : set) {
                assert (dawgState2.isFinal());
                if (!dawgState2.getFinalValue().booleanValue()) continue;
                return dawgState2;
            }
            assert (!set.isEmpty());
            dawgState = set.iterator().next();
        } else if (this.mProjectedColumns.get(n)) {
            Map map = new HashMap();
            Object object2 = set.iterator().next().getTransitions().values().iterator().next().getSortId();
            map.put(new HashSet(), this.mDawgFactory.getDawgLetterFactory().getUniversalDawgLetter(object2));
            for (DawgState<LETTER, Boolean> dawgState2 : set) {
                for (Map.Entry<DawgState<LETTER, Boolean>, DawgLetter<LETTER>> entry : dawgState2.getTransitions().entrySet()) {
                    map = this.merge(map, entry.getKey(), entry.getValue());
                }
            }
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                DawgState<LETTER, Boolean> dawgState3 = this.projectAndJoin((Set)entry.getKey(), n + 1);
                ProjectDawgBuilder.addLetterToMap(hashMap, dawgState3, (DawgLetter)entry.getValue());
            }
            dawgState = this.mDawgStateFactory.createIntermediateState(hashMap);
        } else {
            HashSet<DawgState<LETTER, Boolean>> hashSet = new HashSet<DawgState<LETTER, Boolean>>();
            for (DawgState<LETTER, Boolean> dawgState4 : set) {
                hashSet.addAll(dawgState4.getTransitions().keySet());
            }
            dawgState = this.projectAndJoin(hashSet, n + 1);
        }
        this.mCache.put(set, dawgState);
        return dawgState;
    }

    public final DawgState<LETTER, Boolean> project(DawgState<LETTER, Boolean> dawgState) {
        return this.projectAndJoin(Collections.singleton(dawgState), 0);
    }
}

