/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.DeterminizedState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import java.util.Set;

public class PowersetDeterminizer<LETTER, STATE>
implements IStateDeterminizer<LETTER, STATE> {
    private final IDeterminizeStateFactory<STATE> mStateFactory;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final boolean mUseDoubleDeckers;
    private int mMaxDegreeOfNondeterminism;

    public PowersetDeterminizer(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, boolean bl, IDeterminizeStateFactory<STATE> iDeterminizeStateFactory) {
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mUseDoubleDeckers = bl;
        this.mStateFactory = iDeterminizeStateFactory;
    }

    @Override
    public DeterminizedState<LETTER, STATE> initialState() {
        DeterminizedState determinizedState = new DeterminizedState(this.mOperand);
        for (Object STATE : this.mOperand.getInitialStates()) {
            determinizedState.addPair(this.mOperand.getEmptyStackState(), STATE, this.mOperand);
        }
        this.updateMaxDegreeOfNondeterminism(determinizedState.degreeOfNondeterminism());
        return determinizedState;
    }

    @Override
    public DeterminizedState<LETTER, STATE> internalSuccessor(DeterminizedState<LETTER, STATE> determinizedState, LETTER LETTER) {
        DeterminizedState<LETTER, STATE> determinizedState2 = new DeterminizedState<LETTER, STATE>(this.mOperand);
        for (STATE STATE : determinizedState.getDownStates()) {
            for (STATE STATE2 : determinizedState.getUpStates(STATE)) {
                for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : this.mOperand.internalSuccessors(STATE2, LETTER)) {
                    determinizedState2.addPair(STATE, outgoingInternalTransition.getSucc(), this.mOperand);
                }
            }
        }
        this.updateMaxDegreeOfNondeterminism(determinizedState2.degreeOfNondeterminism());
        return determinizedState2;
    }

    @Override
    public DeterminizedState<LETTER, STATE> callSuccessor(DeterminizedState<LETTER, STATE> determinizedState, LETTER LETTER) {
        DeterminizedState<LETTER, STATE> determinizedState2 = new DeterminizedState<LETTER, STATE>(this.mOperand);
        for (STATE STATE : determinizedState.getDownStates()) {
            for (STATE STATE2 : determinizedState.getUpStates(STATE)) {
                for (OutgoingCallTransition<LETTER, STATE> outgoingCallTransition : this.mOperand.callSuccessors(STATE2, LETTER)) {
                    STATE STATE3 = this.mUseDoubleDeckers ? STATE2 : this.mOperand.getEmptyStackState();
                    determinizedState2.addPair(STATE3, outgoingCallTransition.getSucc(), this.mOperand);
                }
            }
        }
        this.updateMaxDegreeOfNondeterminism(determinizedState2.degreeOfNondeterminism());
        return determinizedState2;
    }

    @Override
    public DeterminizedState<LETTER, STATE> returnSuccessor(DeterminizedState<LETTER, STATE> determinizedState, DeterminizedState<LETTER, STATE> determinizedState2, LETTER LETTER) {
        DeterminizedState<LETTER, STATE> determinizedState3 = new DeterminizedState<LETTER, STATE>(this.mOperand);
        for (STATE STATE : determinizedState2.getDownStates()) {
            for (STATE STATE2 : determinizedState2.getUpStates(STATE)) {
                this.returnSuccessorsHelper(determinizedState, LETTER, determinizedState3, STATE, STATE2);
            }
        }
        this.updateMaxDegreeOfNondeterminism(determinizedState3.degreeOfNondeterminism());
        return determinizedState3;
    }

    private void returnSuccessorsHelper(DeterminizedState<LETTER, STATE> determinizedState, LETTER LETTER, DeterminizedState<LETTER, STATE> determinizedState2, STATE STATE, STATE STATE2) {
        Set<STATE> set;
        if (this.mUseDoubleDeckers) {
            set = determinizedState.getUpStates(STATE2);
            if (set == null) {
                return;
            }
        } else {
            assert (determinizedState.getDownStates().size() == 1);
            assert (determinizedState.getDownStates().iterator().next() == this.mOperand.getEmptyStackState());
            set = determinizedState.getUpStates(this.mOperand.getEmptyStackState());
        }
        for (STATE STATE3 : set) {
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mOperand.returnSuccessors(STATE3, STATE2, LETTER)) {
                assert (this.mUseDoubleDeckers || STATE == this.mOperand.getEmptyStackState());
                determinizedState2.addPair(STATE, outgoingReturnTransition.getSucc(), this.mOperand);
            }
        }
    }

    private void updateMaxDegreeOfNondeterminism(int n) {
        if (n > this.mMaxDegreeOfNondeterminism) {
            this.mMaxDegreeOfNondeterminism = n;
        }
    }

    @Override
    public int getMaxDegreeOfNondeterminism() {
        return this.mMaxDegreeOfNondeterminism;
    }

    @Override
    public boolean useDoubleDeckers() {
        return this.mUseDoubleDeckers;
    }

    @Override
    public STATE getState(DeterminizedState<LETTER, STATE> determinizedState) {
        return determinizedState.getContent(this.mStateFactory);
    }
}

