/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.PetriNetUtils;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.DifferencePairwiseOnDemand;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.DifferenceSynchronizationInformation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.ProjectToSubnet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.RemoveDead;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.RemoveRedundantFlow;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBlackWhiteStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Difference<LETTER, PLACE, CRSF extends IPetriNet2FiniteAutomatonStateFactory<PLACE> & INwaInclusionStateFactory<PLACE>>
extends GeneralOperation<LETTER, PLACE, CRSF> {
    private static final boolean FULL_SELFLOOP_INFORMATION_OPTIMIZATION = false;
    private static final boolean COMPUTE_DIFFERENCE_SYNCHRONIZATION_INFORMATION_VIA_UNFOLDING = true;
    private final LoopSyncMethod mLoopSyncMethod;
    private final boolean mRemoveRedundantFlow;
    private final IPetriNet<LETTER, PLACE> mInputMinuend;
    private final IPetriNet<LETTER, PLACE> mMinuend;
    private final INestedWordAutomaton<LETTER, PLACE> mSubtrahend;
    private final IBlackWhiteStateFactory<PLACE> mContentFactory;
    private BoundedPetriNet<LETTER, PLACE> mResult;
    private final DifferenceSynchronizationInformation<LETTER, PLACE> mDsi;
    private final Map<PLACE, PLACE> mWhitePlace = new HashMap<PLACE, PLACE>();
    private final Map<PLACE, PLACE> mBlackPlace = new HashMap<PLACE, PLACE>();

    public Difference(AutomataLibraryServices automataLibraryServices, IBlackWhiteStateFactory<PLACE> iBlackWhiteStateFactory, IPetriNet<LETTER, PLACE> iPetriNet, INestedWordAutomaton<LETTER, PLACE> iNestedWordAutomaton) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        this(automataLibraryServices, iBlackWhiteStateFactory, iPetriNet, iNestedWordAutomaton, LoopSyncMethod.HEURISTIC, null, false);
    }

    public Difference(AutomataLibraryServices automataLibraryServices, IBlackWhiteStateFactory<PLACE> iBlackWhiteStateFactory, IPetriNet<LETTER, PLACE> iPetriNet, INestedWordAutomaton<LETTER, PLACE> iNestedWordAutomaton, String string) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        this(automataLibraryServices, iBlackWhiteStateFactory, iPetriNet, iNestedWordAutomaton, LoopSyncMethod.valueOf(string), null, false);
    }

    public Difference(AutomataLibraryServices automataLibraryServices, IBlackWhiteStateFactory<PLACE> iBlackWhiteStateFactory, IPetriNet<LETTER, PLACE> iPetriNet, INestedWordAutomaton<LETTER, PLACE> iNestedWordAutomaton, LoopSyncMethod loopSyncMethod, DifferencePairwiseOnDemand<LETTER, PLACE, ?> differencePairwiseOnDemand, boolean bl) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        super(automataLibraryServices);
        this.mSubtrahend = iNestedWordAutomaton;
        this.mContentFactory = iBlackWhiteStateFactory;
        this.mLoopSyncMethod = loopSyncMethod;
        this.mInputMinuend = iPetriNet;
        this.mRemoveRedundantFlow = bl;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        assert (this.checkSubtrahendProperties());
        DifferencePairwiseOnDemand<LETTER, PLACE, Object> differencePairwiseOnDemand2 = differencePairwiseOnDemand == null ? new DifferencePairwiseOnDemand(this.mServices, iPetriNet, iNestedWordAutomaton) : differencePairwiseOnDemand;
        if (this.mRemoveRedundantFlow) {
            RemoveRedundantFlow removeRedundantFlow = new RemoveRedundantFlow(this.mServices, differencePairwiseOnDemand2.getResult(), differencePairwiseOnDemand2.getFinitePrefixOfDifference().getResult(), this.mInputMinuend.getPlaces(), this.mInputMinuend.getPlaces());
            ProjectToSubnet projectToSubnet = new ProjectToSubnet(automataLibraryServices, removeRedundantFlow.getResult(), new HashRelation(), this.mSubtrahend.getStates());
            this.mMinuend = projectToSubnet.getResult();
            HashRelation hashRelation = new HashRelation();
            for (Map.Entry<Transition<LETTER, PLACE>, Transition<LETTER, PLACE>> entry : differencePairwiseOnDemand2.getTransitionBacktranslation().entrySet()) {
                Transition<LETTER, PLACE> transition = entry.getKey();
                assert (transition != null);
                hashRelation.addPair(entry.getValue(), (Object)transition);
            }
            HashMap hashMap = new HashMap();
            for (Map.Entry entry : removeRedundantFlow.getOld2projected().entrySet()) {
                Transition transition = (Transition)entry.getKey();
                Transition transition2 = (Transition)entry.getValue();
                assert (transition2 != null);
                Transition transition3 = projectToSubnet.getTransitionMapping().get(transition2);
                assert (transition3 != null);
                hashMap.put(transition, transition3);
            }
            this.mDsi = differencePairwiseOnDemand2.getDifferenceSynchronizationInformation().transformThroughRemoveRedundantFlow(hashRelation, hashMap, removeRedundantFlow.getRedundantSelfloopFlow(), removeRedundantFlow.getRedundantPlaces());
        } else {
            this.mMinuend = iPetriNet;
            this.mDsi = differencePairwiseOnDemand2.getDifferenceSynchronizationInformation();
        }
        assert (this.mDsi.isCompatible(this.mMinuend)) : "incompatible DSI";
        this.copyNetPlaces();
        this.addBlackAndWhitePlaces();
        this.addTransitions();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private boolean checkSubtrahendProperties() {
        if (!NestedWordAutomataUtils.isFiniteAutomaton(this.mSubtrahend)) {
            throw new IllegalArgumentException("subtrahend must be a finite automaton");
        }
        if (!IAutomaton.sameAlphabet(this.mInputMinuend, this.mSubtrahend)) {
            throw new IllegalArgumentException("minuend and subtrahend must use same alphabet");
        }
        if (this.mSubtrahend.getInitialStates().size() != 1) {
            throw new IllegalArgumentException("subtrahend must have exactly one inital state");
        }
        return true;
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + ". First operand " + this.mInputMinuend.sizeInformation() + ". Second operand " + this.mSubtrahend.sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult.sizeInformation();
    }

    private void partitionStates() {
        for (Transition<LETTER, PLACE> transition2 : this.mMinuend.getTransitions()) {
            HashSet<PLACE> hashSet = new HashSet<PLACE>();
            HashSet<PLACE> hashSet2 = new HashSet<PLACE>();
            for (PLACE PLACE : this.mSubtrahend.getStates()) {
                OutgoingInternalTransition<LETTER, PLACE> outgoingInternalTransition;
                if (this.mSubtrahend.isFinal(PLACE) || (outgoingInternalTransition = Difference.atMostOneElement(this.mSubtrahend.internalSuccessors(PLACE, transition2.getSymbol()))) == null) continue;
                if (outgoingInternalTransition.getSucc().equals(PLACE)) {
                    hashSet.add(PLACE);
                    continue;
                }
                hashSet2.add(PLACE);
            }
            this.mDsi.getSelfloops().addAllPairs(transition2, hashSet);
            this.mDsi.getStateChangers().addAllPairs(transition2, hashSet2);
            if (!this.mLogger.isDebugEnabled()) continue;
            this.mLogger.debug((Object)(String.valueOf(transition2) + " has " + hashSet.size() + " selfloop and " + hashSet2.size() + " changer(s)"));
        }
        int n = (int)this.mDsi.getStateChangers().getDomain().stream().filter(transition -> !this.mDsi.getStateChangers().getImage(transition).isEmpty()).count();
        this.mLogger.info((Object)(this.mMinuend.getAlphabet().size() - n + " loopers, " + n + " changers"));
    }

    private void copyNetPlaces() {
        this.mResult = new BoundedPetriNet(this.mServices, this.mMinuend.getAlphabet(), false);
        boolean bl = this.isInitialStateFinal();
        for (PLACE PLACE : this.mMinuend.getPlaces()) {
            boolean bl2;
            boolean bl3;
            boolean bl4 = this.mResult.addPlace(PLACE, bl3 = !bl && this.mMinuend.getInitialPlaces().contains(PLACE), bl2 = this.mMinuend.getAcceptingPlaces().contains(PLACE));
            if (!bl4) {
                throw new AssertionError((Object)("Must not add place twice: " + String.valueOf(PLACE)));
            }
        }
    }

    private boolean isInitialStateFinal() {
        Iterator iterator = this.mSubtrahend.getInitialStates().iterator();
        if (!iterator.hasNext()) {
            throw new UnsupportedOperationException("Subtrahend has no initial states! We could soundly return the minuend as result (implement this if required). However we presume that in most cases, such a subtrahend was passed accidentally");
        }
        Object e = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalArgumentException("subtrahend not deterministic");
        }
        return this.mSubtrahend.isFinal(e);
    }

    private boolean invertSyncWithSelfloops(Transition<LETTER, PLACE> transition) {
        return this.mLoopSyncMethod == LoopSyncMethod.INVERTED || this.mLoopSyncMethod == LoopSyncMethod.HEURISTIC && this.mDsi.getSelfloops().getImage(transition).size() >= this.mDsi.getStateChangers().getImage(transition).size() || this.mLoopSyncMethod == LoopSyncMethod.PAIRWISE && !this.mDsi.getChangerLetters().contains(transition.getSymbol());
    }

    private Set<PLACE> requiredBlackPlaces() {
        HashSet hashSet = new HashSet();
        for (Transition<LETTER, PLACE> transition : this.mDsi.getContributingTransitions()) {
            if (!this.invertSyncWithSelfloops(transition)) continue;
            hashSet.addAll(this.mDsi.getStateChangers().getImage(transition));
            hashSet.addAll(this.mDsi.getBlockingTransitions().getImage(transition));
        }
        return hashSet;
    }

    private void addBlackAndWhitePlaces() {
        boolean bl;
        PLACE PLACE;
        boolean bl2;
        for (PLACE PLACE2 : this.mSubtrahend.getStates()) {
            if (this.mSubtrahend.isFinal(PLACE2)) continue;
            bl2 = this.mSubtrahend.getInitialStates().contains(PLACE2);
            PLACE = this.mContentFactory.getWhiteContent(PLACE2);
            bl = this.mResult.addPlace(PLACE, bl2, false);
            if (!bl) {
                throw new UnsupportedOperationException("Cannot add place " + String.valueOf(PLACE) + " maybe you have to rename your input.");
            }
            this.mWhitePlace.put(PLACE2, PLACE);
        }
        for (PLACE PLACE2 : this.requiredBlackPlaces()) {
            bl2 = this.mSubtrahend.getInitialStates().contains(PLACE2);
            PLACE = this.mContentFactory.getBlackContent(PLACE2);
            bl = this.mResult.addPlace(PLACE, !bl2, false);
            if (!bl) {
                throw new UnsupportedOperationException("Cannot add place " + String.valueOf(PLACE) + " maybe you have to rename your input.");
            }
            this.mBlackPlace.put(PLACE2, PLACE);
        }
    }

    private void addTransitions() {
        for (Transition<LETTER, PLACE> transition : this.mDsi.getContributingTransitions()) {
            assert (this.mMinuend.getTransitions().contains(transition)) : "unknown transition " + String.valueOf(transition);
            for (Object e : this.mDsi.getStateChangers().getImage(transition)) {
                this.syncWithChanger(transition, e);
            }
            this.syncWithSelfloops(transition);
        }
    }

    private void syncWithChanger(Transition<LETTER, PLACE> transition, PLACE PLACE) {
        PLACE PLACE2 = Difference.onlyElement(this.mSubtrahend.internalSuccessors(PLACE, transition.getSymbol())).getSucc();
        assert (!PLACE.equals(PLACE2)) : "changer requires that pred and succ are different";
        if (this.mSubtrahend.isFinal(PLACE2)) {
            return;
        }
        HashSet<PLACE> hashSet = new HashSet<PLACE>();
        HashSet<PLACE> hashSet2 = new HashSet<PLACE>();
        hashSet.add(this.mWhitePlace.get(PLACE));
        hashSet2.add(this.mWhitePlace.get(PLACE2));
        PLACE PLACE3 = this.mBlackPlace.get(PLACE2);
        PLACE PLACE4 = this.mBlackPlace.get(PLACE);
        if (PLACE3 != null) {
            hashSet.add(PLACE3);
        }
        if (PLACE4 != null) {
            hashSet2.add(PLACE4);
        }
        hashSet.addAll((Collection<PLACE>)transition.getPredecessors());
        hashSet2.addAll((Collection<PLACE>)transition.getSuccessors());
        this.mResult.addTransition(transition.getSymbol(), ImmutableSet.of(hashSet), ImmutableSet.of(hashSet2));
    }

    private void syncWithSelfloops(Transition<LETTER, PLACE> transition) {
        if (this.invertSyncWithSelfloops(transition)) {
            if (!this.mDsi.getSelfloops().getImage(transition).isEmpty() || !this.mDsi.getChangerLetters().contains(transition.getSymbol())) {
                this.syncWithAnySelfloop(transition);
            }
        } else {
            this.syncWithEachSelfloop(transition);
        }
    }

    private void syncWithEachSelfloop(Transition<LETTER, PLACE> transition) {
        for (Object e : this.mDsi.getSelfloops().getImage(transition)) {
            PLACE PLACE = this.mWhitePlace.get(e);
            if (PLACE == null) {
                throw new AssertionError((Object)("No black place for " + String.valueOf(e)));
            }
            HashSet<PLACE> hashSet = new HashSet<PLACE>();
            HashSet<PLACE> hashSet2 = new HashSet<PLACE>();
            hashSet.add(PLACE);
            hashSet.addAll((Collection<PLACE>)transition.getPredecessors());
            hashSet2.add(PLACE);
            hashSet2.addAll((Collection<PLACE>)transition.getSuccessors());
            this.mResult.addTransition(transition.getSymbol(), ImmutableSet.of(hashSet), ImmutableSet.of(hashSet2));
        }
    }

    private void syncWithAnySelfloop(Transition<LETTER, PLACE> transition) {
        HashSet<PLACE> hashSet = new HashSet<PLACE>(transition.getPredecessors());
        HashSet<PLACE> hashSet2 = new HashSet<PLACE>(transition.getSuccessors());
        for (Object t : Stream.concat(this.mDsi.getStateChangers().getImage(transition).stream(), this.mDsi.getBlockingTransitions().getImage(transition).stream()).collect(Collectors.toList())) {
            PLACE PLACE = this.mBlackPlace.get(t);
            if (PLACE == null) {
                throw new AssertionError((Object)("No black place for " + String.valueOf(t)));
            }
            hashSet.add(PLACE);
            hashSet2.add(PLACE);
        }
        this.mResult.addTransition(transition.getSymbol(), ImmutableSet.of(hashSet), ImmutableSet.of(hashSet2));
    }

    @Override
    public BoundedPetriNet<LETTER, PLACE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        boolean bl;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Testing correctness of " + this.getOperationName()));
        }
        if (bl = PetriNetUtils.doDifferenceLanguageCheck(this.mServices, CRSF, this.mMinuend, this.mSubtrahend, this.mResult)) {
            int n;
            int n2;
            if (this.mDsi.isReachabilityPreserved() && (n2 = Difference.computeNumberOfUnreachableTransitions(this.mMinuend, this.mServices)) == 0 && (n = Difference.computeNumberOfUnreachableTransitions(this.mResult, this.mServices)) != 0) {
                bl = false;
                throw new AssertionError((Object)("removed transitions: " + n + "result has " + this.mResult.getTransitions().size()));
            }
            if (this.mDsi.isVitalityPreserved() && (n2 = Difference.computeNumberOfDeadTransitions(this.mMinuend, this.mServices)) == 0 && (n = Difference.computeNumberOfDeadTransitions(this.mResult, this.mServices)) != 0) {
                bl = false;
                throw new AssertionError((Object)("removed transitions: " + n + "result has " + this.mResult.getTransitions().size()));
            }
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl;
    }

    private static <LETTER, PLACE> int computeNumberOfDeadTransitions(IPetriNet<LETTER, PLACE> iPetriNet, AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        int n = iPetriNet.getTransitions().size();
        Object object = new RemoveDead(automataLibraryServices, iPetriNet).getResult();
        int n2 = ((BoundedPetriNet)object).getTransitions().size();
        int n3 = n - n2;
        return n3;
    }

    private static <LETTER, PLACE> int computeNumberOfUnreachableTransitions(IPetriNet<LETTER, PLACE> iPetriNet, AutomataLibraryServices automataLibraryServices) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        int n = iPetriNet.getTransitions().size();
        Object object = new RemoveUnreachable(automataLibraryServices, iPetriNet).getResult();
        int n2 = object.getTransitions().size();
        int n3 = n - n2;
        return n3;
    }

    private static <E> E onlyElement(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        assert (iterator.hasNext()) : "Expected one element, found none.";
        E e = iterator.next();
        assert (!iterator.hasNext()) : "Expected one element, found more.";
        return e;
    }

    private static <E> E atMostOneElement(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        E e = iterator.next();
        if (iterator.hasNext()) {
            throw new AssertionError((Object)"Expected at most one element, found more, probably the second arguement of the difference operation is not deterministic.");
        }
        return e;
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        int n = 0;
        int n2 = 0;
        for (Transition<LETTER, PLACE> object2 : this.mMinuend.getTransitions()) {
            Set set = this.mDsi.getSelfloops().getImage(object2);
            Set set2 = this.mDsi.getStateChangers().getImage(object2);
            if (set2 == null || set2.isEmpty()) {
                ++n;
            }
            if (set2 == null || set2.size() <= set.size()) continue;
            ++n2;
        }
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_ALPHABET, this.mResult.getAlphabet().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_PLACES, this.mResult.getPlaces().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_TRANSITIONS, this.mResult.getTransitions().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_FLOW, this.mResult.flowSize());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_DIFFERENCE_MINUEND_PLACES, this.mMinuend.getPlaces().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_DIFFERENCE_MINUEND_TRANSITIONS, this.mMinuend.getTransitions().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_DIFFERENCE_MINUEND_FLOW, this.mMinuend.flowSize());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_DIFFERENCE_SUBTRAHEND_STATES, this.mSubtrahend.getStates().size());
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_DIFFERENCE_SUBTRAHEND_LOOPER_ONLY_LETTERS, n);
        automataOperationStatistics.addKeyValuePair(StatisticsType.PETRI_DIFFERENCE_SUBTRAHEND_LETTERS_WITH_MORE_CHANGERS_THAN_LOOPERS, n2);
        return automataOperationStatistics;
    }

    public static enum LoopSyncMethod {
        PAIRWISE,
        INVERTED,
        HEURISTIC;

    }
}

