/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ITransformulaTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class IcfgTransformerSequence<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final IIcfg<OUTLOC> mResultIcfg;
    private final String mIdentifier;

    public IcfgTransformerSequence(ILogger iLogger, IIcfg<INLOC> iIcfg, ILocationFactory<INLOC, OUTLOC> iLocationFactory, ILocationFactory<OUTLOC, OUTLOC> iLocationFactory2, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, String string, List<ITransformulaTransformer> list) {
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mIdentifier = string;
        Iterator<ITransformulaTransformer> iterator = Objects.requireNonNull(list).iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("Cannot transform witout transformers");
        }
        ITransformulaTransformer iTransformulaTransformer = iterator.next();
        String string2 = this.getIdentifier(iterator, 1);
        BasicIcfg<OUTLOC> basicIcfg = IcfgTransformerSequence.transform(iLogger, iIcfg, iLocationFactory, icfgTransformationBacktranslator, clazz, string2, iTransformulaTransformer);
        this.mResultIcfg = this.transformRest(basicIcfg, iLocationFactory2, icfgTransformationBacktranslator, clazz, iterator);
    }

    private BasicIcfg<OUTLOC> transformRest(BasicIcfg<OUTLOC> basicIcfg, ILocationFactory<OUTLOC, OUTLOC> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUTLOC> clazz, Iterator<ITransformulaTransformer> iterator) {
        BasicIcfg<OUTLOC> basicIcfg2 = basicIcfg;
        int n = 1;
        while (iterator.hasNext()) {
            ITransformulaTransformer iTransformulaTransformer = iterator.next();
            basicIcfg2 = IcfgTransformerSequence.transform(this.mLogger, basicIcfg2, iLocationFactory, icfgTransformationBacktranslator, clazz, this.getIdentifier(iterator, ++n), iTransformulaTransformer);
        }
        return basicIcfg2;
    }

    private static <IN extends IcfgLocation, OUT extends IcfgLocation> BasicIcfg<OUT> transform(ILogger iLogger, IIcfg<IN> iIcfg, ILocationFactory<IN, OUT> iLocationFactory, IcfgTransformationBacktranslator icfgTransformationBacktranslator, Class<OUT> clazz, String string, ITransformulaTransformer iTransformulaTransformer) {
        iTransformulaTransformer.preprocessIcfg(iIcfg);
        BasicIcfg basicIcfg = new BasicIcfg(string, iIcfg.getCfgSmtToolkit(), clazz);
        TransformedIcfgBuilder<IN, OUT> transformedIcfgBuilder = new TransformedIcfgBuilder<IN, OUT>(iLogger, iLocationFactory, icfgTransformationBacktranslator, iTransformulaTransformer, iIcfg, basicIcfg);
        IcfgTransformerSequence.processLocations(iIcfg.getInitialNodes(), transformedIcfgBuilder);
        transformedIcfgBuilder.finish();
        return basicIcfg;
    }

    private static <IN extends IcfgLocation, OUT extends IcfgLocation> void processLocations(Set<IN> set, TransformedIcfgBuilder<IN, OUT> transformedIcfgBuilder) {
        ArrayDeque<IN> arrayDeque = new ArrayDeque<IN>(set);
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        while (!arrayDeque.isEmpty()) {
            IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.removeFirst();
            if (!hashSet.add(icfgLocation)) continue;
            OUT OUT = transformedIcfgBuilder.createNewLocation(icfgLocation);
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getTarget();
                arrayDeque.add(icfgLocation2);
                OUT OUT2 = transformedIcfgBuilder.createNewLocation(icfgLocation2);
                if (icfgEdge instanceof IIcfgReturnTransition) {
                    arrayList.add(new Triple(OUT, OUT2, (Object)icfgEdge));
                    continue;
                }
                transformedIcfgBuilder.createNewTransition(OUT, OUT2, icfgEdge);
            }
        }
        arrayList.forEach(triple -> {
            IcfgEdge icfgEdge = transformedIcfgBuilder.createNewTransition((IcfgLocation)triple.getFirst(), (IcfgLocation)triple.getSecond(), (IcfgEdge)triple.getThird());
        });
    }

    private String getIdentifier(Iterator<ITransformulaTransformer> iterator, int n) {
        if (iterator.hasNext()) {
            return this.mIdentifier + "_" + n;
        }
        return this.mIdentifier;
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }
}

