/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.tool;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractInterpretationResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.AbsIntResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.BackwardFixpointEngine;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.FixpointEngine;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.FixpointEngineParameters;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IFixpointEngine;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.IResultReporter;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.generic.SilentReporter;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.IcfgTransitionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RCFGLiteralCollector;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgLoopDetector;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgResultReporter;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.dataflow.DataflowDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.dataflow.DataflowState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.livevariable.LiveVariableDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.livevariable.LiveVariableState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory.SMTTheoryDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory.SMTTheoryState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.tool.initializer.FixpointEngineFutureParameterFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.tool.initializer.FixpointEngineParameterFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class AbstractInterpreter {
    private AbstractInterpreter() {
    }

    public static <STATE extends IAbstractState<STATE>> IAbstractInterpretationResult<STATE, IcfgEdge, IcfgLocation> run(IIcfg<? extends IcfgLocation> iIcfg, IProgressAwareTimer iProgressAwareTimer, IUltimateServiceProvider iUltimateServiceProvider) {
        if (iProgressAwareTimer == null) {
            throw new IllegalArgumentException("timer is null");
        }
        IcfgTransitionProvider icfgTransitionProvider = new IcfgTransitionProvider(iIcfg);
        Script script = iIcfg.getCfgSmtToolkit().getManagedScript().getScript();
        FixpointEngineParameterFactory fixpointEngineParameterFactory = new FixpointEngineParameterFactory(iIcfg, () -> new RCFGLiteralCollector(iIcfg), iUltimateServiceProvider);
        RcfgLoopDetector rcfgLoopDetector = new RcfgLoopDetector();
        FixpointEngineParameters fixpointEngineParameters = fixpointEngineParameterFactory.createParams(iProgressAwareTimer, icfgTransitionProvider, rcfgLoopDetector);
        FixpointEngine fixpointEngine = new FixpointEngine(fixpointEngineParameters);
        AbsIntResult absIntResult = fixpointEngine.run(iIcfg.getInitialNodes(), script);
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        return AbstractInterpreter.postProcessResult(iUltimateServiceProvider, iLogger, false, absIntResult, iIcfg);
    }

    public static <STATE extends IAbstractState<STATE>> IAbstractInterpretationResult<STATE, IcfgEdge, IcfgLocation> runWithoutTimeoutAndResults(IIcfg<?> iIcfg, IProgressAwareTimer iProgressAwareTimer, IUltimateServiceProvider iUltimateServiceProvider) {
        assert (iIcfg != null);
        assert (iUltimateServiceProvider != null);
        assert (iProgressAwareTimer != null);
        ILogger iLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        try {
            FixpointEngineParameters fixpointEngineParameters;
            Object object;
            FixpointEngine fixpointEngine;
            IcfgTransitionProvider icfgTransitionProvider = new IcfgTransitionProvider(iIcfg);
            Script script = iIcfg.getCfgSmtToolkit().getManagedScript().getScript();
            RcfgLoopDetector rcfgLoopDetector = new RcfgLoopDetector();
            boolean bl = iUltimateServiceProvider.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Use the RCFG-of-the-future interface");
            if (bl) {
                fixpointEngine = new FixpointEngineFutureParameterFactory(iIcfg, iUltimateServiceProvider);
                object = ((FixpointEngineFutureParameterFactory)((Object)fixpointEngine)).selectDomainFutureCfg();
                fixpointEngineParameters = ((FixpointEngineFutureParameterFactory)((Object)fixpointEngine)).createParamsFuture(iProgressAwareTimer, icfgTransitionProvider, rcfgLoopDetector, object);
            } else {
                fixpointEngine = new FixpointEngineParameterFactory(iIcfg, () -> new RCFGLiteralCollector(iIcfg), iUltimateServiceProvider);
                fixpointEngineParameters = ((FixpointEngineParameterFactory)((Object)fixpointEngine)).createParams(iProgressAwareTimer, icfgTransitionProvider, rcfgLoopDetector);
            }
            fixpointEngine = new FixpointEngine(fixpointEngineParameters);
            object = iIcfg.getInitialNodes();
            iLogger.info((Object)("Using domain " + fixpointEngineParameters.getAbstractDomain().domainDescription()));
            AbsIntResult absIntResult = fixpointEngine.run((Collection<IcfgLocation>)object, script);
            if (iLogger.isDebugEnabled()) {
                iLogger.debug((Object)"Found the following predicates:");
                AbsIntUtil.logPredicates(Collections.singletonMap(object, absIntResult.getLoc2Term()), script, arg_0 -> ((ILogger)iLogger).debug(arg_0));
            }
            return AbstractInterpreter.postProcessResult(iUltimateServiceProvider, iLogger, true, absIntResult, iIcfg);
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            iLogger.warn((Object)"Abstract interpretation ran out of time");
            return null;
        }
    }

    public static <STATE extends IAbstractState<STATE>> IAbstractInterpretationResult<STATE, IcfgEdge, IcfgLocation> runFuture(IIcfg<?> iIcfg, IProgressAwareTimer iProgressAwareTimer, IUltimateServiceProvider iUltimateServiceProvider, boolean bl, ILogger iLogger) {
        IcfgTransitionProvider icfgTransitionProvider = new IcfgTransitionProvider(iIcfg);
        RcfgLoopDetector rcfgLoopDetector = new RcfgLoopDetector();
        FixpointEngineFutureParameterFactory fixpointEngineFutureParameterFactory = new FixpointEngineFutureParameterFactory(iIcfg, iUltimateServiceProvider);
        IAbstractDomain iAbstractDomain = fixpointEngineFutureParameterFactory.selectDomainFutureCfg();
        FixpointEngineParameters fixpointEngineParameters = fixpointEngineFutureParameterFactory.createParamsFuture(iProgressAwareTimer, icfgTransitionProvider, rcfgLoopDetector, iAbstractDomain);
        Script script = iIcfg.getCfgSmtToolkit().getManagedScript().getScript();
        if (iAbstractDomain instanceof LiveVariableDomain) {
            Set<IcfgLocation> set = AbstractInterpreter.getSinks(iIcfg);
            BackwardFixpointEngine backwardFixpointEngine = new BackwardFixpointEngine(fixpointEngineParameters.setMaxParallelStates(1));
            AbsIntResult absIntResult = backwardFixpointEngine.run(set, script);
            return AbstractInterpreter.postProcessResult(iUltimateServiceProvider, iLogger, true, absIntResult, iIcfg);
        }
        Set set = iIcfg.getInitialNodes().stream().collect(Collectors.toSet());
        FixpointEngine fixpointEngine = new FixpointEngine(fixpointEngineParameters);
        AbsIntResult absIntResult = fixpointEngine.run(set, script);
        return AbstractInterpreter.postProcessResult(iUltimateServiceProvider, iLogger, bl, absIntResult, iIcfg);
    }

    public static IAbstractInterpretationResult<EqState, IcfgEdge, IcfgLocation> runFutureEqualityDomain(IIcfg<?> iIcfg, IProgressAwareTimer iProgressAwareTimer, IUltimateServiceProvider iUltimateServiceProvider, boolean bl, ILogger iLogger, Set<IProgramConst> set, List<String> list) {
        FixpointEngineParameters fixpointEngineParameters = new FixpointEngineParameters(iUltimateServiceProvider, IProgramVarOrConst.class);
        return AbstractInterpreter.runFuture(iIcfg, iUltimateServiceProvider, iLogger, bl, fixpointEngineParameters.setDomain(FixpointEngineFutureParameterFactory.createEqualityDomain(iLogger, iIcfg, iUltimateServiceProvider, set, list)).setTimer(iProgressAwareTimer), FixpointEngine::new);
    }

    public static IAbstractInterpretationResult<SMTTheoryState, IcfgEdge, IcfgLocation> runFutureSMTDomain(IIcfg<?> iIcfg, IProgressAwareTimer iProgressAwareTimer, IUltimateServiceProvider iUltimateServiceProvider, boolean bl, ILogger iLogger) {
        FixpointEngineParameters fixpointEngineParameters = new FixpointEngineParameters(iUltimateServiceProvider, IProgramVarOrConst.class);
        SMTTheoryDomain sMTTheoryDomain = new SMTTheoryDomain(iUltimateServiceProvider, iIcfg.getCfgSmtToolkit());
        return AbstractInterpreter.runFuture(iIcfg, iUltimateServiceProvider, iLogger, bl, fixpointEngineParameters.setDomain(sMTTheoryDomain).setTimer(iProgressAwareTimer), FixpointEngine::new);
    }

    public static IAbstractInterpretationResult<DataflowState<IcfgEdge>, IcfgEdge, IcfgLocation> runFutureDataflowDomain(IIcfg<?> iIcfg, IProgressAwareTimer iProgressAwareTimer, IUltimateServiceProvider iUltimateServiceProvider, boolean bl, ILogger iLogger) {
        FixpointEngineParameters fixpointEngineParameters = new FixpointEngineParameters(iUltimateServiceProvider, IProgramVarOrConst.class);
        return AbstractInterpreter.runFuture(iIcfg, iUltimateServiceProvider, iLogger, bl, fixpointEngineParameters.setDomain(new DataflowDomain(iLogger)).setTimer(iProgressAwareTimer), FixpointEngine::new);
    }

    public static IAbstractInterpretationResult<LiveVariableState<IcfgEdge>, IcfgEdge, IcfgLocation> runFutureLiveVariableDomain(IIcfg<?> iIcfg, IProgressAwareTimer iProgressAwareTimer, IUltimateServiceProvider iUltimateServiceProvider, boolean bl, ILogger iLogger) {
        FixpointEngineParameters fixpointEngineParameters = new FixpointEngineParameters(iUltimateServiceProvider, IProgramVarOrConst.class);
        return AbstractInterpreter.runFuture(iIcfg, iUltimateServiceProvider, iLogger, bl, fixpointEngineParameters.setDomain(new LiveVariableDomain(iLogger)).setTimer(iProgressAwareTimer).setMaxParallelStates(1), BackwardFixpointEngine::new);
    }

    private static <STATE extends IAbstractState<STATE>, ACTION extends IcfgEdge, LOC extends IcfgLocation> IAbstractInterpretationResult<STATE, ACTION, LOC> postProcessResult(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, boolean bl, AbsIntResult<STATE, ACTION, LOC> absIntResult, IIcfg<?> iIcfg) {
        if (absIntResult == null) {
            iLogger.error((Object)"Could not run because no initial element could be found");
            return null;
        }
        if (absIntResult.hasReachedError()) {
            iLogger.info((Object)"Some error location(s) were reachable");
        } else {
            iLogger.info((Object)"Error location(s) were unreachable");
        }
        IResultReporter<STATE, ACTION, ?> iResultReporter = AbstractInterpreter.getReporter(iUltimateServiceProvider, bl, iIcfg);
        absIntResult.getCounterexamples().forEach(iResultReporter::reportPossibleError);
        iResultReporter.reportFinished();
        iLogger.info((Object)absIntResult.getBenchmark());
        return absIntResult;
    }

    private static <STATE extends IAbstractState<STATE>> IAbstractInterpretationResult<STATE, IcfgEdge, IcfgLocation> runFuture(IIcfg<?> iIcfg, IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, boolean bl, FixpointEngineParameters<STATE, IcfgEdge, IProgramVarOrConst, IcfgLocation> fixpointEngineParameters, FixpointEngineFactory<STATE> fixpointEngineFactory) {
        IFixpointEngine<STATE, IcfgEdge, IProgramVarOrConst, IcfgLocation> iFixpointEngine;
        IcfgTransitionProvider icfgTransitionProvider = new IcfgTransitionProvider(iIcfg);
        Script script = iIcfg.getCfgSmtToolkit().getManagedScript().getScript();
        FixpointEngineFutureParameterFactory fixpointEngineFutureParameterFactory = new FixpointEngineFutureParameterFactory(iIcfg, iUltimateServiceProvider);
        RcfgLoopDetector rcfgLoopDetector = new RcfgLoopDetector();
        FixpointEngineParameters<STATE, IcfgEdge, IProgramVarOrConst, IcfgLocation> fixpointEngineParameters2 = fixpointEngineFutureParameterFactory.addDefaultParamsFuture(fixpointEngineParameters, icfgTransitionProvider, rcfgLoopDetector);
        Set<Object> set = (iFixpointEngine = fixpointEngineFactory.create(fixpointEngineParameters2)) instanceof BackwardFixpointEngine ? AbstractInterpreter.getSinks(iIcfg) : iIcfg.getInitialNodes().stream().collect(Collectors.toSet());
        AbsIntResult<STATE, IcfgEdge, IcfgLocation> absIntResult = iFixpointEngine.run(set, script);
        if (absIntResult == null) {
            iLogger.error((Object)"Could not run because no initial element could be found");
            return null;
        }
        IResultReporter iResultReporter = AbstractInterpreter.getReporter(iUltimateServiceProvider, bl, iIcfg);
        absIntResult.getCounterexamples().forEach(iResultReporter::reportPossibleError);
        iResultReporter.reportFinished();
        iLogger.info((Object)absIntResult.getBenchmark());
        return absIntResult;
    }

    private static <STATE extends IAbstractState<STATE>, LOC> IAbstractInterpretationResult<STATE, IcfgEdge, LOC> runSilently(Supplier<IAbstractInterpretationResult<STATE, IcfgEdge, LOC>> supplier, ILogger iLogger) {
        try {
            return supplier.get();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw outOfMemoryError;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            return null;
        }
        catch (Throwable throwable) {
            iLogger.fatal((Object)("Suppressed exception in AIv2: " + throwable.getMessage()));
            return null;
        }
    }

    private static <STATE extends IAbstractState<STATE>, ACTION extends IcfgEdge, LOC extends IcfgLocation> IResultReporter<STATE, ACTION, LOC> getReporter(IUltimateServiceProvider iUltimateServiceProvider, boolean bl, IIcfg<LOC> iIcfg) {
        if (bl) {
            return new SilentReporter();
        }
        return new RcfgResultReporter(iIcfg, iUltimateServiceProvider);
    }

    private static Set<IcfgLocation> getSinks(IIcfg<?> iIcfg) {
        return new IcfgLocationIterator(iIcfg).asStream().filter(icfgLocation -> icfgLocation.getOutgoingEdges().isEmpty()).collect(Collectors.toSet());
    }

    @FunctionalInterface
    private static interface FixpointEngineFactory<STATE extends IAbstractState<STATE>> {
        public IFixpointEngine<STATE, IcfgEdge, IProgramVarOrConst, IcfgLocation> create(FixpointEngineParameters<STATE, IcfgEdge, IProgramVarOrConst, IcfgLocation> var1);
    }
}

