/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.ParallelRankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.templates.RankingTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ParallelTemplate
extends RankingTemplate {
    public final int size;
    private static final String s_name_delta = "delta";
    private static final String s_name_function = "rank";
    private final Term[] mdeltas;
    private final AffineFunctionGenerator[] mfgens;

    public ParallelTemplate(int n) {
        assert (n > 1);
        assert (n <= 30);
        assert (1 << n > 0);
        this.size = n;
        this.mdeltas = new Term[this.size];
        this.mfgens = new AffineFunctionGenerator[this.size];
    }

    @Override
    protected void init() {
        int n = 0;
        while (n < this.size) {
            this.mdeltas[n] = this.newDelta(s_name_delta + n);
            this.mfgens[n] = new AffineFunctionGenerator(this.mScript, this.mVariables, s_name_function + n);
            ++n;
        }
    }

    @Override
    public String getName() {
        return this.size + "-parallel";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.size);
        stringBuilder.append("-parallel template:\n   ");
        int n = 0;
        while (n < this.size) {
            if (n > 0) {
                stringBuilder.append("/\\ ");
            }
            stringBuilder.append("delta_" + n + " > 0\n");
            ++n;
        }
        n = 0;
        while (n < this.size) {
            stringBuilder.append("/\\ f_" + n + "(x') <= f_" + n + "(x)\n");
            ++n;
        }
        n = 0;
        while (n < 1 << this.size) {
            stringBuilder.append("/\\ ( ");
            int n2 = 0;
            while (n2 < this.size) {
                if ((n & 1 << n2) == 0) {
                    stringBuilder.append("f_" + n2 + " > 0");
                } else {
                    stringBuilder.append("f_" + n2 + "(x') < f_" + n2 + "(x) - delta_" + n2);
                }
                if (n2 < this.size - 1) {
                    stringBuilder.append(" \\/ ");
                }
                ++n2;
            }
            stringBuilder.append(" )\n");
            ++n;
        }
        return stringBuilder.toString();
    }

    @Override
    public List<List<LinearInequality>> getConstraints(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        Serializable serializable;
        this.checkInitialized();
        ArrayList<List<LinearInequality>> arrayList = new ArrayList<List<LinearInequality>>();
        int n = 0;
        while (n < this.size) {
            serializable = this.mfgens[n].generate(map);
            LinearInequality linearInequality = this.mfgens[n].generate(map2);
            linearInequality.negate();
            ((LinearInequality)serializable).add(linearInequality);
            ((LinearInequality)serializable).mMotzkinCoefficient = LinearInequality.PossibleMotzkinCoefficients.ONE;
            arrayList.add(Collections.singletonList(serializable));
            ++n;
        }
        n = 0;
        while (n < 1 << this.size) {
            serializable = new ArrayList();
            int n2 = 0;
            while (n2 < this.size) {
                if ((n & 1 << n2) == 0) {
                    var7_8 = this.mfgens[n2].generate(map);
                    var7_8.setStrict(true);
                    var7_8.mMotzkinCoefficient = n2 == 0 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                    serializable.add(var7_8);
                } else {
                    var7_8 = this.mfgens[n2].generate(map);
                    LinearInequality linearInequality = this.mfgens[n2].generate(map2);
                    linearInequality.negate();
                    var7_8.add(linearInequality);
                    AffineTerm affineTerm = new AffineTerm(this.mdeltas[n2], Rational.MONE);
                    var7_8.add(affineTerm);
                    var7_8.setStrict(true);
                    var7_8.mMotzkinCoefficient = n2 == 0 ? LinearInequality.PossibleMotzkinCoefficients.ZERO_AND_ONE : LinearInequality.PossibleMotzkinCoefficients.ANYTHING;
                    serializable.add(var7_8);
                }
                ++n2;
            }
            arrayList.add((List<LinearInequality>)((Object)serializable));
            ++n;
        }
        return arrayList;
    }

    @Override
    public Collection<Term> getCoefficients() {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n = 0;
        while (n < this.size) {
            arrayList.addAll(this.mfgens[n].getCoefficients());
            arrayList.add(this.mdeltas[n]);
            ++n;
        }
        return arrayList;
    }

    @Override
    public RankingFunction extractRankingFunction(Map<Term, Rational> map) throws SMTLIBException {
        AffineFunction[] affineFunctionArray = new AffineFunction[this.size];
        int n = 0;
        while (n < this.size) {
            affineFunctionArray[n] = this.mfgens[n].extractAffineFunction(map);
            ++n;
        }
        return new ParallelRankingFunction(affineFunctionArray);
    }

    @Override
    public List<String> getAnnotations() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.size) {
            arrayList.add("rank f" + n + " is not increasing");
            ++n;
        }
        n = 0;
        while (n < 1 << this.size) {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            while (n2 < this.size) {
                if (n2 > 0) {
                    stringBuilder.append(" or ");
                }
                if ((n & 1 << n2) == 0) {
                    stringBuilder.append("rank f" + n2 + " is positive");
                } else {
                    stringBuilder.append("rank f" + n2 + " is decreasing");
                }
                ++n2;
            }
            arrayList.add(stringBuilder.toString());
            ++n;
        }
        return arrayList;
    }

    @Override
    public int getDegree() {
        assert (this.size > 0);
        return (1 << this.size) * (this.size - 1);
    }
}

