/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructConstructor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.IncorrectSyntaxException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValueFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.CheckMessageProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IMessageProvider;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class FunctionModelHelper {
    private final ExpressionTranslation mExpressionTranslation;
    private final MemoryHandler mMemoryHandler;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final TypeSizes mTypeSizes;
    private final ITypeHandler mTypeHandler;
    private final boolean mCheckMemoryLeakInMain;
    private final boolean mSvcompMemtrackCompatibilityMode;

    public FunctionModelHelper(AuxVarInfoBuilder auxVarInfoBuilder, ExpressionTranslation expressionTranslation, MemoryHandler memoryHandler, TypeSizes typeSizes, ITypeHandler iTypeHandler, boolean bl, boolean bl2) {
        this.mExpressionTranslation = expressionTranslation;
        this.mMemoryHandler = memoryHandler;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mTypeSizes = typeSizes;
        this.mTypeHandler = iTypeHandler;
        this.mCheckMemoryLeakInMain = bl;
        this.mSvcompMemtrackCompatibilityMode = bl2;
    }

    public void checkArguments(ILocation iLocation, int n, String string, IASTInitializerClause[] iASTInitializerClauseArray) {
        if (iASTInitializerClauseArray.length != n) {
            throw new IncorrectSyntaxException(iLocation, string + " is expected to have " + n + " arguments, but was called with " + iASTInitializerClauseArray.length);
        }
    }

    public Result handleByOverapproximation(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, int n, ICType iCType) {
        Object object;
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.checkArguments(iLocation, n, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        IASTInitializerClause[] iASTInitializerClauseArray2 = iASTInitializerClauseArray;
        int n2 = iASTInitializerClauseArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = iASTInitializerClauseArray2[n3];
            expressionResultBuilder.addAllExceptLrValue((ExpressionResult)iDispatcher.dispatch((IASTNode)object));
            ++n3;
        }
        object = this.constructOverapproximationForFunctionCall(iLocation, string, iCType);
        expressionResultBuilder.addAllExceptLrValue((ExpressionResult)object);
        this.mExpressionTranslation.addAssumeValueInRangeStatements(iLocation, ((ExpressionResult)object).getLrValue().getValue(), iCType, expressionResultBuilder);
        return expressionResultBuilder.setLrValue(((ExpressionResult)object).getLrValue()).build();
    }

    public ExpressionResult constructOverapproximationForFunctionCall(ILocation iLocation, String string, ICType iCType) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), iCType));
        return expressionResultBuilder.addOverapprox(new Overapprox(string, iLocation)).build();
    }

    public Result handleUnsupportedFunctionByOverapproximation(IDispatcher iDispatcher, ILocation iLocation, String string, ICType iCType) {
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        expressionResultBuilder.addStatement(ExpressionTranslation.modelUnsupportedFeature(iLocation, string));
        if (!iCType.isVoidType()) {
            AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType, SFO.AUXVAR.NONDET);
            expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
            expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), iCType));
        }
        return expressionResultBuilder.build();
    }

    public Result handleVoidFunctionBySkipAndDispatch(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, int n) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.checkArguments(iLocation, n, string, iASTInitializerClauseArray);
        ArrayList<ExpressionResult> arrayList = new ArrayList<ExpressionResult>();
        IASTInitializerClause[] iASTInitializerClauseArray2 = iASTInitializerClauseArray;
        int n2 = iASTInitializerClauseArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IASTInitializerClause iASTInitializerClause = iASTInitializerClauseArray2[n3];
            arrayList.add((ExpressionResult)iDispatcher.dispatch((IASTNode)iASTInitializerClause));
            ++n3;
        }
        return new ExpressionResultBuilder().addAllExceptLrValue(arrayList).build();
    }

    public Statement createAnnotatedAssertOrAssume(ILocation iLocation, String string, boolean bl, Spec spec, Expression expression) {
        return this.createAnnotatedAssertOrAssume(iLocation, string, bl, spec, expression, null);
    }

    public Statement createAnnotatedAssertOrAssume(ILocation iLocation, String string, boolean bl, Spec spec, Expression expression, String string2) {
        Check check;
        CheckMessageProvider checkMessageProvider;
        boolean bl2;
        boolean bl3 = bl2 = this.mCheckMemoryLeakInMain && this.mMemoryHandler.getRequiredMemoryModelFeatures().isMemoryModelInfrastructureRequired();
        if (!bl && !bl2) {
            return new AssumeStatement(iLocation, expression);
        }
        if (bl) {
            checkMessageProvider = new CheckMessageProvider();
            checkMessageProvider.registerSpecificationErrorFunctionName(string);
            checkMessageProvider.registerSpecificationErrorMessage(spec, string2);
            check = bl2 ? new Check(EnumSet.of(spec, Spec.MEMORY_NEUTRAL), (IMessageProvider)checkMessageProvider) : new Check(spec, (IMessageProvider)checkMessageProvider);
        } else {
            check = new Check(EnumSet.of(Spec.MEMORY_NEUTRAL));
        }
        checkMessageProvider = new AssertStatement(iLocation, new NamedAttribute[]{new NamedAttribute(iLocation, "reach", new Expression[]{new StringLiteral(iLocation, check.toString()), new StringLiteral(iLocation, string)})}, expression);
        check.annotate((IElement)checkMessageProvider);
        if (bl2 && this.mSvcompMemtrackCompatibilityMode) {
            new Overapprox("memtrack", iLocation).annotate((IElement)checkMessageProvider);
        }
        return checkMessageProvider;
    }

    public boolean isStringLiteral(IASTInitializerClause iASTInitializerClause) {
        return iASTInitializerClause instanceof IASTLiteralExpression && ((IASTLiteralExpression)iASTInitializerClause).getKind() == 3;
    }

    public ExpressionResult getNondetStringOrNull(ILocation iLocation) {
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.CHAR);
        CPrimitive cPrimitive2 = this.mTypeSizes.getSizeT();
        CPointer cPointer = new CPointer(cPrimitive);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPointer, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.setLrValue(new LocalLValue((LeftHandSide)auxVarInfo.getLhs(), (ICType)cPointer, null));
        AssignmentStatement assignmentStatement = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)auxVarInfo.getLhs(), (Expression)this.mExpressionTranslation.constructNullPointer(iLocation));
        AuxVarInfo auxVarInfo2 = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPrimitive2, SFO.AUXVAR.NONDET);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new HavocStatement(iLocation, new VariableLHS[]{auxVarInfo2.getLhs()}));
        arrayList.add(new AssumeStatement(iLocation, this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 9, (Expression)auxVarInfo2.getExp(), cPrimitive2, this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive2, BigInteger.ZERO), cPrimitive2)));
        arrayList.add(this.mMemoryHandler.getUltimateMemAllocCall((Expression)auxVarInfo2.getExp(), auxVarInfo.getLhs(), iLocation, MemoryHandler.MemoryArea.HEAP));
        Expression expression = this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO);
        Expression expression2 = this.mExpressionTranslation.constructArithmeticIntegerExpression(iLocation, 5, this.mExpressionTranslation.applyWraparound(iLocation, cPrimitive2, (Expression)auxVarInfo2.getExp()), cPrimitive2, this.mTypeSizes.constructLiteralForIntegerType(iLocation, cPrimitive2, BigInteger.ONE), cPrimitive2);
        StructConstructor structConstructor = MemoryHandler.constructPointerFromBaseAndOffset(MemoryHandler.getPointerBaseAddress((Expression)auxVarInfo.getExp(), iLocation), expression2, iLocation);
        arrayList.addAll(this.mMemoryHandler.getWriteCall(iLocation, LRValueFactory.constructHeapLValue(this.mTypeHandler, (Expression)structConstructor, cPrimitive, null), expression, (ICType)cPrimitive, false));
        Statement statement = StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)new WildcardExpression(iLocation), (Statement[])new Statement[]{assignmentStatement}, (Statement[])((Statement[])arrayList.toArray(Statement[]::new)));
        expressionResultBuilder.addStatement(statement);
        return expressionResultBuilder.build();
    }

    public ExpressionResult constructIntegerLiteral(ILocation iLocation, BigInteger bigInteger, CPrimitive cPrimitive) {
        return new ExpressionResult(new RValue(this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive, bigInteger), cPrimitive));
    }
}

