/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.rabin;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.rabin.IRabinAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RabinIntersection<LETTER, STATE, FACTORY extends IBuchiIntersectStateFactory<STATE>>
implements IRabinAutomaton<LETTER, STATE> {
    private static final int NUMBER_OF_COMPONENTS = 3;
    private final IRabinAutomaton<LETTER, STATE> mFirstAutomaton;
    private final IRabinAutomaton<LETTER, STATE> mSecondAutomaton;
    private final FACTORY mFactory;
    private Set<STATE> mInitialStates;
    private final HashMap<STATE, Triple<STATE, STATE, Integer>> mAutomatonMap = new HashMap();

    public RabinIntersection(IRabinAutomaton<LETTER, STATE> iRabinAutomaton, IRabinAutomaton<LETTER, STATE> iRabinAutomaton2, FACTORY FACTORY) {
        this.mFirstAutomaton = iRabinAutomaton;
        this.mSecondAutomaton = iRabinAutomaton2;
        this.mFactory = FACTORY;
    }

    @Override
    public Set<LETTER> getAlphabet() {
        assert (this.mFirstAutomaton.getAlphabet().equals(this.mSecondAutomaton.getAlphabet()));
        return this.mFirstAutomaton.getAlphabet();
    }

    @Override
    public int size() {
        return this.mFirstAutomaton.size() * this.mSecondAutomaton.size() * 3;
    }

    @Override
    public String sizeInformation() {
        return "Number of states: " + this.size() + "\nThe number of lazyly constructed reachable states may be smaller";
    }

    private Set<STATE> constructInitialStates() {
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (STATE STATE : this.mFirstAutomaton.getInitialStates()) {
            for (STATE STATE2 : this.mSecondAutomaton.getInitialStates()) {
                hashSet.add(this.getProducedState(STATE, STATE2, 0));
            }
        }
        return hashSet;
    }

    @Override
    public Set<STATE> getInitialStates() {
        if (this.mInitialStates == null) {
            this.mInitialStates = this.constructInitialStates();
        }
        return this.mInitialStates;
    }

    @Override
    public boolean isAccepting(STATE STATE) {
        return (Integer)this.mAutomatonMap.get(STATE).getThird() == 1;
    }

    @Override
    public boolean isFinite(STATE STATE) {
        Triple<STATE, STATE, Integer> triple = this.mAutomatonMap.get(STATE);
        return (Integer)triple.getThird() == 0 && (this.mFirstAutomaton.isFinite(triple.getFirst()) || this.mSecondAutomaton.isFinite(triple.getSecond()));
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> getSuccessors(STATE STATE) {
        Triple<STATE, STATE, Integer> triple = this.mAutomatonMap.get(STATE);
        return this.getComponentalSuccessors(this.mFirstAutomaton.getSuccessors(triple.getFirst()), triple.getSecond(), (Integer)triple.getThird());
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> getSuccessors(STATE STATE, LETTER LETTER) {
        Triple<STATE, STATE, Integer> triple = this.mAutomatonMap.get(STATE);
        return this.getComponentalSuccessors(this.mFirstAutomaton.getSuccessors(triple.getFirst(), LETTER), triple.getSecond(), (Integer)triple.getThird());
    }

    private STATE getProducedState(STATE STATE, STATE STATE2, int n) {
        if (n == 3) {
            if (!this.mSecondAutomaton.isAccepting(STATE2) || this.mFirstAutomaton.isFinite(STATE) || this.mSecondAutomaton.isFinite(STATE2)) {
                return null;
            }
            STATE STATE3 = this.mFactory.intersectBuchi(STATE, STATE2, 0);
            this.mAutomatonMap.computeIfAbsent(STATE3, object3 -> new Triple(STATE, STATE2, (Object)0));
            return STATE3;
        }
        STATE STATE4 = this.mFactory.intersectBuchi(STATE, STATE2, n);
        if (!this.mAutomatonMap.containsKey(STATE4)) {
            if (this.mFirstAutomaton.isFinite(STATE) || this.mSecondAutomaton.isFinite(STATE2) ? n != 0 : n == 1 && !this.mFirstAutomaton.isAccepting(STATE)) {
                return null;
            }
            this.mAutomatonMap.put(STATE4, new Triple(STATE, STATE2, (Object)n));
        }
        return STATE4;
    }

    private ArrayList<OutgoingInternalTransition<LETTER, STATE>> getRelatedSuccessors(Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable, STATE STATE, int n) {
        ArrayList<OutgoingInternalTransition<LETTER, STATE>> arrayList = new ArrayList<OutgoingInternalTransition<LETTER, STATE>>();
        for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition : iterable) {
            LETTER LETTER = outgoingInternalTransition.getLetter();
            for (OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition2 : this.mSecondAutomaton.getSuccessors(STATE, LETTER)) {
                STATE STATE2 = this.getProducedState(outgoingInternalTransition.getSucc(), outgoingInternalTransition2.getSucc(), n);
                if (STATE2 == null) continue;
                arrayList.add(new OutgoingInternalTransition<LETTER, STATE>(LETTER, STATE2));
            }
        }
        return arrayList;
    }

    private ArrayList<OutgoingInternalTransition<LETTER, STATE>> getComponentalSuccessors(Iterable<OutgoingInternalTransition<LETTER, STATE>> iterable, STATE STATE, int n) {
        ArrayList<OutgoingInternalTransition<LETTER, STATE>> arrayList = this.getRelatedSuccessors(iterable, STATE, n + 1);
        if (n != 1) {
            arrayList.addAll(this.getRelatedSuccessors(iterable, STATE, n));
        }
        return arrayList;
    }
}

