/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsTotal;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.TotalizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;

public final class Totalize<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mResult;

    public Totalize(AutomataLibraryServices automataLibraryServices, ISinkStateFactory<STATE> iSinkStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        TotalizeNwa<LETTER, ISinkStateFactory<STATE>> totalizeNwa = new TotalizeNwa<LETTER, ISinkStateFactory<STATE>>(iNwaOutgoingLetterAndTransitionProvider, iSinkStateFactory, false);
        this.mResult = new NestedWordAutomatonReachableStates<LETTER, ISinkStateFactory<STATE>>(this.mServices, totalizeNwa);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + " Result " + this.mResult.sizeInformation();
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        boolean bl;
        String string;
        IsEquivalent<LETTER, STATE> isEquivalent;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        }
        if (!(isEquivalent = new IsEquivalent<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.getOperand(), this.getResult())).getResult().booleanValue()) {
            string = isEquivalent.getViolationMessage();
            bl = false;
            assert (false);
        } else if (!new IsTotal<LETTER, STATE>(this.mServices, this.mResult).getResult().booleanValue()) {
            string = "The result is not total.";
            bl = false;
            assert (false);
        } else {
            string = null;
            bl = true;
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        if (!bl) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", string, this.mOperand);
        }
        return bl;
    }
}

