/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.tool.initializer;

import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.FixpointEngineParameters;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ILoopDetector;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ITransitionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.IcfgAbstractStateStorageProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgDebugHelper;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgVariableProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.empty.EmptyDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.dataflow.DataflowDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.livevariable.LiveVariableDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.arraytheory.SMTTheoryDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman.PoormanAbstractDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.VPDomain;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class FixpointEngineFutureParameterFactory {
    private final IIcfg<?> mRoot;
    private final IUltimateServiceProvider mServices;

    public FixpointEngineFutureParameterFactory(IIcfg<?> iIcfg, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mRoot = iIcfg;
        this.mServices = iUltimateServiceProvider;
    }

    public <STATE extends IAbstractState<STATE>> FixpointEngineParameters<STATE, IcfgEdge, IProgramVarOrConst, IcfgLocation> createParamsFuture(IProgressAwareTimer iProgressAwareTimer, ITransitionProvider<IcfgEdge, IcfgLocation> iTransitionProvider, ILoopDetector<IcfgEdge> iLoopDetector) {
        IAbstractDomain<STATE, IcfgEdge> iAbstractDomain = this.selectDomainFutureCfg();
        IcfgAbstractStateStorageProvider icfgAbstractStateStorageProvider = new IcfgAbstractStateStorageProvider(this.mServices, iTransitionProvider);
        RcfgVariableProvider rcfgVariableProvider = new RcfgVariableProvider(this.mRoot.getCfgSmtToolkit(), this.mServices);
        RcfgDebugHelper rcfgDebugHelper = new RcfgDebugHelper(this.mRoot.getCfgSmtToolkit(), this.mServices, this.mRoot.getCfgSmtToolkit().getSymbolTable());
        return new FixpointEngineParameters(this.mServices, IProgramVarOrConst.class).setDomain(iAbstractDomain).setLoopDetector(iLoopDetector).setStorage(icfgAbstractStateStorageProvider).setTransitionProvider(iTransitionProvider).setVariableProvider(rcfgVariableProvider).setDebugHelper(rcfgDebugHelper).setTimer(iProgressAwareTimer);
    }

    public <STATE extends IAbstractState<STATE>> FixpointEngineParameters<STATE, IcfgEdge, IProgramVarOrConst, IcfgLocation> createParamsFuture(IProgressAwareTimer iProgressAwareTimer, ITransitionProvider<IcfgEdge, IcfgLocation> iTransitionProvider, ILoopDetector<IcfgEdge> iLoopDetector, IAbstractDomain<STATE, IcfgEdge> iAbstractDomain) {
        IcfgAbstractStateStorageProvider icfgAbstractStateStorageProvider = new IcfgAbstractStateStorageProvider(this.mServices, iTransitionProvider);
        RcfgVariableProvider rcfgVariableProvider = new RcfgVariableProvider(this.mRoot.getCfgSmtToolkit(), this.mServices);
        RcfgDebugHelper rcfgDebugHelper = new RcfgDebugHelper(this.mRoot.getCfgSmtToolkit(), this.mServices, this.mRoot.getCfgSmtToolkit().getSymbolTable());
        return new FixpointEngineParameters(this.mServices, IProgramVarOrConst.class).setDomain(iAbstractDomain).setLoopDetector(iLoopDetector).setStorage(icfgAbstractStateStorageProvider).setTransitionProvider(iTransitionProvider).setVariableProvider(rcfgVariableProvider).setDebugHelper(rcfgDebugHelper).setTimer(iProgressAwareTimer);
    }

    public <STATE extends IAbstractState<STATE>> FixpointEngineParameters<STATE, IcfgEdge, IProgramVarOrConst, IcfgLocation> addDefaultParamsFuture(FixpointEngineParameters<STATE, IcfgEdge, IProgramVarOrConst, IcfgLocation> fixpointEngineParameters, ITransitionProvider<IcfgEdge, IcfgLocation> iTransitionProvider, ILoopDetector<IcfgEdge> iLoopDetector) {
        IcfgAbstractStateStorageProvider icfgAbstractStateStorageProvider = new IcfgAbstractStateStorageProvider(this.mServices, iTransitionProvider);
        RcfgVariableProvider rcfgVariableProvider = new RcfgVariableProvider(this.mRoot.getCfgSmtToolkit(), this.mServices);
        RcfgDebugHelper rcfgDebugHelper = new RcfgDebugHelper(this.mRoot.getCfgSmtToolkit(), this.mServices, this.mRoot.getCfgSmtToolkit().getSymbolTable());
        return fixpointEngineParameters.setStorage(icfgAbstractStateStorageProvider).setVariableProvider(rcfgVariableProvider).setDebugHelper(rcfgDebugHelper).setTransitionProvider(iTransitionProvider).setLoopDetector(iLoopDetector);
    }

    public <STATE extends IAbstractState<STATE>> FixpointEngineParameters<STATE, IcfgEdge, IProgramVarOrConst, IcfgLocation> createParamsFutureEqualityDomain(IProgressAwareTimer iProgressAwareTimer, ITransitionProvider<IcfgEdge, IcfgLocation> iTransitionProvider, ILoopDetector<IcfgEdge> iLoopDetector) {
        ILogger iLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        VPDomain<IcfgEdge> vPDomain = FixpointEngineFutureParameterFactory.createEqualityDomain(iLogger, this.mRoot, this.mServices, Collections.emptySet(), null);
        IcfgAbstractStateStorageProvider icfgAbstractStateStorageProvider = new IcfgAbstractStateStorageProvider(this.mServices, iTransitionProvider);
        RcfgVariableProvider rcfgVariableProvider = new RcfgVariableProvider(this.mRoot.getCfgSmtToolkit(), this.mServices);
        RcfgDebugHelper rcfgDebugHelper = new RcfgDebugHelper(this.mRoot.getCfgSmtToolkit(), this.mServices, this.mRoot.getCfgSmtToolkit().getSymbolTable());
        return new FixpointEngineParameters(this.mServices, IProgramVarOrConst.class).setDomain(vPDomain).setLoopDetector(iLoopDetector).setStorage(icfgAbstractStateStorageProvider).setTransitionProvider(iTransitionProvider).setVariableProvider(rcfgVariableProvider).setDebugHelper(rcfgDebugHelper).setTimer(iProgressAwareTimer);
    }

    public <STATE extends IAbstractState<STATE>> IAbstractDomain<STATE, IcfgEdge> selectDomainFutureCfg() {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        String string = iPreferenceProvider.getString("Abstract domain for RCFG-of-the-future");
        ILogger iLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        return FixpointEngineFutureParameterFactory.selectDomainFutureCfg(string, iLogger, this.mRoot, this.mServices);
    }

    public static <STATE extends IAbstractState<STATE>> IAbstractDomain<STATE, IcfgEdge> selectDomainFutureCfg(String string, ILogger iLogger, IIcfg<?> iIcfg, IUltimateServiceProvider iUltimateServiceProvider) {
        if (EmptyDomain.class.getSimpleName().equals(string)) {
            return new EmptyDomain<IcfgEdge>();
        }
        if (DataflowDomain.class.getSimpleName().equals(string)) {
            return new DataflowDomain<IcfgEdge>(iLogger);
        }
        if (VPDomain.class.getSimpleName().equals(string)) {
            return FixpointEngineFutureParameterFactory.createEqualityDomain(iLogger, iIcfg, iUltimateServiceProvider, Collections.emptySet(), null);
        }
        if (SMTTheoryDomain.class.getSimpleName().equals(string)) {
            return new SMTTheoryDomain(iUltimateServiceProvider, iIcfg.getCfgSmtToolkit());
        }
        if (LiveVariableDomain.class.getSimpleName().equals(string)) {
            return new LiveVariableDomain<IcfgEdge>(iLogger);
        }
        if (PoormanAbstractDomain.class.getSimpleName().equals(string)) {
            return new PoormanAbstractDomain(iUltimateServiceProvider, iIcfg);
        }
        throw new UnsupportedOperationException(FixpointEngineFutureParameterFactory.getFailureString(string));
    }

    public <DOM extends IAbstractDomain<STATE, IcfgEdge>, STATE extends IAbstractState<STATE>> IAbstractDomain<STATE, IcfgEdge> selectDomainFutureCfg(Class<DOM> clazz, ILogger iLogger) {
        return FixpointEngineFutureParameterFactory.selectDomainFutureCfg(Objects.requireNonNull(clazz).getSimpleName(), iLogger, this.mRoot, this.mServices);
    }

    public static VPDomain<IcfgEdge> createEqualityDomain(ILogger iLogger, IIcfg<?> iIcfg, IUltimateServiceProvider iUltimateServiceProvider, Set<IProgramConst> set, List<String> list) {
        return new VPDomain<IcfgEdge>(iLogger, iUltimateServiceProvider, iIcfg.getCfgSmtToolkit(), set, list, Collections.emptySet());
    }

    private static String getFailureString(String string) {
        return "The value \"" + string + "\" of preference \"Abstract domain for RCFG-of-the-future\" was not considered before! ";
    }
}

