/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.jai.PerspectiveLayoutTransformSupport;
import edu.uci.ics.jung.visualization.jai.PerspectiveTransformSupport;
import edu.uci.ics.jung.visualization.jai.PerspectiveViewTransformSupport;
import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.PerspectiveTransform;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.TransformerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectiveTransformerDemo
extends JApplet {
    private static final long serialVersionUID = -702499007038889493L;
    Graph<String, Number> graph = TestGraphs.getOneComponentGraph();
    Layout<String, Number> graphLayout = new FRLayout<String, Number>(this.graph);
    Graph<String, Number> grid;
    Layout<String, Number> gridLayout;
    VisualizationViewer<String, Number> vv;
    PerspectiveTransformSupport viewSupport;
    PerspectiveTransformSupport layoutSupport;

    public PerspectiveTransformerDemo() {
        ((FRLayout)this.graphLayout).setMaxIterations(1000);
        Dimension preferredSize = new Dimension(600, 600);
        HashMap<String, Point2D> map = new HashMap<String, Point2D>();
        Transformer vlf = TransformerUtils.mapTransformer(map);
        this.grid = this.generateVertexGrid(map, preferredSize, 25);
        this.gridLayout = new StaticLayout<String, Number>(this.grid, vlf, preferredSize);
        final DefaultVisualizationModel<String, Number> visualizationModel = new DefaultVisualizationModel<String, Number>(this.graphLayout, preferredSize);
        this.vv = new VisualizationViewer<String, Number>(visualizationModel, preferredSize);
        PickedState pes = this.vv.getPickedEdgeState();
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(pes, Color.black, Color.red));
        this.vv.getRenderContext().setVertexShapeTransformer(new Transformer<String, Shape>(){

            @Override
            public Shape transform(String v) {
                return new Rectangle2D.Float(-10.0f, -10.0f, 20.0f, 20.0f);
            }
        });
        this.vv.setBackground(Color.white);
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add(gzsp);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        this.viewSupport = new PerspectiveViewTransformSupport<String, Number>(this.vv);
        this.layoutSupport = new PerspectiveLayoutTransformSupport<String, Number>(this.vv);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(PerspectiveTransformerDemo.this.vv, 1.1f, PerspectiveTransformerDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(PerspectiveTransformerDemo.this.vv, 0.9f, PerspectiveTransformerDemo.this.vv.getCenter());
            }
        });
        final JSlider horizontalSlider = new JSlider(-120, 120, 0){

            public Dimension getPreferredSize() {
                return new Dimension(80, super.getPreferredSize().height);
            }
        };
        final JSlider verticalSlider = new JSlider(-120, 120, 0){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 80);
            }
        };
        verticalSlider.setOrientation(1);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int vval = -verticalSlider.getValue();
                int hval = horizontalSlider.getValue();
                Dimension d = PerspectiveTransformerDemo.this.vv.getSize();
                PerspectiveTransform pt = null;
                pt = PerspectiveTransform.getQuadToQuad((float)vval, (float)hval, (float)(d.width - vval), (float)(-hval), (float)(d.width + vval), (float)(d.height + hval), (float)(-vval), (float)(d.height - hval), (float)0.0f, (float)0.0f, (float)d.width, (float)0.0f, (float)d.width, (float)d.height, (float)0.0f, (float)d.height);
                PerspectiveTransformerDemo.this.viewSupport.getPerspectiveTransformer().setPerspectiveTransform(pt);
                PerspectiveTransformerDemo.this.layoutSupport.getPerspectiveTransformer().setPerspectiveTransform(pt);
                PerspectiveTransformerDemo.this.vv.repaint();
            }
        };
        horizontalSlider.addChangeListener(changeListener);
        verticalSlider.addChangeListener(changeListener);
        JPanel perspectivePanel = new JPanel(new BorderLayout());
        JPanel perspectiveCenterPanel = new JPanel(new BorderLayout());
        perspectivePanel.setBorder(BorderFactory.createTitledBorder("Perspective Controls"));
        final JButton center = new JButton("Center");
        center.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                horizontalSlider.setValue(0);
                verticalSlider.setValue(0);
            }
        });
        ButtonGroup radio = new ButtonGroup();
        JRadioButton normal = new JRadioButton("None");
        normal.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean selected;
                boolean bl = selected = e.getStateChange() == 1;
                if (selected) {
                    if (PerspectiveTransformerDemo.this.viewSupport != null) {
                        PerspectiveTransformerDemo.this.viewSupport.deactivate();
                    }
                    if (PerspectiveTransformerDemo.this.layoutSupport != null) {
                        PerspectiveTransformerDemo.this.layoutSupport.deactivate();
                    }
                }
                center.setEnabled(!selected);
                horizontalSlider.setEnabled(!selected);
                verticalSlider.setEnabled(!selected);
            }
        });
        JRadioButton perspectiveView = new JRadioButton("In View");
        perspectiveView.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PerspectiveTransformerDemo.this.viewSupport.activate(e.getStateChange() == 1);
            }
        });
        JRadioButton perspectiveModel = new JRadioButton("In Layout");
        perspectiveModel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                PerspectiveTransformerDemo.this.layoutSupport.activate(e.getStateChange() == 1);
            }
        });
        radio.add(normal);
        radio.add(perspectiveModel);
        radio.add(perspectiveView);
        normal.setSelected(true);
        ButtonGroup graphRadio = new ButtonGroup();
        JRadioButton graphButton = new JRadioButton("Graph");
        graphButton.setSelected(true);
        graphButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    visualizationModel.setGraphLayout(PerspectiveTransformerDemo.this.graphLayout);
                    PerspectiveTransformerDemo.this.vv.repaint();
                }
            }
        });
        JRadioButton gridButton = new JRadioButton("Grid");
        gridButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    visualizationModel.setGraphLayout(PerspectiveTransformerDemo.this.gridLayout);
                    PerspectiveTransformerDemo.this.vv.repaint();
                }
            }
        });
        graphRadio.add(graphButton);
        graphRadio.add(gridButton);
        JPanel modePanel = new JPanel(new GridLayout(2, 1));
        modePanel.setBorder(BorderFactory.createTitledBorder("Display"));
        modePanel.add(graphButton);
        modePanel.add(gridButton);
        JMenuBar menubar = new JMenuBar();
        menubar.add(graphMouse.getModeMenu());
        gzsp.setCorner(menubar);
        JPanel controls = new JPanel(new BorderLayout());
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel perspectiveControls = new JPanel(new GridLayout(3, 1));
        zoomControls.add(plus);
        zoomControls.add(minus);
        perspectiveControls.add(normal);
        perspectiveControls.add(perspectiveModel);
        perspectiveControls.add(perspectiveView);
        controls.add((Component)zoomControls, "West");
        controls.add(modePanel);
        perspectivePanel.add((Component)perspectiveControls, "West");
        perspectiveCenterPanel.add((Component)horizontalSlider, "South");
        perspectivePanel.add((Component)verticalSlider, "East");
        perspectiveCenterPanel.add(center);
        perspectivePanel.add(perspectiveCenterPanel);
        controls.add((Component)perspectivePanel, "East");
        content.add((Component)controls, "South");
    }

    private Graph<String, Number> generateVertexGrid(Map<String, Point2D> map, Dimension d, int interval) {
        int count = d.width / interval * d.height / interval;
        SparseMultigraph<String, Number> graph = new SparseMultigraph<String, Number>();
        String[] v = new String[count];
        for (int i = 0; i < count; ++i) {
            int x = interval * i;
            int y = x / d.width * interval;
            Point2D.Float location = new Point2D.Float(x %= d.width, y);
            v[i] = "" + i;
            map.put(v[i], location);
            graph.addVertex(v[i]);
        }
        return graph;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new PerspectiveTransformerDemo());
        f.pack();
        f.setVisible(true);
    }
}

