/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public final class TypeDeclaration
extends Declaration {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(TypeDeclaration.class);
    boolean isFinite;
    String identifier;
    String[] typeParams;
    ASTType synonym;

    public TypeDeclaration(ILocation iLocation, Attribute[] attributeArray, boolean bl, String string, String[] stringArray) {
        super(iLocation, attributeArray);
        this.isFinite = bl;
        this.identifier = string;
        this.typeParams = stringArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid TypeDeclaration: " + String.valueOf((Object)this);
    }

    public TypeDeclaration(ILocation iLocation, Attribute[] attributeArray, boolean bl, String string, String[] stringArray, ASTType aSTType) {
        super(iLocation, attributeArray);
        this.isFinite = bl;
        this.identifier = string;
        this.typeParams = stringArray;
        this.synonym = aSTType;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid TypeDeclaration: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TypeDeclaration").append('[');
        stringBuffer.append(this.isFinite);
        stringBuffer.append(',').append(this.identifier);
        stringBuffer.append(',');
        if (this.typeParams == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.typeParams.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.typeParams[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append((Object)this.synonym);
        return stringBuffer.append(']').toString();
    }

    public boolean isFinite() {
        return this.isFinite;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String[] getTypeParams() {
        return this.typeParams;
    }

    public ASTType getSynonym() {
        return this.synonym;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.synonym);
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Declaration)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            if (this.synonym != null) {
                this.synonym.accept(generatedBoogieAstVisitor);
            }
            if (this.attributes != null) {
                Attribute[] attributeArray = this.attributes;
                int n = this.attributes.length;
                int n2 = 0;
                while (n2 < n) {
                    Attribute attribute = attributeArray[n2];
                    attribute.accept(generatedBoogieAstVisitor);
                    ++n2;
                }
            }
        }
    }

    @Override
    public Declaration accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Declaration declaration = generatedBoogieAstTransformer.transform(this);
        if (declaration != this) {
            return declaration;
        }
        ASTType aSTType = null;
        if (this.synonym != null) {
            aSTType = this.synonym.accept(generatedBoogieAstTransformer);
        }
        boolean bl = false;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (this.attributes != null) {
            Attribute[] attributeArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute attribute = attributeArray[n2];
                Attribute attribute2 = attribute.accept(generatedBoogieAstTransformer);
                bl = bl || attribute2 != attribute;
                arrayList.add(attribute2);
                ++n2;
            }
        }
        if (bl || this.synonym != aSTType) {
            return new TypeDeclaration(this.loc, arrayList.toArray(new Attribute[0]), this.isFinite, this.identifier, this.typeParams, aSTType);
        }
        return this;
    }
}

