/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AbstractGeneralizedAffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PolyPoNe {
    protected final Script mScript;
    protected final SmtUtils.Junction mJunction;
    private final Set<Term> mPositive = new HashSet<Term>();
    private final Set<Term> mNegative = new HashSet<Term>();
    private final HashRelation<Map<?, Rational>, PolynomialRelation> mPolyRels = new HashRelation();
    private boolean mInconsistent = false;

    PolyPoNe(Script script, SmtUtils.Junction junction) {
        this.mScript = script;
        this.mJunction = junction;
    }

    public boolean isInconsistent() {
        return this.mInconsistent;
    }

    void add(Collection<Term> collection, boolean bl) {
        for (Term term : collection) {
            boolean bl2;
            PolynomialRelation polynomialRelation;
            PolynomialRelation polynomialRelation2 = bl ? PolynomialRelation.of(this.mScript, term, PolynomialRelation.TransformInequality.NONSTRICT2STRICT) : PolynomialRelation.of(this.mScript, term, PolynomialRelation.TransformInequality.STRICT2NONSTRICT);
            if (polynomialRelation2 != null) {
                polynomialRelation = bl ? polynomialRelation2.negate() : polynomialRelation2;
                bl2 = this.addPolyRel(this.mScript, polynomialRelation, true);
                if (!bl2) continue;
                this.mInconsistent = true;
                return;
            }
            polynomialRelation = bl ? SmtUtils.not(this.mScript, term) : term;
            bl2 = this.addNonPolynomial((Term)polynomialRelation);
            if (!bl2) continue;
            this.mInconsistent = true;
            return;
        }
    }

    Term and(List<Term> list) {
        this.add(list, false);
        return this.and();
    }

    Term or(List<Term> list) {
        this.add(list, true);
        return this.or();
    }

    protected final Check checkPolyRel(Script script, PolynomialRelation polynomialRelation, boolean bl) {
        Check check = this.compareToExistingRepresentations(polynomialRelation, bl);
        if (check == Check.INCONSISTENT || check == Check.REDUNDANT) {
            return check;
        }
        assert (check == null);
        PolynomialRelation polynomialRelation2 = polynomialRelation.mul(this.mScript, Rational.MONE);
        Check check2 = this.compareToExistingRepresentations(polynomialRelation2, bl);
        if (check2 == Check.INCONSISTENT || check2 == Check.REDUNDANT) {
            return check2;
        }
        assert (check2 == null);
        return Check.MAYBE_USEFUL;
    }

    private Check compareToExistingRepresentations(PolynomialRelation polynomialRelation, boolean bl) {
        Set set = this.mPolyRels.getImage(polynomialRelation.getPolynomialTerm().getAbstractVariable2Coefficient());
        ArrayList<PolynomialRelation> arrayList = new ArrayList<PolynomialRelation>();
        block5: for (PolynomialRelation polynomialRelation2 : set) {
            AbstractGeneralizedAffineTerm.ComparisonResult comparisonResult = AbstractGeneralizedAffineTerm.compareRepresentation(polynomialRelation2, polynomialRelation);
            if (comparisonResult == null) continue;
            switch (comparisonResult) {
                case IMPLIES: 
                case EQUIVALENT: {
                    return Check.REDUNDANT;
                }
                case EXPLIES: {
                    if (!bl) continue block5;
                    arrayList.add(polynomialRelation2);
                    break;
                }
                case INCONSISTENT: {
                    return Check.INCONSISTENT;
                }
                default: {
                    throw new AssertionError((Object)("unknown value " + String.valueOf((Object)comparisonResult)));
                }
            }
        }
        if (bl) {
            for (PolynomialRelation polynomialRelation2 : arrayList) {
                boolean bl2 = this.mPolyRels.removePair(polynomialRelation2.getPolynomialTerm().getAbstractVariable2Coefficient(), (Object)polynomialRelation2);
                assert (bl2) : "nothing removed";
            }
        }
        return null;
    }

    protected PolynomialRelation isFusibleWithExistingRelations(Script script, SmtUtils.Junction junction, PolynomialRelation polynomialRelation) {
        PolynomialRelation polynomialRelation2 = this.isFusibleWithExistingRepresentation(junction, polynomialRelation);
        if (polynomialRelation2 != null) {
            return polynomialRelation2;
        }
        PolynomialRelation polynomialRelation3 = polynomialRelation.mul(this.mScript, Rational.MONE);
        PolynomialRelation polynomialRelation4 = this.isFusibleWithExistingRepresentation(junction, polynomialRelation3);
        if (polynomialRelation4 != null) {
            return polynomialRelation4;
        }
        return null;
    }

    private PolynomialRelation isFusibleWithExistingRepresentation(SmtUtils.Junction junction, PolynomialRelation polynomialRelation) {
        Set set = this.mPolyRels.getImage(polynomialRelation.getPolynomialTerm().getAbstractVariable2Coefficient());
        for (PolynomialRelation polynomialRelation2 : set) {
            boolean bl = AbstractGeneralizedAffineTerm.areRepresentationsFusible(junction, polynomialRelation2, polynomialRelation);
            if (!bl) continue;
            return polynomialRelation2;
        }
        return null;
    }

    protected boolean addPolyRel(Script script, PolynomialRelation polynomialRelation, boolean bl) {
        if (this.mInconsistent) {
            throw new AssertionError((Object)"must not add if already inconsistent");
        }
        Check check = this.checkPolyRel(script, polynomialRelation, bl);
        if (check == Check.MAYBE_USEFUL) {
            PolynomialRelation polynomialRelation2;
            if (polynomialRelation.getRelationSymbol().isConvexInequality() && (polynomialRelation2 = this.isFusibleWithExistingRelations(this.mScript, SmtUtils.Junction.AND, polynomialRelation)) != null) {
                this.mPolyRels.removePair(polynomialRelation2.getPolynomialTerm().getAbstractVariable2Coefficient(), (Object)polynomialRelation2);
                PolynomialRelation polynomialRelation3 = PolynomialRelation.of(polynomialRelation.getPolynomialTerm(), RelationSymbol.EQ);
                this.mPolyRels.addPair(polynomialRelation3.getPolynomialTerm().getAbstractVariable2Coefficient(), (Object)polynomialRelation3);
                return false;
            }
            this.mPolyRels.addPair(polynomialRelation.getPolynomialTerm().getAbstractVariable2Coefficient(), (Object)polynomialRelation);
            return false;
        }
        if (check == Check.REDUNDANT) {
            return false;
        }
        if (check == Check.INCONSISTENT) {
            return true;
        }
        throw new AssertionError((Object)("unknown value " + String.valueOf((Object)check)));
    }

    protected final boolean addNonPolynomial(Term term) {
        if (this.mInconsistent) {
            throw new AssertionError((Object)"must not add if already inconsistent");
        }
        Term term2 = SmtUtils.unzipNot(term);
        boolean bl = term2 != null ? this.addNegative(term2) : this.addPositive(term);
        return bl;
    }

    protected Check checkNegative(Term term) {
        Check check;
        if (this.mNegative.contains(term)) {
            assert (!this.mPositive.contains(term));
            check = Check.REDUNDANT;
        } else {
            check = this.mPositive.contains(term) ? Check.INCONSISTENT : Check.MAYBE_USEFUL;
        }
        return check;
    }

    private final boolean addNegative(Term term) {
        Check check = this.checkNegative(term);
        return switch (check) {
            case Check.INCONSISTENT -> true;
            case Check.MAYBE_USEFUL -> {
                this.mNegative.add(term);
                yield false;
            }
            case Check.REDUNDANT -> false;
            default -> throw new AssertionError((Object)("unknown value " + String.valueOf((Object)check)));
        };
    }

    protected Check checkPositive(Term term) {
        Check check;
        if (this.mPositive.contains(term)) {
            assert (!this.mNegative.contains(term));
            check = Check.REDUNDANT;
        } else {
            check = this.mNegative.contains(term) ? Check.INCONSISTENT : Check.MAYBE_USEFUL;
        }
        return check;
    }

    private final boolean addPositive(Term term) {
        Check check = this.checkPositive(term);
        return switch (check) {
            case Check.INCONSISTENT -> true;
            case Check.MAYBE_USEFUL -> {
                this.mPositive.add(term);
                yield false;
            }
            case Check.REDUNDANT -> false;
            default -> throw new AssertionError((Object)("unknown value " + String.valueOf((Object)check)));
        };
    }

    public final Term and() {
        if (this.mInconsistent) {
            return this.mScript.term("false", new Term[0]);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Map.Entry entry : this.mPolyRels.getSetOfPairs()) {
            arrayList.add(((PolynomialRelation)entry.getValue()).toTerm(this.mScript));
        }
        arrayList.addAll(this.mPositive);
        for (Term term : this.mNegative) {
            arrayList.add(SmtUtils.not(this.mScript, term));
        }
        return SmtUtils.and(this.mScript, arrayList);
    }

    public final Term or() {
        if (this.mInconsistent) {
            return this.mScript.term("true", new Term[0]);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Map.Entry entry : this.mPolyRels.getSetOfPairs()) {
            arrayList.add(((PolynomialRelation)entry.getValue()).negate().toTerm(this.mScript));
        }
        for (Term term : this.mPositive) {
            arrayList.add(SmtUtils.not(this.mScript, term));
        }
        arrayList.addAll(this.mNegative);
        return SmtUtils.or(this.mScript, arrayList);
    }

    protected static enum Check {
        REDUNDANT,
        INCONSISTENT,
        MAYBE_USEFUL;

    }
}

