/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ILiteralCollector;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.generic.LiteralCollection;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.RCFGEdgeVisitor;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RCFGLiteralCollector
extends RCFGEdgeVisitor
implements ILiteralCollector {
    private final Set<String> mLiterals = new HashSet<String>();
    private final Set<BigDecimal> mNumberLiterals = new HashSet<BigDecimal>();
    private final StatementLiteralCollector mStatementLiteralCollector = new StatementLiteralCollector();
    private final LiteralCollection mLiteralCollection;

    public RCFGLiteralCollector(IIcfg<?> iIcfg) {
        this.process(RcfgUtils.getInitialEdges(iIcfg));
        this.mLiteralCollection = new LiteralCollection(this.mNumberLiterals);
    }

    private static boolean isConstant(Term term) {
        return SmtUtils.isConstant((Term)term) || term instanceof ConstantTerm;
    }

    @Override
    public LiteralCollection getLiteralCollection() {
        return this.mLiteralCollection;
    }

    public Collection<BigDecimal> getNumberLiterals() {
        return Collections.unmodifiableCollection(this.mNumberLiterals);
    }

    private <T extends IcfgEdge> void process(Collection<T> collection) {
        ArrayDeque<T> arrayDeque = new ArrayDeque<T>();
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        arrayDeque.addAll(collection);
        while (!arrayDeque.isEmpty()) {
            IcfgEdge icfgEdge = (IcfgEdge)arrayDeque.removeFirst();
            if (!hashSet.add(icfgEdge)) continue;
            this.visit(icfgEdge.getLabel());
            arrayDeque.addAll(((IcfgLocation)icfgEdge.getTarget()).getOutgoingEdges());
        }
    }

    protected void visit(StatementSequence statementSequence) {
        super.visit(statementSequence);
        for (Statement statement : statementSequence.getStatements()) {
            this.mStatementLiteralCollector.processStatement(statement);
        }
    }

    protected void visit(Call call) {
        super.visit(call);
        this.mStatementLiteralCollector.processStatement((Statement)call.getCallStatement());
    }

    protected void visit(IIcfgCallTransition<?> iIcfgCallTransition) {
        super.visit(iIcfgCallTransition);
        this.addConstantsFromTerms(iIcfgCallTransition.getLocalVarsAssignment().getClosedFormula());
    }

    protected void visit(IIcfgInternalTransition<?> iIcfgInternalTransition) {
        super.visit(iIcfgInternalTransition);
        this.addConstantsFromTerms(iIcfgInternalTransition.getTransformula().getClosedFormula());
    }

    private void addConstantsFromTerms(Term term) {
        Set set = SubTermFinder.find((Term)term, RCFGLiteralCollector::isConstant, (boolean)false);
        for (Term term2 : set) {
            if (!(term2 instanceof ConstantTerm)) continue;
            Rational rational = SmtUtils.toRational((ConstantTerm)((ConstantTerm)term2));
            this.mNumberLiterals.add(new BigDecimal(rational.numerator()).divide(new BigDecimal(rational.denominator())));
        }
    }

    public String toString() {
        return this.getLiteralCollection().toString();
    }

    private final class StatementLiteralCollector
    extends BoogieVisitor {
        private boolean mNegate = false;

        private StatementLiteralCollector() {
        }

        protected Statement processStatement(Statement statement) {
            return super.processStatement(statement);
        }

        protected void visit(IntegerLiteral integerLiteral) {
            super.visit(integerLiteral);
            StringBuilder stringBuilder = new StringBuilder();
            if (this.mNegate) {
                stringBuilder.append("-");
            }
            stringBuilder.append(integerLiteral.getValue());
            RCFGLiteralCollector.this.mLiterals.add(stringBuilder.toString());
            BigDecimal bigDecimal = AbsIntUtil.sanitizeBigDecimalValue(integerLiteral.getValue());
            if (this.mNegate) {
                bigDecimal = bigDecimal.negate();
            }
            RCFGLiteralCollector.this.mNumberLiterals.add(bigDecimal);
            this.mNegate = false;
        }

        protected void visit(UnaryExpression unaryExpression) {
            super.visit(unaryExpression);
            if (unaryExpression.getOperator() == UnaryExpression.Operator.ARITHNEGATIVE) {
                this.mNegate = !this.mNegate;
            }
        }

        protected void visit(RealLiteral realLiteral) {
            super.visit(realLiteral);
            StringBuilder stringBuilder = new StringBuilder();
            if (this.mNegate) {
                stringBuilder.append("-");
            }
            stringBuilder.append(realLiteral.getValue());
            RCFGLiteralCollector.this.mLiterals.add(stringBuilder.toString());
            BigDecimal bigDecimal = AbsIntUtil.sanitizeBigDecimalValue(realLiteral.getValue());
            if (this.mNegate) {
                bigDecimal = bigDecimal.negate();
            }
            RCFGLiteralCollector.this.mNumberLiterals.add(bigDecimal);
            this.mNegate = false;
        }
    }
}

