/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqDisjunctiveConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.HeapSepProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IEqualityProvidingState;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqIntermediateState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqStateFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.EqTransitionRelation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.vp.TransFormulaConverterCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EqState
implements IAbstractState<EqState>,
IEqualityProvidingState {
    private final ImmutableSet<IProgramVarOrConst> mPvocs;
    private final EqConstraint<EqNode> mConstraint;
    private final EqStateFactory mFactory;
    private final ILogger mLogger;
    private Map<IcfgEdge, EqIntermediateState> mIntermediateStatesForOutgoinEdges;

    public EqState(EqConstraint<EqNode> eqConstraint, EqNodeAndFunctionFactory eqNodeAndFunctionFactory, EqStateFactory eqStateFactory, Set<IProgramVarOrConst> set) {
        this.mConstraint = eqConstraint;
        this.mFactory = eqStateFactory;
        this.mPvocs = ImmutableSet.copyOf(set);
        this.mLogger = this.mFactory.getLogger();
        assert (this.assertPvocsAreComplete(eqConstraint));
    }

    private boolean assertPvocsAreComplete(EqConstraint<EqNode> eqConstraint) {
        Set set = eqConstraint.getPvocs(this.mFactory.getSymbolTable()).stream().filter(iProgramVarOrConst -> !(iProgramVarOrConst instanceof IProgramOldVar)).filter(iProgramVarOrConst -> !(iProgramVarOrConst instanceof HeapSepProgramConst)).filter(iProgramVarOrConst -> !(iProgramVarOrConst instanceof ProgramConst)).filter(iProgramVarOrConst -> !this.mFactory.getEqConstraintFactory().getNonTheoryLiterals().contains(iProgramVarOrConst)).collect(Collectors.toSet());
        if (!this.mPvocs.containsAll(set)) {
            assert (false);
            return false;
        }
        return true;
    }

    public EqState addVariable(IProgramVarOrConst iProgramVarOrConst) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mPvocs);
        hashSet.add(iProgramVarOrConst);
        return this.mFactory.getEqState(this.mConstraint, hashSet);
    }

    public EqState removeVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.removeVariables(Collections.singleton(iProgramVarOrConst));
    }

    public EqState addVariables(Collection<IProgramVarOrConst> collection) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mPvocs);
        hashSet.addAll(collection);
        return this.mFactory.getEqState(this.mConstraint, hashSet);
    }

    public EqState removeVariables(Collection<IProgramVarOrConst> collection) {
        Set set = collection.stream().map(iProgramVarOrConst -> iProgramVarOrConst.getTerm()).collect(Collectors.toSet());
        EqConstraint eqConstraint = this.mFactory.getEqConstraintFactory().projectExistentially(set, this.mConstraint, false);
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>((Collection<IProgramVarOrConst>)this.mPvocs);
        hashSet.removeAll(collection);
        return this.mFactory.getEqState((EqConstraint<EqNode>)eqConstraint, hashSet);
    }

    public boolean containsVariable(IProgramVarOrConst iProgramVarOrConst) {
        return this.mPvocs.contains((Object)iProgramVarOrConst);
    }

    public EqState renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> map) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public ImmutableSet<IProgramVarOrConst> getVariables() {
        return this.mPvocs;
    }

    public EqState patch(EqState eqState) {
        IAbstractState iAbstractState = this.removeVariables((Collection)eqState.getVariables());
        return iAbstractState.intersect(eqState);
    }

    public EqState intersect(EqState eqState) {
        EqConstraint eqConstraint = this.mFactory.getEqConstraintFactory().conjoin(this.getConstraint(), eqState.getConstraint(), false);
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        hashSet.addAll((Collection<IProgramVarOrConst>)this.getVariables());
        hashSet.addAll((Collection<IProgramVarOrConst>)eqState.getVariables());
        return this.mFactory.getEqState((EqConstraint<EqNode>)eqConstraint, hashSet);
    }

    public EqState union(EqState eqState) {
        EqConstraint eqConstraint = this.mFactory.getEqConstraintFactory().disjoin(this.getConstraint(), eqState.getConstraint());
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        hashSet.addAll((Collection<IProgramVarOrConst>)this.getVariables());
        hashSet.addAll((Collection<IProgramVarOrConst>)eqState.getVariables());
        return this.mFactory.getEqState((EqConstraint<EqNode>)eqConstraint, hashSet);
    }

    public EqState widen(EqState eqState) {
        EqConstraint eqConstraint = this.getConstraint().widen(eqState.getConstraint());
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        hashSet.addAll((Collection<IProgramVarOrConst>)this.getVariables());
        hashSet.addAll((Collection<IProgramVarOrConst>)eqState.getVariables());
        return this.mFactory.getEqState((EqConstraint<EqNode>)eqConstraint, hashSet);
    }

    public boolean isEmpty() {
        return this.mPvocs.isEmpty();
    }

    public boolean isBottom() {
        return this.mConstraint.isBottom();
    }

    public boolean isEqualTo(EqState eqState) {
        return this.isSubsetOf(eqState) == IAbstractState.SubsetResult.EQUAL || this.isSubsetOf(eqState) == IAbstractState.SubsetResult.NON_STRICT && eqState.isSubsetOf(this) == IAbstractState.SubsetResult.NON_STRICT;
    }

    public IAbstractState.SubsetResult isSubsetOf(EqState eqState) {
        if (this.mConstraint.isTop() && eqState.mConstraint.isTop()) {
            return IAbstractState.SubsetResult.EQUAL;
        }
        if (this.mConstraint.isBottom() && eqState.mConstraint.isBottom()) {
            return IAbstractState.SubsetResult.EQUAL;
        }
        if (this.mConstraint.isBottom()) {
            return IAbstractState.SubsetResult.STRICT;
        }
        if (eqState.mConstraint.isTop()) {
            return IAbstractState.SubsetResult.STRICT;
        }
        if (this.mConstraint.isStrongerThan(eqState.mConstraint)) {
            return IAbstractState.SubsetResult.NON_STRICT;
        }
        return IAbstractState.SubsetResult.NONE;
    }

    public EqState compact() {
        return this.mFactory.getEqState(this.mConstraint, this.mConstraint.getPvocs(this.mFactory.getSymbolTable()));
    }

    public Term getTerm(Script script) {
        return this.mConstraint.getTerm(script);
    }

    public String toLogString() {
        return this.mPvocs.toString() + "\n" + this.mConstraint.toLogString();
    }

    public String toString() {
        return this.mPvocs.toString() + "\n" + this.mConstraint.toString();
    }

    public EqConstraint<EqNode> getConstraint() {
        return this.mConstraint;
    }

    public EqPredicate toEqPredicate() {
        return this.mFactory.stateToPredicate(this);
    }

    public boolean areUnequal(EqNode eqNode, EqNode eqNode2, boolean bl) {
        return this.mConstraint.areUnequal((IEqNodeIdentifier)eqNode, (IEqNodeIdentifier)eqNode2, bl);
    }

    public boolean areEqual(Term term, Term term2) {
        boolean bl = this.mFactory.getVpDomainSettings().isAddNodesBeforeAnsweringQuery();
        EqNode eqNode = this.mFactory.getEqNodeAndFunctionFactory().getExistingNode(term);
        EqNode eqNode2 = this.mFactory.getEqNodeAndFunctionFactory().getExistingNode(term2);
        if (eqNode == null && !bl) {
            this.mLogger.debug((Object)("areEqual request: Term " + String.valueOf(term) + " is not known to this EqState, returning false"));
            return false;
        }
        if (eqNode == null && bl) {
            eqNode = this.mFactory.getEqNodeAndFunctionFactory().getOrConstructNode(term);
        }
        if (eqNode2 == null && !bl) {
            this.mLogger.debug((Object)("areEqual request: Term " + String.valueOf(term2) + " is not known to this EqState, returning false"));
            return false;
        }
        if (eqNode2 == null && bl) {
            eqNode2 = this.mFactory.getEqNodeAndFunctionFactory().getOrConstructNode(term2);
        }
        return this.mConstraint.areEqual((IEqNodeIdentifier)eqNode, (IEqNodeIdentifier)eqNode2, bl);
    }

    public boolean areUnequal(Term term, Term term2) {
        boolean bl = this.mFactory.getVpDomainSettings().isAddNodesBeforeAnsweringQuery();
        EqNode eqNode = this.mFactory.getEqNodeAndFunctionFactory().getExistingNode(term);
        EqNode eqNode2 = this.mFactory.getEqNodeAndFunctionFactory().getExistingNode(term2);
        if (eqNode == null && !bl) {
            this.mLogger.debug((Object)("areUnequal request: Term " + String.valueOf(term) + " is not known to this EqState, returning false"));
            return false;
        }
        if (eqNode == null && bl) {
            eqNode = this.mFactory.getEqNodeAndFunctionFactory().getOrConstructNode(term);
        }
        if (eqNode2 == null && !bl) {
            this.mLogger.debug((Object)("areUnequal request: Term " + String.valueOf(term2) + " is not known to this EqState, returning false"));
            return false;
        }
        if (eqNode2 == null && bl) {
            eqNode2 = this.mFactory.getEqNodeAndFunctionFactory().getOrConstructNode(term2);
        }
        return this.mConstraint.areUnequal((IEqNodeIdentifier)eqNode, (IEqNodeIdentifier)eqNode2, bl);
    }

    public int hashCode() {
        return Objects.hash(this.mConstraint, this.mPvocs);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EqState eqState = (EqState)object;
        if (this.mConstraint == null ? eqState.mConstraint != null : !this.mConstraint.equals(eqState.mConstraint)) {
            return false;
        }
        return !(this.mPvocs == null ? eqState.mPvocs != null : !this.mPvocs.equals(eqState.mPvocs));
    }

    public IEqualityProvidingState join(IEqualityProvidingState iEqualityProvidingState) {
        return this.union((EqState)iEqualityProvidingState);
    }

    public EqIntermediateState getIntermediateStateForOutgoingEdge(IcfgEdge icfgEdge) {
        if (this.mIntermediateStatesForOutgoinEdges == null) {
            this.mIntermediateStatesForOutgoinEdges = new HashMap<IcfgEdge, EqIntermediateState>();
        }
        Map<Term, Term> map = this.getSubstitutionForPredecessor((TransFormula)icfgEdge.getTransformula());
        EqIntermediateState eqIntermediateState = this.mIntermediateStatesForOutgoinEdges.get(icfgEdge);
        if (eqIntermediateState == null) {
            TransFormulaConverterCache transFormulaConverterCache = this.mFactory.getTransformulaConverter();
            EqTransitionRelation eqTransitionRelation = transFormulaConverterCache.getTransitionRelationForTransformula((TransFormula)icfgEdge.getTransformula());
            EqConstraintFactory<EqNode> eqConstraintFactory = this.mFactory.getEqConstraintFactory();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            EqDisjunctiveConstraint eqDisjunctiveConstraint = eqConstraintFactory.renameVariables(eqConstraintFactory.getDisjunctiveConstraint(Collections.singleton(this.mConstraint)), map);
            arrayList.add(eqDisjunctiveConstraint);
            arrayList.add(eqTransitionRelation.getEqConstraint());
            EqDisjunctiveConstraint eqDisjunctiveConstraint2 = eqConstraintFactory.conjoinDisjunctiveConstraints(arrayList);
            EqDisjunctiveConstraint eqDisjunctiveConstraint3 = eqConstraintFactory.closeIfNecessary(eqDisjunctiveConstraint2);
            eqIntermediateState = new EqIntermediateState((EqDisjunctiveConstraint<EqNode>)eqDisjunctiveConstraint3);
        }
        return eqIntermediateState;
    }

    private Map<Term, Term> getSubstitutionForPredecessor(TransFormula transFormula) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Map.Entry entry : transFormula.getInVars().entrySet()) {
            IProgramVar iProgramVar = (IProgramVar)entry.getKey();
            if (!this.getVariables().contains((Object)iProgramVar)) continue;
            hashMap.put((Term)iProgramVar.getTermVariable(), (Term)entry.getValue());
        }
        return hashMap;
    }
}

