/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.IteratedSymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Loop {
    private final IcfgLocation mLoopHead;
    private final ManagedScript mScript;
    private Term mCondition;
    private Set<IcfgEdge> mPath = null;
    private final Set<IcfgLocation> mNodes = new HashSet<IcfgLocation>();
    private Deque<Backbone> mBackbones;
    private IteratedSymbolicMemory mIteratedMemory;
    private final List<TermVariable> mAuxVars;
    private final Map<IcfgLocation, Backbone> mErrorPaths;
    private final Deque<Loop> mNestedLoops;
    private Map<IProgramVar, TermVariable> mInVars;
    private Map<IProgramVar, TermVariable> mOutVars;
    private IcfgLocation mLoopExit;
    private final List<IcfgEdge> mExitTransitions;
    private final List<UnmodifiableTransFormula> mExitConditions;
    private UnmodifiableTransFormula mFormula;

    public Loop(IcfgLocation icfgLocation, ManagedScript managedScript) {
        this.mLoopHead = icfgLocation;
        this.mScript = managedScript;
        this.mBackbones = new ArrayDeque<Backbone>();
        this.mCondition = null;
        this.mIteratedMemory = null;
        this.mAuxVars = new ArrayList<TermVariable>();
        this.mErrorPaths = new HashMap<IcfgLocation, Backbone>();
        this.mNestedLoops = new ArrayDeque<Loop>();
        this.mInVars = new HashMap<IProgramVar, TermVariable>();
        this.mOutVars = new HashMap<IProgramVar, TermVariable>();
        this.mLoopExit = null;
        this.mExitConditions = new ArrayList<UnmodifiableTransFormula>();
        this.mExitTransitions = new ArrayList<IcfgEdge>();
        this.mFormula = null;
    }

    public Term updateVars(Term term, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        if (SmtUtils.isFalseLiteral((Term)term)) {
            return term;
        }
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>(this.mInVars);
        HashMap<IProgramVar, TermVariable> hashMap2 = new HashMap<IProgramVar, TermVariable>(this.mOutVars);
        HashMap<Term, Term> hashMap3 = new HashMap<Term, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : map.entrySet()) {
            if (this.mInVars.containsKey(entry.getKey()) && this.mInVars.get(entry.getKey()).equals(this.mOutVars.get(entry.getKey())) && !map2.get(entry.getKey()).equals(map.get(entry.getKey()))) {
                hashMap.put(entry.getKey(), this.mInVars.get(entry.getKey()));
                hashMap2.put(entry.getKey(), map2.get(entry.getKey()));
                hashMap3.put((Term)entry.getValue(), (Term)this.mInVars.get(entry.getKey()));
                continue;
            }
            if (!this.mInVars.containsKey(entry.getKey())) {
                hashMap.put(entry.getKey(), entry.getValue());
                hashMap3.put((Term)entry.getValue(), (Term)entry.getValue());
                continue;
            }
            hashMap.put(entry.getKey(), this.mInVars.get(entry.getKey()));
            hashMap3.put((Term)entry.getValue(), (Term)this.mInVars.get(entry.getKey()));
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : map2.entrySet()) {
            if (this.mInVars.containsKey(entry.getKey()) && this.mInVars.get(entry.getKey()).equals(this.mOutVars.get(entry.getKey())) && !map2.get(entry.getKey()).equals(map.get(entry.getKey()))) continue;
            if (!this.mOutVars.containsKey(entry.getKey())) {
                hashMap2.put(entry.getKey(), entry.getValue());
                hashMap3.put((Term)entry.getValue(), (Term)entry.getValue());
                continue;
            }
            hashMap2.put(entry.getKey(), this.mOutVars.get(entry.getKey()));
            hashMap3.put((Term)entry.getValue(), (Term)this.mOutVars.get(entry.getKey()));
        }
        this.setInVars(hashMap);
        this.setOutVars(hashMap2);
        return Substitution.apply((ManagedScript)this.mScript, hashMap3, (Term)term);
    }

    public void setBackbones(Deque<Backbone> deque) {
        this.mBackbones = deque;
    }

    public Set<IcfgEdge> getPath() {
        return this.mPath;
    }

    public Deque<Backbone> getBackbones() {
        return this.mBackbones;
    }

    public Term getCondition() {
        return this.mCondition;
    }

    public Map<IcfgLocation, Backbone> getErrorPaths() {
        return this.mErrorPaths;
    }

    public IteratedSymbolicMemory getIteratedMemory() {
        return this.mIteratedMemory;
    }

    public UnmodifiableTransFormula getFormula() {
        return this.mFormula;
    }

    public List<TermVariable> getVars() {
        return this.mAuxVars;
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    public IcfgLocation getLoopExit() {
        return this.mLoopExit;
    }

    public List<UnmodifiableTransFormula> getExitConditions() {
        return this.mExitConditions;
    }

    public List<IcfgEdge> getExitTransitions() {
        return this.mExitTransitions;
    }

    public IcfgLocation getLoophead() {
        return this.mLoopHead;
    }

    public Deque<Loop> getNestedLoops() {
        return this.mNestedLoops;
    }

    public void setPath(Set<IcfgEdge> set) {
        this.mPath = set;
        for (IcfgEdge icfgEdge : set) {
            this.mNodes.add((IcfgLocation)icfgEdge.getSource());
        }
    }

    public void setLoopExit(IcfgLocation icfgLocation) {
        for (IcfgEdge icfgEdge : icfgLocation.getIncomingEdges()) {
            if (!this.mNodes.contains(icfgEdge.getSource())) continue;
            this.mExitTransitions.add(icfgEdge);
        }
        this.mLoopExit = icfgLocation;
    }

    public void addExitCondition(UnmodifiableTransFormula unmodifiableTransFormula) {
        this.mExitConditions.add(unmodifiableTransFormula);
    }

    public void addErrorPath(IcfgLocation icfgLocation, Backbone backbone) {
        this.mErrorPaths.put(icfgLocation, backbone);
    }

    public void replaceErrorPath(IcfgLocation icfgLocation, Backbone backbone) {
        this.mErrorPaths.replace(icfgLocation, backbone);
    }

    public void addNestedLoop(Loop loop) {
        if (!this.mNestedLoops.contains(loop)) {
            this.mNestedLoops.addLast(loop);
        }
    }

    public void setFormula(UnmodifiableTransFormula unmodifiableTransFormula) {
        this.mFormula = unmodifiableTransFormula;
    }

    public void setCondition(Term term) {
        this.mCondition = term;
    }

    public void setInVars(Map<IProgramVar, TermVariable> map) {
        this.mInVars = map;
    }

    public void setOutVars(Map<IProgramVar, TermVariable> map) {
        this.mOutVars = map;
    }

    public void setIteratedSymbolicMemory(IteratedSymbolicMemory iteratedSymbolicMemory) {
        this.mIteratedMemory = iteratedSymbolicMemory;
    }

    public void addVar(List<TermVariable> list) {
        this.mAuxVars.addAll(list);
    }

    public String toString() {
        return this.mPath.toString();
    }

    public String backbonesToString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Backbone backbone : this.mBackbones) {
            stringBuilder.append(backbone.toString());
        }
        return stringBuilder.toString();
    }
}

