/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.models;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BasePayloadContainer;
import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILabeledEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.IWalkable;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseLabeledEdgesMultigraph<T extends BaseLabeledEdgesMultigraph<T, L>, L>
extends BasePayloadContainer
implements ILabeledEdgesMultigraph<T, L, VisualizationNode> {
    private static final long serialVersionUID = 1L;
    protected List<T> mOutgoingNodes;
    protected List<T> mIncomingNodes;
    protected List<L> mOutgoingEdgeLabels = new ArrayList<L>();

    protected BaseLabeledEdgesMultigraph() {
        this(null, null, null);
    }

    protected BaseLabeledEdgesMultigraph(IPayload iPayload) {
        this(null, null, iPayload);
    }

    protected BaseLabeledEdgesMultigraph(T t) {
        this(t, null, null);
    }

    protected BaseLabeledEdgesMultigraph(T t, L l) {
        this(t, l, null);
    }

    protected BaseLabeledEdgesMultigraph(T t, L l, IPayload iPayload) {
        super(iPayload);
        this.mOutgoingNodes = new ArrayList<T>();
        this.mIncomingNodes = new ArrayList<T>();
        if (t != null) {
            ((BaseLabeledEdgesMultigraph)t).mOutgoingEdgeLabels.add(l);
            ((BaseLabeledEdgesMultigraph)t).mOutgoingNodes.add(this);
            this.mIncomingNodes.add(t);
        }
    }

    public List<T> getIncomingNodes() {
        return this.mIncomingNodes;
    }

    public List<T> getOutgoingNodes() {
        return this.mOutgoingNodes;
    }

    public L getOutgoingEdgeLabel(T t) {
        return this.mOutgoingEdgeLabels.get(this.mOutgoingNodes.indexOf(t));
    }

    public L getIncomingEdgeLabel(T t) {
        if (t != null) {
            return ((BaseLabeledEdgesMultigraph)t).mOutgoingEdgeLabels.get(((BaseLabeledEdgesMultigraph)t).mOutgoingNodes.indexOf(this));
        }
        return null;
    }

    public VisualizationNode getVisualizationGraph() {
        return new VisualizationNode(this);
    }

    public List<IWalkable> getSuccessors() {
        return this.getOutgoingNodes();
    }

    public List<L> getOutgoingEdgeLabels() {
        return this.mOutgoingEdgeLabels;
    }
}

