/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST;

import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.BinaryOperatorAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;

public class BinaryExpressionAST
extends AtsASTNode {
    private static final long serialVersionUID = 561094736879070816L;
    private BinaryOperatorAST moperator;

    public BinaryExpressionAST(ILocation iLocation) {
        super(iLocation);
        this.setBothTypesTo(Integer.class);
    }

    private void setBothTypesTo(Class<?> clazz) {
        this.mReturnType = clazz;
        this.mExpectingType = clazz;
    }

    public BinaryExpressionAST(ILocation iLocation, AtsASTNode atsASTNode, AtsASTNode atsASTNode2) {
        super(iLocation);
        this.setBothTypesTo(Integer.class);
        this.addOutgoingNode(atsASTNode);
        this.addOutgoingNode(atsASTNode2);
    }

    public void setOperator(BinaryOperatorAST binaryOperatorAST) {
        this.moperator = binaryOperatorAST;
        if (binaryOperatorAST == BinaryOperatorAST.PLUS) {
            for (AtsASTNode atsASTNode : this.getOutgoingNodes()) {
                if (atsASTNode.getReturnType() != String.class) continue;
                this.setBothTypesTo(String.class);
                break;
            }
        }
    }

    public BinaryOperatorAST getOperator() {
        return this.moperator;
    }

    public String getOperatorAsString() {
        return BinaryExpressionAST.operatorToString(this.moperator);
    }

    public String toString() {
        return "BinaryExpression [Operator: " + BinaryExpressionAST.operatorToString(this.moperator) + "]";
    }

    private static String operatorToString(BinaryOperatorAST binaryOperatorAST) {
        return switch (binaryOperatorAST) {
            case BinaryOperatorAST.PLUS -> " + ";
            case BinaryOperatorAST.MINUS -> " - ";
            case BinaryOperatorAST.MULTIPLICATION -> " * ";
            case BinaryOperatorAST.DIVISION -> " / ";
            case BinaryOperatorAST.MODULO -> " % ";
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public String getAsString() {
        if (this.mChildren.size() == 2) {
            return ((AtsASTNode)((Object)this.mChildren.get(0))).getAsString() + BinaryExpressionAST.operatorToString(this.moperator) + ((AtsASTNode)((Object)this.mChildren.get(1))).getAsString();
        }
        return "";
    }
}

